/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.broadcasters;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.config.SpawnNotificationConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001a\u001a\u0004\b\u001d\u0010\u001cR\u0019\u0010\n\u001a\u0004\u0018\u00010\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0014\u0010$\u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010&\u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0016\u0010*\u001a\u0004\u0018\u00010'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0016\u0010,\u001a\u0004\u0018\u00010'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0014\u0010.\u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010#\u00a8\u0006/"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/broadcasters/SpawnBroadcaster;", "", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/core/BlockPos;", "coords", "Lnet/minecraft/resources/ResourceLocation;", "biome", "dimension", "Lnet/minecraft/server/level/ServerPlayer;", "player", "<init>", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/core/BlockPos;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/level/ServerPlayer;)V", "", "Lnet/minecraft/network/chat/Component;", "getBroadcast", "()Ljava/util/List;", "buildXaerosWaypoint", "()Lnet/minecraft/network/chat/Component;", "buildJourneyMapWaypoint", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getPokemon", "()Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lnet/minecraft/core/BlockPos;", "getCoords", "()Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/resources/ResourceLocation;", "getBiome", "()Lnet/minecraft/resources/ResourceLocation;", "getDimension", "Lnet/minecraft/server/level/ServerPlayer;", "getPlayer", "()Lnet/minecraft/server/level/ServerPlayer;", "", "getShiny", "()Z", "shiny", "getBlacklisted", "blacklisted", "", "getLabel", "()Ljava/lang/String;", "label", "getBucket", "bucket", "getShouldBroadcast", "shouldBroadcast", "cobblemon-spawn-notification"})
@SourceDebugExtension(value={"SMAP\nSpawnBroadcaster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnBroadcaster.kt\nus/timinc/mc/cobblemon/spawnnotification/broadcasters/SpawnBroadcaster\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1761#2,3:134\n295#2,2:137\n295#2,2:139\n2746#2,3:141\n*S KotlinDebug\n*F\n+ 1 SpawnBroadcaster.kt\nus/timinc/mc/cobblemon/spawnnotification/broadcasters/SpawnBroadcaster\n*L\n22#1:134,3\n28#1:137,2\n30#1:139,2\n36#1:141,3\n*E\n"})
public final class SpawnBroadcaster {
    @NotNull
    private final Pokemon pokemon;
    @NotNull
    private final BlockPos coords;
    @NotNull
    private final ResourceLocation biome;
    @NotNull
    private final ResourceLocation dimension;
    @Nullable
    private final ServerPlayer player;

    public SpawnBroadcaster(@NotNull Pokemon pokemon, @NotNull BlockPos coords, @NotNull ResourceLocation biome, @NotNull ResourceLocation dimension, @Nullable ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        Intrinsics.checkNotNullParameter((Object)biome, (String)"biome");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.pokemon = pokemon;
        this.coords = coords;
        this.biome = biome;
        this.dimension = dimension;
        this.player = player;
    }

    @NotNull
    public final Pokemon getPokemon() {
        return this.pokemon;
    }

    @NotNull
    public final BlockPos getCoords() {
        return this.coords;
    }

    @NotNull
    public final ResourceLocation getBiome() {
        return this.biome;
    }

    @NotNull
    public final ResourceLocation getDimension() {
        return this.dimension;
    }

    @Nullable
    public final ServerPlayer getPlayer() {
        return this.player;
    }

    private final boolean getShiny() {
        return this.pokemon.getShiny();
    }

    private final boolean getBlacklisted() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = SpawnNotification.INSTANCE.getConfig().getBlacklistForBroadcast();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!PokemonProperties.Companion.parse$default((PokemonProperties.Companion)PokemonProperties.Companion, (String)it, null, null, (int)6, null).matches(this.pokemon)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String getLabel() {
        String string;
        if (this.getBlacklisted()) {
            string = null;
        } else {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = this.pokemon.getForm().getLabels();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!SpawnNotification.INSTANCE.getConfig().getLabelsForBroadcast().contains(it)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            string = v1;
        }
        return string;
    }

    private final String getBucket() {
        String string;
        if (this.getBlacklisted() || !this.pokemon.getPersistentData().contains("spawn_notification:bucket")) {
            string = null;
        } else {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = SpawnNotification.INSTANCE.getConfig().getBucketsForBroadcast();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)this.pokemon.getPersistentData().getString("spawn_notification:bucket"))) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            string = v1;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getShouldBroadcast() {
        String it;
        if (!(this.getShiny() && SpawnNotification.INSTANCE.getConfig().getBroadcastShiny() || this.getLabel() != null)) {
            if (this.getBucket() == null) return false;
        }
        Iterable $this$none$iv = SpawnNotification.INSTANCE.getConfig().getBlacklistForBroadcastEvenIfShiny();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!PokemonProperties.Companion.parse$default((PokemonProperties.Companion)PokemonProperties.Companion, (String)it, null, null, (int)6, null).matches(this.pokemon));
        return false;
    }

    @NotNull
    public final List<Component> getBroadcast() {
        String string;
        String string2;
        Object[] objectArray;
        if (!this.getShouldBroadcast()) {
            return CollectionsKt.emptyList();
        }
        List list = new ArrayList();
        SpawnNotificationConfig spawnNotificationConfig = SpawnNotification.INSTANCE.getConfig();
        Object[] objectArray2 = new Object[9];
        if (this.getShiny() && SpawnNotification.INSTANCE.getConfig().getBroadcastShiny()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("shiny", new Object[0])};
            v1 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.shiny", objectArray);
        } else {
            v1 = objectArray2[0] = "";
        }
        if (this.getLabel() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("label." + this.getLabel(), new Object[0])};
            v2 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.label", objectArray);
        } else {
            v2 = objectArray2[1] = "";
        }
        if (this.getBucket() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("bucket." + this.getBucket(), new Object[0])};
            string2 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.bucket", objectArray);
        } else {
            string2 = "";
        }
        objectArray2[2] = string2;
        Object object = objectArray2[3] = SpawnNotification.INSTANCE.getConfig().getBroadcastSpeciesName() ? this.pokemon.getSpecies().getTranslatedName() : Component.translatable((String)"cobblemon.entity.pokemon");
        if (SpawnNotification.INSTANCE.getConfig().getBroadcastBiome()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getRawComponent("biome." + this.biome.toLanguageKey(), new Object[0])};
            v5 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.biome", objectArray);
        } else {
            v5 = objectArray2[4] = "";
        }
        if (SpawnNotification.INSTANCE.getConfig().getBroadcastCoords()) {
            objectArray = new Object[]{this.coords.getX(), this.coords.getY(), this.coords.getZ()};
            v6 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.coords", objectArray);
        } else {
            v6 = objectArray2[5] = "";
        }
        if (SpawnNotification.INSTANCE.getConfig().getAnnounceCrossDimensions()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getRawComponent("dimension." + this.dimension.toLanguageKey(), new Object[0])};
            v7 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.dimension", objectArray);
        } else {
            v7 = objectArray2[6] = "";
        }
        if (SpawnNotification.INSTANCE.getConfig().getBroadcastPlayerSpawnedOn() && this.player != null) {
            objectArray = new Object[]{this.player.getName()};
            string = SpawnNotification.INSTANCE.getConfig().getComponent("notification.player", objectArray);
        } else {
            string = "";
        }
        objectArray2[7] = string;
        objectArray2[8] = SpawnNotification.INSTANCE.getConfig().getBroadcastJourneyMapWaypoints() ? this.buildJourneyMapWaypoint() : "";
        list.add(spawnNotificationConfig.getComponent("notification.spawn", objectArray2));
        if (SpawnNotification.INSTANCE.getConfig().getBroadcastXaerosWaypoints()) {
            list.add(this.buildXaerosWaypoint());
        }
        return list;
    }

    private final Component buildXaerosWaypoint() {
        String string;
        Object[] objectArray;
        SpawnNotificationConfig spawnNotificationConfig = SpawnNotification.INSTANCE.getConfig();
        Object[] objectArray2 = new Object[8];
        if (this.getShiny() && SpawnNotification.INSTANCE.getConfig().getBroadcastShiny()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("shiny", new Object[0])};
            v1 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.shiny", objectArray);
        } else {
            v1 = objectArray2[0] = "";
        }
        if (this.getLabel() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("label." + this.getLabel(), new Object[0])};
            v2 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.label", objectArray);
        } else {
            v2 = objectArray2[1] = "";
        }
        if (this.getBucket() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("bucket." + this.getBucket(), new Object[0])};
            string = SpawnNotification.INSTANCE.getConfig().getComponent("notification.bucket", objectArray);
        } else {
            string = "";
        }
        objectArray2[2] = string;
        objectArray2[3] = SpawnNotification.INSTANCE.getConfig().getBroadcastSpeciesName() ? this.pokemon.getSpecies().getTranslatedName() : Component.translatable((String)"cobblemon.entity.pokemon");
        objectArray2[4] = this.coords.getX();
        objectArray2[5] = this.coords.getY();
        objectArray2[6] = this.coords.getZ();
        objectArray2[7] = this.dimension.getPath();
        return spawnNotificationConfig.getComponent("notification.waypoints.xaeros", objectArray2);
    }

    private final Component buildJourneyMapWaypoint() {
        String string;
        Object[] objectArray;
        SpawnNotificationConfig spawnNotificationConfig = SpawnNotification.INSTANCE.getConfig();
        Object[] objectArray2 = new Object[8];
        if (this.getShiny() && SpawnNotification.INSTANCE.getConfig().getBroadcastShiny()) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("shiny", new Object[0])};
            v1 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.shiny", objectArray);
        } else {
            v1 = objectArray2[0] = "";
        }
        if (this.getLabel() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("label." + this.getLabel(), new Object[0])};
            v2 = SpawnNotification.INSTANCE.getConfig().getComponent("notification.label", objectArray);
        } else {
            v2 = objectArray2[1] = "";
        }
        if (this.getBucket() != null) {
            objectArray = new Object[]{SpawnNotification.INSTANCE.getConfig().getComponent("bucket." + this.getBucket(), new Object[0])};
            string = SpawnNotification.INSTANCE.getConfig().getComponent("notification.bucket", objectArray);
        } else {
            string = "";
        }
        objectArray2[2] = string;
        objectArray2[3] = SpawnNotification.INSTANCE.getConfig().getBroadcastSpeciesName() ? this.pokemon.getSpecies().getTranslatedName() : Component.translatable((String)"cobblemon.entity.pokemon");
        objectArray2[4] = this.coords.getX();
        objectArray2[5] = this.coords.getY();
        objectArray2[6] = this.coords.getZ();
        objectArray2[7] = this.dimension.getNamespace() + ":" + this.dimension.getPath();
        return spawnNotificationConfig.getComponent("notification.waypoints.journeymap", objectArray2);
    }
}

