/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.events;

import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonFaintedEvent;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.Iterator;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.broadcasters.FaintBroadcaster;
import us.timinc.mc.cobblemon.spawnnotification.util.Broadcast;
import us.timinc.mc.cobblemon.spawnnotification.util.CompoundTagExtensionsKt;
import us.timinc.mc.cobblemon.spawnnotification.util.IsReallyWildKt;
import us.timinc.mc.cobblemon.spawnnotification.util.PlayerUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\nJ\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0007\u0010\u000fJC\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/events/BroadcastFaint;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/events/pokemon/PokemonFaintedEvent;", "evt", "", "handle", "(Lcom/cobblemon/mod/common/api/events/pokemon/PokemonFaintedEvent;)V", "Lcom/cobblemon/mod/common/api/events/battles/BattleFaintedEvent;", "(Lcom/cobblemon/mod/common/api/events/battles/BattleFaintedEvent;)V", "Lnet/minecraft/world/entity/Entity;", "entity", "Lnet/minecraft/server/level/ServerLevel;", "level", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/server/level/ServerLevel;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/core/BlockPos;", "coords", "Lnet/minecraft/resources/ResourceLocation;", "biome", "dimension", "slayer", "broadcast", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/core/BlockPos;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;)V", "cobblemon-spawn-notification"})
@SourceDebugExtension(value={"SMAP\nBroadcastFaint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BroadcastFaint.kt\nus/timinc/mc/cobblemon/spawnnotification/events/BroadcastFaint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class BroadcastFaint {
    @NotNull
    public static final BroadcastFaint INSTANCE = new BroadcastFaint();

    private BroadcastFaint() {
    }

    public final void handle(@NotNull PokemonFaintedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (!SpawnNotification.INSTANCE.getConfig().getBroadcastFaints()) {
            return;
        }
        if (!IsReallyWildKt.isReallyWild(evt.getPokemon())) {
            return;
        }
        PokemonEntity pokemonEntity = evt.getPokemon().getEntity();
        if (pokemonEntity == null) {
            return;
        }
        PokemonEntity entity = pokemonEntity;
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        LivingEntity lastAttacker = entity.getLastAttacker();
        if (lastAttacker != null) {
            evt.getPokemon().getPersistentData().putUUID("spawn_notification:faint_entity", lastAttacker.getUUID());
            evt.getPokemon().getPersistentData().putBoolean("spawn_notification:should_broadcast_faint", true);
        }
    }

    public final void handle(@NotNull BattleFaintedEvent evt) {
        Pokemon pokemon;
        Object v1;
        Object object;
        block6: {
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            if (!SpawnNotification.INSTANCE.getConfig().getBroadcastFaints()) {
                return;
            }
            if (!IsReallyWildKt.isReallyWild(evt.getKilled().getEffectedPokemon())) {
                return;
            }
            PokemonEntity pokemonEntity = evt.getKilled().getEntity();
            if (pokemonEntity == null) {
                return;
            }
            PokemonEntity entity = pokemonEntity;
            Level level = entity.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            object = evt.getKilled().getFacedOpponents();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                BattlePokemon e = (BattlePokemon)t;
                boolean bl = false;
                if (!(e.getEffectedPokemon().getOwnerUUID() != null)) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        BattlePokemon battlePokemon = v1;
        if (battlePokemon != null && (pokemon = battlePokemon.getEffectedPokemon()) != null && (object = pokemon.getOwnerUUID()) != null) {
            Object it = object;
            boolean bl = false;
            evt.getKilled().getEffectedPokemon().getPersistentData().putUUID("spawn_notification:faint_entity", (UUID)it);
        }
        evt.getKilled().getEffectedPokemon().getPersistentData().putBoolean("spawn_notification:should_broadcast_faint", true);
    }

    public final void handle(@NotNull Entity entity, @NotNull ServerLevel level) {
        Entity entity2;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!(entity instanceof PokemonEntity)) {
            return;
        }
        if (!((PokemonEntity)entity).getPokemon().getPersistentData().contains("spawn_notification:should_broadcast_faint")) {
            return;
        }
        UUID uUID = CompoundTagExtensionsKt.getUuidOrNull(((PokemonEntity)entity).getPokemon().getPersistentData(), "spawn_notification:faint_entity");
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            entity2 = level.getEntity(it);
        } else {
            entity2 = null;
        }
        Entity attackingEntity = entity2;
        BlockPos coords = entity.blockPosition();
        Pokemon pokemon = ((PokemonEntity)entity).getPokemon();
        Intrinsics.checkNotNull((Object)coords);
        ResourceLocation resourceLocation = ((ResourceKey)level.getBiome(coords).unwrapKey().get()).location();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        ResourceLocation resourceLocation2 = level.dimension().location();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
        this.broadcast(pokemon, coords, resourceLocation, resourceLocation2, level, attackingEntity);
    }

    private final void broadcast(Pokemon pokemon, BlockPos coords, ResourceLocation biome, ResourceLocation dimension, ServerLevel level, Entity slayer) {
        block4: {
            Component component = new FaintBroadcaster(pokemon, coords, biome, dimension, slayer).getBroadcast();
            if (component == null) break block4;
            Component message = component;
            boolean bl = false;
            if (SpawnNotification.INSTANCE.getConfig().getAnnounceCrossDimensions()) {
                Broadcast.INSTANCE.broadcastMessage(message);
            } else if (SpawnNotification.INSTANCE.getConfig().getBroadcastRangeEnabled()) {
                ResourceKey resourceKey = level.dimension();
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
                Broadcast.INSTANCE.broadcastMessage(PlayerUtil.INSTANCE.getValidPlayers((ResourceKey<Level>)resourceKey, coords), message);
            } else {
                Broadcast.INSTANCE.broadcastMessage(level, message);
            }
        }
    }

    static /* synthetic */ void broadcast$default(BroadcastFaint broadcastFaint, Pokemon pokemon, BlockPos blockPos, ResourceLocation resourceLocation, ResourceLocation resourceLocation2, ServerLevel serverLevel, Entity entity, int n, Object object) {
        if ((n & 0x20) != 0) {
            entity = null;
        }
        broadcastFaint.broadcast(pokemon, blockPos, resourceLocation, resourceLocation2, serverLevel, entity);
    }
}

