/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.spawnnotification.events;

import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import us.timinc.mc.cobblemon.spawnnotification.SpawnNotification;
import us.timinc.mc.cobblemon.spawnnotification.broadcasters.SpawnBroadcaster;
import us.timinc.mc.cobblemon.spawnnotification.util.Broadcast;
import us.timinc.mc.cobblemon.spawnnotification.util.IsReallyWildKt;
import us.timinc.mc.cobblemon.spawnnotification.util.PlayerUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lus/timinc/mc/cobblemon/spawnnotification/events/BroadcastSpawn;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/events/entity/SpawnEvent;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "evt", "", "handle", "(Lcom/cobblemon/mod/common/api/events/entity/SpawnEvent;)V", "cobblemon-spawn-notification"})
@SourceDebugExtension(value={"SMAP\nBroadcastSpawn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BroadcastSpawn.kt\nus/timinc/mc/cobblemon/spawnnotification/events/BroadcastSpawn\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1869#2,2:42\n*S KotlinDebug\n*F\n+ 1 BroadcastSpawn.kt\nus/timinc/mc/cobblemon/spawnnotification/events/BroadcastSpawn\n*L\n31#1:42,2\n*E\n"})
public final class BroadcastSpawn {
    @NotNull
    public static final BroadcastSpawn INSTANCE = new BroadcastSpawn();

    private BroadcastSpawn() {
    }

    public final void handle(@NotNull SpawnEvent<PokemonEntity> evt) {
        ServerPlayer serverPlayer;
        Intrinsics.checkNotNullParameter(evt, (String)"evt");
        ServerLevel world = evt.getCtx().getWorld();
        BlockPos pos = evt.getCtx().getPosition();
        Pokemon pokemon = ((PokemonEntity)evt.getEntity()).getPokemon();
        if (world.isClientSide) {
            return;
        }
        if (!IsReallyWildKt.isReallyWild(pokemon)) {
            return;
        }
        pokemon.getPersistentData().putBoolean("spawn_notification:spawn_broadcasted", true);
        Pokemon pokemon2 = ((PokemonEntity)evt.getEntity()).getPokemon();
        BlockPos blockPos = evt.getCtx().getPosition();
        ResourceLocation resourceLocation = evt.getCtx().getBiomeName();
        ResourceLocation resourceLocation2 = evt.getCtx().getWorld().dimension().location();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"location(...)");
        if (evt.getCtx().getSpawner() instanceof PlayerSpawner) {
            Spawner spawner = evt.getCtx().getSpawner();
            Intrinsics.checkNotNull((Object)spawner, (String)"null cannot be cast to non-null type com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner");
            serverPlayer = ((PlayerSpawner)spawner).getCauseEntity();
        } else {
            serverPlayer = null;
        }
        List<Component> messages = new SpawnBroadcaster(pokemon2, blockPos, resourceLocation, resourceLocation2, serverPlayer).getBroadcast();
        Iterable $this$forEach$iv = messages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component message = (Component)element$iv;
            boolean bl = false;
            if (SpawnNotification.INSTANCE.getConfig().getAnnounceCrossDimensions()) {
                Broadcast.INSTANCE.broadcastMessage(message);
                continue;
            }
            if (SpawnNotification.INSTANCE.getConfig().getBroadcastRangeEnabled()) {
                ResourceKey resourceKey = world.dimension();
                Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
                Broadcast.INSTANCE.broadcastMessage(PlayerUtil.INSTANCE.getValidPlayers((ResourceKey<Level>)resourceKey, pos), message);
                continue;
            }
            Broadcast.INSTANCE.broadcastMessage(world, message);
        }
    }
}

