/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.block;

import com.mojang.serialization.MapCodec;
import dev.architectury.hooks.level.entity.EntityHooks;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.block.entity.BaseBarrierBlockEntity;
import dev.ftb.mods.ftbquests.block.entity.QuestBarrierBlockEntity;
import dev.ftb.mods.ftbquests.block.neoforge.QuestBarrierBlockImpl;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.net.BlockConfigRequestMessage;
import dev.ftb.mods.ftbquests.registry.ModDataComponents;
import dev.ftb.mods.ftbquests.util.NetUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class QuestBarrierBlock
extends BaseEntityBlock {
    private static final MapCodec<QuestBarrierBlock> CODEC = QuestBarrierBlock.simpleCodec(QuestBarrierBlock::new);
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final BlockBehaviour.Properties PROPS = BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_BLUE).pushReaction(PushReaction.BLOCK).noOcclusion().isViewBlocking((blockState, blockGetter, blockPos) -> false).isSuffocating((blockState, blockGetter, blockPos) -> false).strength(-1.0f, 6000000.0f).lightLevel(blockState -> 3).emissiveRendering((blockState, blockGetter, blockPos) -> true);

    public QuestBarrierBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{OPEN});
    }

    protected MapCodec<? extends QuestBarrierBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter bg, BlockPos pos, CollisionContext ctx) {
        Entity entity = EntityHooks.fromCollision((CollisionContext)ctx);
        if (entity instanceof Player) {
            BaseBarrierBlockEntity barrier;
            Player player = (Player)entity;
            entity = bg.getBlockEntity(pos);
            if (entity instanceof BaseBarrierBlockEntity && (barrier = (BaseBarrierBlockEntity)entity).isOpen(player)) {
                return Shapes.empty();
            }
        }
        return super.getCollisionShape(state, bg, pos, ctx);
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter bg, BlockPos pos, CollisionContext ctx) {
        Entity entity = EntityHooks.fromCollision((CollisionContext)ctx);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)blockState.getValue((Property)OPEN)).booleanValue() && !NetUtils.canEdit(player)) {
                return Shapes.empty();
            }
        }
        return super.getShape(blockState, bg, pos, ctx);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        return Shapes.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadeBrightness(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter bg, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(BlockState state, BlockState state2, Direction dir) {
        return state2.is((Block)this) || super.skipRendering(state, state2, dir);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!level.isClientSide() && stack.has(DataComponents.CUSTOM_NAME) && !stack.has((DataComponentType)ModDataComponents.BARRIER_SAVED.get()) && (blockEntity = level.getBlockEntity(pos)) instanceof BaseBarrierBlockEntity) {
            BaseBarrierBlockEntity barrier = (BaseBarrierBlockEntity)blockEntity;
            barrier.updateFromString(stack.getHoverName().getString());
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player instanceof ServerPlayer) {
            BaseBarrierBlockEntity barrier;
            ServerPlayer sp = (ServerPlayer)player;
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof BaseBarrierBlockEntity && (barrier = (BaseBarrierBlockEntity)blockEntity).hasPermissionToEdit((Player)sp)) {
                NetworkManager.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new BlockConfigRequestMessage(blockPos, BlockConfigRequestMessage.BlockType.BARRIER));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.FAIL;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        ItemStack stack = super.getCloneItemStack(levelReader, blockPos, blockState);
        BlockEntity blockEntity = levelReader.getBlockEntity(blockPos);
        if (blockEntity instanceof BaseBarrierBlockEntity) {
            BaseBarrierBlockEntity barrier = (BaseBarrierBlockEntity)blockEntity;
            stack.set((DataComponentType)ModDataComponents.BARRIER_SAVED.get(), (Object)BaseBarrierBlockEntity.BarrierSavedData.fromBlockEntity(barrier));
            if (!barrier.getSkin().isEmpty() && !ClientQuestFile.canClientPlayerEdit()) {
                stack.set(DataComponents.ITEM_NAME, (Object)barrier.getSkin().getHoverName());
            }
        }
        return stack;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level != null && level.isClientSide() ? BaseBarrierBlockEntity::tick : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return QuestBarrierBlock.questBlockEntityProvider().create(blockPos, blockState);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<QuestBarrierBlockEntity> questBlockEntityProvider() {
        return QuestBarrierBlockImpl.questBlockEntityProvider();
    }
}

