/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import com.mojang.datafixers.util.Either;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BiomeTask
extends AbstractBooleanTask {
    private static final ResourceKey<Biome> DEFAULT_BIOME = Biomes.PLAINS;
    private static final List<String> KNOWN_BIOMES = new ArrayList<String>();
    private Either<ResourceKey<Biome>, TagKey<Biome>> biome = Either.left(DEFAULT_BIOME);

    public BiomeTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.BIOME;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("biome", this.getBiome());
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.setBiome(nbt.getString("biome"));
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.getBiome());
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.setBiome(buffer.readUtf(Short.MAX_VALUE));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addEnum("biome", (Object)this.getBiome(), this::setBiome, NameMap.of((Object)DEFAULT_BIOME.location().toString(), this.getKnownBiomes()).create());
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.translatable((String)"ftbquests.task.ftbquests.biome").append(": ").append((Component)Component.literal((String)this.getBiome())).withStyle(ChatFormatting.DARK_GREEN);
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public boolean checkOnLogin() {
        return false;
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        if (player.isSpectator()) {
            return false;
        }
        Holder biomeHolder = player.level().getBiome(player.blockPosition());
        return (Boolean)this.biome.map(key -> biomeHolder.unwrapKey().map(k -> k == key).orElse(false), tagKey -> {
            Registry reg = (Registry)player.level().registryAccess().registry(Registries.BIOME).orElseThrow();
            return reg.getTag(tagKey).map(holderSet -> holderSet.contains(biomeHolder)).orElse(false);
        });
    }

    private String getBiome() {
        return (String)this.biome.map(key -> key.location().toString(), tagKey -> "#" + String.valueOf(tagKey.location()));
    }

    private void setBiome(String str) {
        this.biome = str.startsWith("#") ? Either.right((Object)TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)this.safeResourceLocation(str.substring(1), DEFAULT_BIOME.location()))) : Either.left((Object)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)this.safeResourceLocation(str, DEFAULT_BIOME.location())));
    }

    private List<String> getKnownBiomes() {
        if (KNOWN_BIOMES.isEmpty()) {
            RegistryAccess registryAccess = FTBQuestsClient.getClientPlayer().level().registryAccess();
            KNOWN_BIOMES.addAll(registryAccess.registryOrThrow(Registries.BIOME).registryKeySet().stream().map(o -> o.location().toString()).sorted(String::compareTo).toList());
            KNOWN_BIOMES.addAll(registryAccess.registryOrThrow(Registries.BIOME).getTagNames().map(o -> "#" + String.valueOf(o.location())).sorted(String::compareTo).toList());
        }
        return KNOWN_BIOMES;
    }
}

