/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconAnimation;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.FTBQuests;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.gui.CustomToast;
import dev.ftb.mods.ftbquests.client.gui.quests.ValidItemsScreen;
import dev.ftb.mods.ftbquests.integration.item_filtering.ItemMatchingSystem;
import dev.ftb.mods.ftbquests.item.MissingItem;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import dev.ftb.mods.ftbquests.registry.ModItems;
import dev.ftb.mods.ftbquests.util.PlayerInventorySummary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemTask
extends Task
implements Predicate<ItemStack> {
    private ItemStack itemStack = ItemStack.EMPTY;
    private long count = 1L;
    private Tristate consumeItems = Tristate.DEFAULT;
    private Tristate onlyFromCrafting = Tristate.DEFAULT;
    private ItemMatchingSystem.ComponentMatchType matchComponents = ItemMatchingSystem.ComponentMatchType.NONE;
    private boolean taskScreenOnly = false;

    public ItemTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.ITEM;
    }

    @Override
    public long getMaxProgress() {
        return this.count;
    }

    public ItemTask setStackAndCount(ItemStack stack, int count) {
        this.itemStack = stack.copy();
        this.count = count;
        return this;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setConsumeItems(Tristate consumeItems) {
        this.consumeItems = consumeItems;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.put("item", (Tag)this.saveItemSingleLine(this.itemStack));
        if (this.count > 1L) {
            nbt.putLong("count", this.count);
        }
        this.consumeItems.write(nbt, "consume_items");
        this.onlyFromCrafting.write(nbt, "only_from_crafting");
        if (this.matchComponents != ItemMatchingSystem.ComponentMatchType.NONE) {
            nbt.putString("match_components", ItemMatchingSystem.ComponentMatchType.NAME_MAP.getName((Object)this.matchComponents));
        }
        if (this.taskScreenOnly) {
            nbt.putBoolean("task_screen_only", true);
        }
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.itemStack = ItemTask.itemOrMissingFromNBT(nbt.get("item"), provider);
        this.count = Math.max(nbt.getLong("count"), 1L);
        this.consumeItems = Tristate.read((CompoundTag)nbt, (String)"consume_items");
        this.onlyFromCrafting = Tristate.read((CompoundTag)nbt, (String)"only_from_crafting");
        this.matchComponents = (ItemMatchingSystem.ComponentMatchType)((Object)ItemMatchingSystem.ComponentMatchType.NAME_MAP.get(nbt.getString("match_components")));
        this.taskScreenOnly = nbt.getBoolean("task_screen_only");
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (this.count > 1L ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (this.consumeItems != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (this.consumeItems == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (this.onlyFromCrafting != Tristate.DEFAULT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)16, (this.onlyFromCrafting == Tristate.TRUE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)32, (this.matchComponents != ItemMatchingSystem.ComponentMatchType.NONE ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)64, (this.matchComponents == ItemMatchingSystem.ComponentMatchType.STRICT ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)256, (boolean)this.taskScreenOnly);
        buffer.writeVarInt(flags);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.itemStack);
        if (this.count > 1L) {
            buffer.writeVarLong(this.count);
        }
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        int flags = buffer.readVarInt();
        this.itemStack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
        long l = this.count = Bits.getFlag((int)flags, (int)1) ? buffer.readVarLong() : 1L;
        Tristate tristate = Bits.getFlag((int)flags, (int)2) ? (Bits.getFlag((int)flags, (int)4) ? Tristate.TRUE : Tristate.FALSE) : (this.consumeItems = Tristate.DEFAULT);
        Tristate tristate2 = Bits.getFlag((int)flags, (int)8) ? (Bits.getFlag((int)flags, (int)16) ? Tristate.TRUE : Tristate.FALSE) : (this.onlyFromCrafting = Tristate.DEFAULT);
        this.matchComponents = Bits.getFlag((int)flags, (int)32) ? (Bits.getFlag((int)flags, (int)64) ? ItemMatchingSystem.ComponentMatchType.STRICT : ItemMatchingSystem.ComponentMatchType.FUZZY) : ItemMatchingSystem.ComponentMatchType.NONE;
        this.taskScreenOnly = Bits.getFlag((int)flags, (int)256);
    }

    public List<ItemStack> getValidDisplayItems() {
        return ItemMatchingSystem.INSTANCE.getAllMatchingStacks(this.itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        if (this.count > 1L) {
            return Component.literal((String)(this.count + "x ")).append(this.itemStack.getHoverName());
        }
        return Component.literal((String)"").append(this.itemStack.getHoverName());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (ItemStack stack : this.getValidDisplayItems()) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            Icon icon = ItemIcon.getItemIcon((ItemStack)copy);
            if (icon.isEmpty()) continue;
            icons.add(icon);
        }
        if (icons.isEmpty()) {
            return ItemIcon.getItemIcon((Item)((Item)ModItems.MISSING_ITEM.get()));
        }
        return IconAnimation.fromList(icons, (boolean)false);
    }

    @Override
    public boolean test(ItemStack stack) {
        if (this.itemStack.isEmpty()) {
            return true;
        }
        return ItemMatchingSystem.INSTANCE.doesItemMatch(this.itemStack, stack, this.matchComponents);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addItemStack("item", this.itemStack, v -> {
            this.itemStack = v;
        }, ItemStack.EMPTY, true, false).setNameKey("ftbquests.task.ftbquests.item");
        config.addLong("count", this.count, v -> {
            this.count = v;
        }, 1L, 1L, Long.MAX_VALUE);
        config.addEnum("consume_items", (Object)this.consumeItems, v -> {
            this.consumeItems = v;
        }, Tristate.NAME_MAP);
        config.addEnum("only_from_crafting", (Object)this.onlyFromCrafting, v -> {
            this.onlyFromCrafting = v;
        }, Tristate.NAME_MAP);
        config.addEnum("match_components", (Object)this.matchComponents, v -> {
            this.matchComponents = v;
        }, ItemMatchingSystem.ComponentMatchType.NAME_MAP);
        config.addBool("task_screen_only", this.taskScreenOnly, v -> {
            this.taskScreenOnly = v;
        }, false);
    }

    @Override
    public boolean consumesResources() {
        return this.consumeItems.get(this.getQuest().getChapter().consumeItems());
    }

    @Override
    public boolean canInsertItem() {
        return this.consumesResources();
    }

    @Override
    public boolean submitItemsOnInventoryChange() {
        return !this.consumesResources();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        button.playClickSound();
        List<ItemStack> validItems = this.getValidDisplayItems();
        if (!this.consumesResources() && validItems.size() == 1 && FTBQuests.getRecipeModHelper().isRecipeModAvailable()) {
            FTBQuests.getRecipeModHelper().showRecipes(validItems.get(0));
        } else if (validItems.isEmpty()) {
            Minecraft.getInstance().getToasts().addToast((Toast)new CustomToast((Component)Component.literal((String)"No valid items!"), ItemIcon.getItemIcon((Item)((Item)ModItems.MISSING_ITEM.get())), (Component)Component.literal((String)"Report this bug to modpack author!")));
        } else {
            new ValidItemsScreen(this, validItems, canClick).openGui();
        }
    }

    @Override
    public void addMouseOverHeader(TooltipList list, TeamData teamData, boolean advanced) {
        if (!this.getRawTitle().isEmpty()) {
            list.add(this.getTitle());
        } else {
            ItemStack itemStack;
            Icon icon = this.getIcon();
            if (icon instanceof ItemIcon) {
                ItemIcon i = (ItemIcon)icon;
                itemStack = i.getStack();
            } else {
                itemStack = this.itemStack;
            }
            ItemStack stack = itemStack;
            List lines = stack.getTooltipLines(Item.TooltipContext.of((Level)FTBQuestsClient.getClientLevel()), FTBQuestsClient.getClientPlayer(), (TooltipFlag)(advanced ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
            if (!lines.isEmpty()) {
                lines.set(0, this.getTitle());
            } else {
                lines.add(this.getTitle());
            }
            lines.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        if (this.taskScreenOnly) {
            list.blankLine();
            list.add((Component)Component.translatable((String)"ftbquests.task.task_screen_only").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        } else if (this.consumesResources() && !teamData.isCompleted(this)) {
            list.blankLine();
            list.add((Component)Component.translatable((String)"ftbquests.task.click_to_submit").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        } else if (this.getValidDisplayItems().size() > 1) {
            list.blankLine();
            list.add((Component)Component.translatable((String)"ftbquests.task.ftbquests.item.view_items").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        } else if (FTBQuests.getRecipeModHelper().isRecipeModAvailable()) {
            list.blankLine();
            list.add((Component)Component.translatable((String)"ftbquests.task.ftbquests.item.click_recipe").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        }
    }

    public ItemStack insert(TeamData teamData, ItemStack stack, boolean simulate) {
        long add;
        if (!teamData.isCompleted(this) && this.consumesResources() && this.test(stack) && (add = Math.min((long)stack.getCount(), this.count - teamData.getProgress(this))) > 0L) {
            if (!simulate && teamData.getFile().isServerSide()) {
                teamData.addProgress(this, add);
            }
            ItemStack copy = stack.copy();
            copy.setCount((int)((long)stack.getCount() - add));
            return copy;
        }
        return stack;
    }

    private long countMatchingItems(Collection<ItemStack> toCheck) {
        long total = 0L;
        for (ItemStack stack : toCheck) {
            if (this.test(stack) && (total += (long)stack.getCount()) >= this.count) break;
        }
        return Math.min(total, this.count);
    }

    @Override
    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        if (this.taskScreenOnly || !this.checkTaskSequence(teamData) || teamData.isCompleted(this) || this.itemStack.getItem() instanceof MissingItem || craftedItem.getItem() instanceof MissingItem) {
            return;
        }
        if (!this.consumesResources()) {
            if (this.onlyFromCrafting.get(false)) {
                if (!craftedItem.isEmpty() && this.test(craftedItem)) {
                    teamData.addProgress(this, craftedItem.getCount());
                }
            } else {
                long matchCount = this.countMatchingItems(PlayerInventorySummary.getRelevantItems(this.itemStack));
                if (matchCount > teamData.getProgress(this)) {
                    teamData.setProgress(this, matchCount);
                }
            }
        } else if (craftedItem.isEmpty()) {
            boolean changed = false;
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                ItemStack stack1;
                ItemStack stack = (ItemStack)player.getInventory().items.get(i);
                if (stack == (stack1 = this.insert(teamData, stack, false))) continue;
                changed = true;
                player.getInventory().items.set(i, (Object)(stack1.isEmpty() ? ItemStack.EMPTY : stack1));
            }
            if (changed) {
                player.getInventory().setChanged();
                player.containerMenu.broadcastChanges();
            }
        }
    }

    public boolean isTaskScreenOnly() {
        return this.taskScreenOnly;
    }

    public boolean isOnlyFromCrafting() {
        return this.onlyFromCrafting.get(false);
    }
}

