/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.ftb.mods.ftbquests.block.LootCrateOpenerBlock;
import dev.ftb.mods.ftbquests.block.TaskScreenBlock;
import dev.ftb.mods.ftbquests.block.entity.DetectorBlockEntity;
import dev.ftb.mods.ftbquests.block.entity.LootCrateOpenerBlockEntity;
import dev.ftb.mods.ftbquests.block.entity.QuestBarrierBlockEntity;
import dev.ftb.mods.ftbquests.block.entity.StageBarrierBlockEntity;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenAuxBlockEntity;
import dev.ftb.mods.ftbquests.block.entity.TaskScreenBlockEntity;
import dev.ftb.mods.ftbquests.registry.ModBlocks;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ModBlockEntityTypes {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((String)"ftbquests", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    public static final RegistrySupplier<BlockEntityType<QuestBarrierBlockEntity>> BARRIER = ModBlockEntityTypes.register("barrier", QuestBarrierBlockEntity::new, ModBlocks.BARRIER);
    public static final RegistrySupplier<BlockEntityType<StageBarrierBlockEntity>> STAGE_BARRIER = ModBlockEntityTypes.register("stage_barrier", StageBarrierBlockEntity::new, ModBlocks.STAGE_BARRIER);
    public static final RegistrySupplier<BlockEntityType<DetectorBlockEntity>> DETECTOR = ModBlockEntityTypes.register("detector", DetectorBlockEntity::new, ModBlocks.DETECTOR);
    public static final RegistrySupplier<BlockEntityType<LootCrateOpenerBlockEntity>> LOOT_CRATE_OPENER = ModBlockEntityTypes.register("loot_crate_opener", LootCrateOpenerBlock.blockEntityProvider(), ModBlocks.LOOT_CRATE_OPENER);
    public static final RegistrySupplier<BlockEntityType<TaskScreenBlockEntity>> CORE_TASK_SCREEN = ModBlockEntityTypes.register("core_task_screen", TaskScreenBlock.blockEntityProvider(), Set.of(ModBlocks.TASK_SCREEN_1, ModBlocks.TASK_SCREEN_3, ModBlocks.TASK_SCREEN_5, ModBlocks.TASK_SCREEN_7));
    public static final RegistrySupplier<BlockEntityType<TaskScreenAuxBlockEntity>> AUX_TASK_SCREEN = ModBlockEntityTypes.register("aux_task_screen", TaskScreenBlock.blockEntityAuxProvider(), ModBlocks.AUX_SCREEN);

    public static <T extends BlockEntity> RegistrySupplier<BlockEntityType<T>> register(String id, BlockEntityType.BlockEntitySupplier<T> factory, Collection<RegistrySupplier<Block>> blocks) {
        return BLOCK_ENTITIES.register(id, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)factory, (Block[])((Block[])blocks.stream().map(Supplier::get).toArray(Block[]::new))).build(null));
    }

    public static <T extends BlockEntity> RegistrySupplier<BlockEntityType<T>> register(String id, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<Block> block) {
        return BLOCK_ENTITIES.register(id, () -> BlockEntityType.Builder.of((BlockEntityType.BlockEntitySupplier)factory, (Block[])new Block[]{(Block)block.get()}).build(null));
    }

    public static void register() {
        BLOCK_ENTITIES.register();
    }
}

