/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import journeymap.client.JourneymapClient;
import journeymap.client.model.block.BlockMD;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.client.model.map.MapType;
import journeymap.client.model.region.RegionCoord;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.nbt.RegionDataStorageHandler;
import journeymap.common.nbt.cache.CacheStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;

public class RegionData {
    public static final String BIOME_TAG_NAME = "biome_name";
    public static final String BLOCK_TAG_NAME = "block";
    public static final String BLOCKSTATES_TAG_NAME = "blockstates";
    public static final String BLOCK_LIGHT_VALUE = "light_value";
    public static final String TOP_Y_TAG_NAME = "top_y";
    public static final String SURFACE_Y_TAG_NAME = "surface_y";
    public static final String BLOCK_COLOR_TAG_NAME = "block_color_";
    public static final String CHUNK_POS_NAME = "pos";
    protected final RegionCoord regionCoord;
    protected final MapType mapType;
    protected static boolean enabled;
    protected boolean loaded = false;
    protected final RegionDataStorageHandler.Key key;
    private final CacheStorage storage;

    public RegionData(RegionDataStorageHandler.Key key, CacheStorage storage) {
        this.regionCoord = key.rCoord;
        this.mapType = key.mapType;
        this.key = key;
        this.storage = storage;
        enabled = JourneymapClient.getInstance().getCoreProperties().dataCachingEnabled.get();
    }

    public Biome getBiome(BlockPos blockPos) {
        CompoundTag blockData;
        if (enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).contains(BIOME_TAG_NAME)) {
            String biomeName = blockData.getString(BIOME_TAG_NAME);
            return BiomeHelper.getBiomeFromResourceString(biomeName);
        }
        return null;
    }

    public Integer getTopY(BlockPos blockPos) {
        CompoundTag blockData;
        if (enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).contains(TOP_Y_TAG_NAME)) {
            return blockData.getInt(TOP_Y_TAG_NAME);
        }
        return blockPos.getY();
    }

    public Integer getColor(BlockPos blockPos) {
        CompoundTag blockData;
        if (enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).contains(BLOCK_COLOR_TAG_NAME)) {
            return blockData.getInt(BLOCK_COLOR_TAG_NAME);
        }
        return null;
    }

    public BlockState getBlockState(BlockPos blockPos) {
        if (enabled) {
            CompoundTag blockData = this.getBlockDataFromBlockPos(blockPos);
            return RegionData.getBlockState(blockData, blockPos, this.mapType);
        }
        return null;
    }

    public static BlockState getBlockState(CompoundTag blockData, BlockPos blockPos, MapType mapType) {
        if (enabled) {
            ClientLevel level = Minecraft.getInstance().level;
            if (blockData.contains(BLOCKSTATES_TAG_NAME) && !mapType.isUnderground()) {
                String key;
                CompoundTag states = RegionData.getBlockStates(blockData, mapType);
                if (states.contains(key = String.valueOf(blockPos.getY()))) {
                    CompoundTag blockState = states.getCompound(key);
                    return NbtUtils.readBlockState((HolderGetter)level.holderLookup(Registries.BLOCK), (CompoundTag)blockState);
                }
                if (states.getAllKeys().size() > 0 && states.getAllKeys().stream().findFirst().isPresent()) {
                    CompoundTag blockState = states.getCompound((String)states.getAllKeys().stream().findFirst().get());
                    return NbtUtils.readBlockState((HolderGetter)level.holderLookup(Registries.BLOCK), (CompoundTag)blockState);
                }
            } else if (blockData.contains(BLOCK_TAG_NAME)) {
                CompoundTag blockState = blockData.getCompound(BLOCK_TAG_NAME);
                BlockState state = NbtUtils.readBlockState((HolderGetter)level.holderLookup(Registries.BLOCK), (CompoundTag)blockState);
                if (!mapType.isUnderground()) {
                    RegionData.setBlockState(blockData, state, blockPos, mapType);
                }
                return state;
            }
        }
        return null;
    }

    public void setBiome(CompoundTag blockData, ResourceKey<Biome> biome) {
        ResourceLocation biomeResource;
        if (enabled && (biomeResource = biome.location()) != null) {
            String biomeName;
            if (blockData.contains(BIOME_TAG_NAME) && (biomeName = blockData.getString(BIOME_TAG_NAME)).equals(biomeResource.toString())) {
                return;
            }
            blockData.putString(BIOME_TAG_NAME, biomeResource.toString());
        }
    }

    public void setBlockState(CompoundTag blockData, ChunkMD chunkMD, BlockPos pos) {
        BlockMD blockMD = chunkMD.getBlockMD(pos);
        if (!(!blockMD.hasNoShadow() || blockMD.isIgnore() || blockMD.isWater() || blockMD.isFluid() || blockMD.getBlockState().getProperties().contains(DoublePlantBlock.HALF) || this.mapType.isUnderground())) {
            RegionData.setBlockState(blockData, chunkMD.getBlockMD(pos.below()).getBlockState(), pos.below(), this.mapType);
        }
        RegionData.setBlockState(blockData, blockMD.getBlockState(), pos, this.mapType);
    }

    private static void setBlockState(CompoundTag blockData, BlockState state, BlockPos pos, MapType mapType) {
        if (enabled && blockData != null) {
            if (mapType.isUnderground()) {
                CompoundTag blockState = NbtUtils.writeBlockState((BlockState)state);
                blockData.put(BLOCK_TAG_NAME, (Tag)blockState);
            } else {
                CompoundTag states = RegionData.getBlockStates(blockData, mapType);
                CompoundTag blockState = NbtUtils.writeBlockState((BlockState)state);
                states.put(String.valueOf(pos.getY()), (Tag)blockState);
                blockData.put(BLOCKSTATES_TAG_NAME, (Tag)states);
            }
        }
    }

    public void setY(CompoundTag blockData, int topY) {
        if (enabled) {
            int savedTopY;
            if (blockData.contains(TOP_Y_TAG_NAME) && (savedTopY = blockData.getInt(TOP_Y_TAG_NAME)) == topY) {
                return;
            }
            blockData.putInt(TOP_Y_TAG_NAME, topY);
        }
    }

    public void setLightValue(CompoundTag blockData, int light) {
        if (enabled) {
            int savedLight;
            if (blockData.contains(BLOCK_LIGHT_VALUE) && (savedLight = blockData.getInt(BLOCK_LIGHT_VALUE)) == light) {
                return;
            }
            blockData.putInt(BLOCK_LIGHT_VALUE, light);
        }
    }

    public void setSurfaceY(CompoundTag blockData, int surfaceY) {
        if (enabled) {
            int savedTopY;
            if (blockData.contains(SURFACE_Y_TAG_NAME) && (savedTopY = blockData.getInt(SURFACE_Y_TAG_NAME)) == surfaceY) {
                return;
            }
            blockData.putInt(SURFACE_Y_TAG_NAME, surfaceY);
        }
    }

    public void setBlockColor(CompoundTag blockData, int color, MapType.Name mapTypeName) {
    }

    private static CompoundTag getBlockStates(CompoundTag blockData, MapType mapType) {
        if (enabled) {
            if (mapType.isUnderground()) {
                if (blockData.contains(BLOCK_TAG_NAME)) {
                    return blockData.getCompound(BLOCK_TAG_NAME);
                }
            } else if (blockData.contains(BLOCKSTATES_TAG_NAME)) {
                return blockData.getCompound(BLOCKSTATES_TAG_NAME);
            }
            return new CompoundTag();
        }
        return null;
    }

    public CompoundTag getBlockDataFromBlockPos(ChunkPos chunkPos, CompoundTag chunk, int x, int z) {
        if (enabled && chunk != null) {
            return RegionData.getBlockDataForChunk(chunk, (chunkPos.x << 4) + x, (chunkPos.z << 4) + z);
        }
        return null;
    }

    public CompoundTag getBlockDataFromBlockPos(ChunkPos chunkPos, int x, int z) {
        CompoundTag chunk = this.getChunkNbt(chunkPos);
        if (enabled && chunk != null) {
            return RegionData.getBlockDataForChunk(chunk, (chunkPos.x << 4) + x, (chunkPos.z << 4) + z);
        }
        return null;
    }

    private CompoundTag getBlockDataFromBlockPos(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        CompoundTag chunk = this.getChunkNbt(chunkPos);
        return RegionData.getBlockDataForChunk(chunk, pos.getX(), pos.getZ());
    }

    public CompoundTag getChunkNbt(ChunkPos chunkPos) {
        if (enabled) {
            CompoundTag chunkTag = this.storage.read(chunkPos);
            if (chunkTag == null) {
                chunkTag = new CompoundTag();
            }
            if (!chunkTag.contains(CHUNK_POS_NAME)) {
                chunkTag.putLong(CHUNK_POS_NAME, chunkPos.toLong());
            }
            return chunkTag;
        }
        return null;
    }

    public static CompoundTag getBlockDataForChunk(CompoundTag chunk, int x, int z) {
        if (chunk != null) {
            CompoundTag blockTag;
            String blockTagName = x + "," + z;
            if (chunk.contains(blockTagName)) {
                blockTag = chunk.getCompound(blockTagName);
            } else {
                blockTag = new CompoundTag();
                chunk.put(blockTagName, (Tag)blockTag);
            }
            return blockTag;
        }
        return null;
    }

    public boolean isFullRegion() {
        for (ChunkPos pos : this.regionCoord.getChunkCoordsInRegion()) {
            if (this.hasChunk(pos)) continue;
            return false;
        }
        return true;
    }

    public boolean hasChunk(ChunkPos pos) {
        return this.storage.hasChunk(pos);
    }

    public void writeChunk(ChunkPos chunkPos, CompoundTag tag) {
        this.storage.write(chunkPos, tag);
    }
}

