/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.mixin.client;

import glitchcore.event.EventManager;
import glitchcore.event.TickEvent;
import glitchcore.event.player.PlayerInteractEvent;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MixinMinecraft {
    @Shadow
    public HitResult hitResult;
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Unique
    private ItemStack startUseItem_stack;
    @Unique
    private InteractionHand startUseItem_hand;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void onBeginTick(CallbackInfo ci) {
        EventManager.fire(new TickEvent.Client(TickEvent.Phase.START));
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void onEndTick(CallbackInfo ci) {
        EventManager.fire(new TickEvent.Client(TickEvent.Phase.END));
    }

    @Redirect(method={"startUseItem"}, at=@At(value="INVOKE", target="net/minecraft/client/player/LocalPlayer.getItemInHand (Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;", ordinal=0), require=1)
    public ItemStack startUseItem_getItemInHand(LocalPlayer instance, InteractionHand hand) {
        this.startUseItem_hand = hand;
        this.startUseItem_stack = instance.getItemInHand(hand);
        return this.startUseItem_stack;
    }

    @Inject(method={"startUseItem"}, slice={@Slice(from=@At(value="INVOKE", target="net/minecraft/client/renderer/ItemInHandRenderer.itemUsed (Lnet/minecraft/world/InteractionHand;)V", ordinal=0))}, at={@At(value="INVOKE", target="net/minecraft/world/item/ItemStack.isEmpty()Z", ordinal=0)})
    public void onStartUseItem(CallbackInfo ci) {
        if (this.startUseItem_stack.isEmpty() && (this.hitResult == null || this.hitResult.getType() == HitResult.Type.MISS)) {
            EventManager.fire(new PlayerInteractEvent.UseEmpty((Player)this.player, this.startUseItem_hand));
        }
    }
}

