/*
 * Decompiled with CFR 0.152.
 */
package trofers.neoforge.datagen.providers;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import trofers.Trofers;
import trofers.block.TrophyBlock;
import trofers.neoforge.datagen.providers.TrophyProviders;
import trofers.neoforge.datagen.providers.trophies.TrophyProvider;
import trofers.registry.ModBlocks;
import trofers.registry.ModDataComponents;

public class LootTables
extends LootTableProvider {
    private final List<LootTableProvider.SubProviderEntry> lootTables = new ArrayList<LootTableProvider.SubProviderEntry>();
    private final TrophyProviders trophyProviders;

    public LootTables(PackOutput packOutput, TrophyProviders trophyProviders, CompletableFuture<HolderLookup.Provider> provider) {
        super(packOutput, Set.of(), List.of(), provider);
        this.trophyProviders = trophyProviders;
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        this.lootTables.clear();
        this.addBlockLootTables();
        for (TrophyProvider provider : this.trophyProviders.getTrophyProviders()) {
            this.lootTables.addAll(provider.getLootTables());
        }
        return this.lootTables;
    }

    private void addBlockLootTables() {
        CopyComponentsFunction.Builder copyNbtBuilder = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)ModDataComponents.TROPHY.get());
        for (RegistrySupplier<TrophyBlock> trophy : ModBlocks.TROPHIES) {
            ResourceKey location = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Trofers.id("blocks/" + trophy.getId().getPath()));
            LootTable.Builder lootTable = LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)trophy.get())).apply((LootItemFunction.Builder)copyNbtBuilder)));
            this.lootTables.add(new LootTableProvider.SubProviderEntry(provider -> builder -> builder.accept(location, lootTable), LootContextParamSets.BLOCK));
        }
    }
}

