/*
 * Decompiled with CFR 0.152.
 */
package trofers.screen;

import com.mojang.blaze3d.platform.Lighting;
import dev.architectury.networking.NetworkManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import trofers.block.entity.TrophyBlockEntity;
import trofers.network.SetTrophyPacket;
import trofers.trophy.Trophy;
import trofers.trophy.TrophySearchTreeManager;

public class TrophySelectionScreen
extends Screen {
    private static final int HORIZONTAL_PADDING = 80;
    private static final int VERTICAL_PADDING = 16;
    private static final int TROPHY_BUTTON_SIZE = 40;
    private static final int BUTTON_SPACING = 8;
    private static final int CANCEL_BUTTON_WIDTH = 96;
    private static final int NAVIGATION_BUTTON_SIZE = 20;
    private static final int SEARCH_BAR_HEIGHT = 12;
    private static final int SEARCH_BAR_VERTICAL_SPACING = 8;
    private static final int MIN_ROW_COUNT = 2;
    private static final int MIN_COLUMN_COUNT = 2;
    private static final int MAX_COLUMN_COUNT = 16;
    private static final float ITEM_SCALE = 2.0f;
    private List<ResourceLocation> trophies;
    private EditBox searchBox;
    private Button previousButton;
    private Button nextButton;
    private final Set<Button> trophyButtons = new HashSet<Button>();
    private int currentPage;
    private int rowCount;
    private int columnCount;
    private int rowStart;
    private int columnStart;
    private final BlockState blockState;
    private final BlockPos blockPos;

    public TrophySelectionScreen(BlockState blockState, BlockPos blockPos) {
        super((Component)Component.empty());
        this.blockState = blockState;
        this.blockPos = blockPos;
        this.currentPage = -1;
        this.trophies = TrophySearchTreeManager.search("");
    }

    public static void open(BlockState blockState, BlockPos pos) {
        Minecraft.getInstance().setScreen((Screen)new TrophySelectionScreen(blockState, pos));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean isInventoryKeyDown;
        boolean bl = isInventoryKeyDown = this.minecraft != null && this.minecraft.options.keyInventory.matches(keyCode, scanCode);
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (!this.searchBox.isFocused() && isInventoryKeyDown) {
            this.onClose();
            return true;
        }
        return false;
    }

    protected void init() {
        this.columnCount = (this.width - 160 - 40) / 48 + 1;
        this.columnCount = Math.max(this.columnCount, 2);
        this.columnCount = Math.min(this.columnCount, 16);
        this.columnStart = this.width / 2 - (40 * this.columnCount + 8 * (this.columnCount - 1)) / 2;
        this.rowStart = 64;
        this.rowCount = (this.height - this.rowStart - 16 - 40) / 48 + 1;
        this.rowCount = Math.max(this.rowCount, 2);
        this.createUpperButtons();
        this.setInitialFocus((GuiEventListener)this.searchBox);
        if (this.currentPage == -1) {
            this.setCurrentPage(0);
        }
    }

    public void resize(Minecraft minecraft, int width, int height) {
        int previousRowCount = this.rowCount;
        int previousColumnCount = this.columnCount;
        String search = this.searchBox.getValue();
        List<ResourceLocation> trophies = this.trophies;
        super.resize(minecraft, width, height);
        this.searchBox.setValue(search);
        this.trophies = trophies;
        if (this.columnCount == previousColumnCount && this.rowCount == previousRowCount) {
            this.setCurrentPage(this.currentPage);
        } else {
            this.setCurrentPage(0);
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        boolean result = super.mouseClicked(pMouseX, pMouseY, pButton);
        if (this.getFocused() != this.searchBox) {
            this.searchBox.setFocused(false);
        }
        return result;
    }

    private void createUpperButtons() {
        int xPos = this.width / 2 - 48 - 8 - 20;
        this.previousButton = Button.builder((Component)Component.literal((String)"<"), button -> this.setCurrentPage(this.currentPage - 1)).pos(xPos, 16).width(20).build();
        this.addRenderableWidget((GuiEventListener)this.previousButton);
        Button cancelButton = Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).pos(xPos += 28, 16).width(96).build();
        this.addRenderableWidget((GuiEventListener)cancelButton);
        this.nextButton = Button.builder((Component)Component.literal((String)">"), button -> this.setCurrentPage(this.currentPage + 1)).pos(xPos += 104, 16).width(20).build();
        this.addRenderableWidget((GuiEventListener)this.nextButton);
        int searchBoxX = this.width / 2 - 48 - 8 - 20;
        int searchBoxY = 44;
        int searchBoxWidth = 152;
        MutableComponent searchBoxNarration = Component.translatable((String)"itemGroup.search");
        this.searchBox = new EditBox(this.font, searchBoxX, searchBoxY, searchBoxWidth, 12, (Component)searchBoxNarration);
        this.searchBox.setBordered(true);
        this.searchBox.setResponder(this::onEditSearchBox);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
    }

    public void onEditSearchBox(String text) {
        List<ResourceLocation> searchResult = TrophySearchTreeManager.search(text);
        if (!searchResult.equals(this.trophies)) {
            this.trophies = searchResult;
            this.setCurrentPage(0);
        }
    }

    private void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        this.trophyButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.trophyButtons.clear();
        int index = currentPage * this.columnCount * this.rowCount;
        for (int row = 0; row < this.rowCount; ++row) {
            for (int column = 0; column < this.columnCount && index < this.trophies.size(); ++column) {
                ResourceLocation trophyId = this.trophies.get(index++);
                ItemStack stack = Trophy.createItem((ItemLike)this.blockState.getBlock(), trophyId);
                int x = this.columnStart + column * 48;
                int y = this.rowStart + row * 48;
                TrophyButton trophyButton = new TrophyButton(x, y, 40, stack, trophyId);
                this.trophyButtons.add((Button)this.addRenderableWidget((GuiEventListener)trophyButton));
            }
        }
        this.nextButton.active = false;
        this.previousButton.active = false;
        if (index < this.trophies.size() - 1) {
            this.nextButton.active = true;
        }
        if (currentPage > 0) {
            this.previousButton.active = true;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private class TrophyButton
    extends Button {
        private final ItemStack item;
        private final ResourceLocation trophyId;
        private final int x;
        private final int y;

        private TrophyButton(int xPos, int yPos, int size, ItemStack item, ResourceLocation trophyId) {
            super(xPos, yPos, size, size, (Component)Component.empty(), button -> {}, supplier -> item.getHoverName().copy());
            this.setTooltip(Tooltip.create((Component)item.getHoverName()));
            this.trophyId = trophyId;
            this.item = item;
            this.x = xPos;
            this.y = yPos;
        }

        public void onClick(double x, double y) {
            BlockEntity blockEntity;
            NetworkManager.sendToServer((CustomPacketPayload)new SetTrophyPacket(this.trophyId, TrophySelectionScreen.this.blockPos));
            if (Minecraft.getInstance().player != null && (blockEntity = Minecraft.getInstance().player.level().getBlockEntity(TrophySelectionScreen.this.blockPos)) instanceof TrophyBlockEntity) {
                TrophyBlockEntity blockEntity2 = (TrophyBlockEntity)blockEntity;
                blockEntity2.setTrophy(this.trophyId, null);
            }
            TrophySelectionScreen.this.onClose();
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            this.tryRenderScaledGuiItem(guiGraphics, this.item, this.x + (int)((float)this.width - 32.0f) / 2, this.y + (int)((float)this.height - 32.0f) / 2, 2.0f);
        }

        private void tryRenderScaledGuiItem(GuiGraphics graphics, ItemStack stack, int x, int y, float scale) {
            if (!stack.isEmpty()) {
                BakedModel bakedModel = Minecraft.getInstance().getItemRenderer().getModel(stack, (Level)Minecraft.getInstance().level, null, 0);
                graphics.pose().pushPose();
                graphics.pose().translate((float)x + 8.0f * scale, (float)y + 8.0f * scale, 150.0f);
                try {
                    boolean bl;
                    graphics.pose().scale(16.0f * scale, -16.0f * scale, 16.0f * scale);
                    boolean bl2 = bl = !bakedModel.usesBlockLight();
                    if (bl) {
                        Lighting.setupForFlatItems();
                    }
                    Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.GUI, false, graphics.pose(), (MultiBufferSource)graphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
                    graphics.flush();
                    if (bl) {
                        Lighting.setupFor3DItems();
                    }
                }
                catch (Throwable var12) {
                    CrashReport crashReport = CrashReport.forThrowable((Throwable)var12, (String)"Rendering item");
                    CrashReportCategory crashReportCategory = crashReport.addCategory("Item being rendered");
                    crashReportCategory.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
                    crashReportCategory.setDetail("Item Components", () -> String.valueOf(stack.getComponents()));
                    crashReportCategory.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
                    throw new ReportedException(crashReport);
                }
                graphics.pose().popPose();
            }
        }
    }
}

