/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.searchtree.FullTextSearchTree;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import trofers.block.TrophyBlock;
import trofers.registry.ModRegistries;
import trofers.trophy.Trophy;

public class TrophySearchTreeManager
implements ResourceManagerReloadListener {
    private static SearchTree<ResourceLocation> searchTree;

    public void onResourceManagerReload(ResourceManager manager) {
        TrophySearchTreeManager.createSearchTree();
    }

    public static List<ResourceLocation> search(String text) {
        return searchTree.search(text);
    }

    public static void createSearchTree() {
        if (ModRegistries.trophies().isEmpty()) {
            return;
        }
        searchTree = new FullTextSearchTree(TrophySearchTreeManager::getNames, Stream::of, TrophySearchTreeManager.getTrophies());
    }

    private static Trophy getTrophy(ResourceLocation trophyId) {
        return Objects.requireNonNull((Trophy)ModRegistries.trophies().orElseThrow().get(trophyId));
    }

    private static Stream<String> getNames(ResourceLocation trophyId) {
        return Stream.of(ChatFormatting.stripFormatting((String)TrophySearchTreeManager.getTrophy(trophyId).name().orElse((Component)Component.translatable((String)TrophyBlock.DESCRIPTION_ID)).getString()).trim());
    }

    private static List<ResourceLocation> getTrophies() {
        Registry<Trophy> trophies = ModRegistries.trophies().orElseThrow();
        return trophies.keySet().stream().filter(trophyId -> !Objects.requireNonNull((Trophy)trophies.get(trophyId)).isHidden()).sorted(Comparator.comparing(ResourceLocation::toString)).collect(Collectors.toList());
    }
}

