/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.builder;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import trofers.trophy.builder.TrophyBuilder;
import trofers.trophy.components.EntityInfo;

public class EntityTrophyBuilder<T extends EntityTrophyBuilder<T>>
extends TrophyBuilder<T> {
    private final EntityInfo entityInfo;

    protected EntityTrophyBuilder(ResourceLocation entityId) {
        this.entityInfo = new EntityInfo(entityId, new CompoundTag());
    }

    public ResourceLocation getEntityId() {
        return this.entityInfo.id();
    }

    @Override
    protected ItemStack getDisplayItem() {
        return ItemStack.EMPTY;
    }

    @Override
    protected Optional<EntityInfo> getEntityInfo() {
        return Optional.of(this.entityInfo);
    }

    public T tag(Consumer<CompoundTag> tagConsumer) {
        tagConsumer.accept(this.entityInfo.tag());
        return (T)this;
    }

    public T tag(String name, Consumer<CompoundTag> tagConsumer) {
        if (!this.entityInfo.tag().contains(name)) {
            this.entityInfo.tag().put(name, (Tag)new CompoundTag());
        }
        tagConsumer.accept(this.entityInfo.tag().getCompound(name));
        return (T)this;
    }

    public T putTag(String name, Tag tag) {
        this.entityInfo.tag().put(name, tag);
        return (T)this;
    }

    public T putByte(String name, byte b) {
        this.entityInfo.tag().putByte(name, b);
        return (T)this;
    }

    public T putInt(String name, int i) {
        this.entityInfo.tag().putInt(name, i);
        return (T)this;
    }

    public T putFloat(String name, float f) {
        this.entityInfo.tag().putFloat(name, f);
        return (T)this;
    }

    public T putBoolean(String name, boolean b) {
        this.entityInfo.tag().putBoolean(name, b);
        return (T)this;
    }

    public T putString(String name, String s) {
        this.entityInfo.tag().putString(name, s);
        return (T)this;
    }

    public T putUUID(String name, UUID uuid) {
        this.entityInfo.tag().putUUID(name, uuid);
        return (T)this;
    }

    public T putCustomName(String customName) {
        return this.putString("CustomName", "\"%s\"".formatted(customName));
    }

    public T putItem(String tag, ItemStack stack) {
        return this.putTag(tag, EntityTrophyBuilder.itemStackToNbt(stack));
    }

    public T putItem(String tag, Item item) {
        return this.putItem(tag, new ItemStack((ItemLike)item));
    }

    public T putEquipment(EquipmentSlot slot, Tag item) {
        ListTag slots;
        String tagName;
        String string = tagName = slot.getType() == EquipmentSlot.Type.HAND ? "HandItems" : "ArmorItems";
        if (!this.entityInfo.tag().contains(tagName, 9)) {
            slots = new ListTag();
            int size = slot.getType() == EquipmentSlot.Type.HAND ? 2 : 4;
            for (int i = 0; i < size; ++i) {
                slots.add((Object)new CompoundTag());
            }
            this.entityInfo.tag().put(tagName, (Tag)slots);
        }
        slots = this.entityInfo.tag().getList(tagName, 10);
        slots.set(slot.getIndex(), item);
        return (T)this;
    }

    public T putEquipment(EquipmentSlot slot, ItemStack itemStack) {
        return this.putEquipment(slot, EntityTrophyBuilder.itemStackToNbt(itemStack));
    }

    public T putEquipment(EquipmentSlot slot, Item item) {
        return this.putEquipment(slot, new ItemStack((ItemLike)item));
    }

    public T putHandItem(Item item) {
        return this.putEquipment(EquipmentSlot.MAINHAND, item);
    }

    private static Tag itemStackToNbt(ItemStack stack) {
        return (Tag)ItemStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)stack).getOrThrow();
    }
}

