/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import trofers.data.ModCodecs;

public class EntityInfo {
    private final ResourceLocation id;
    private final CompoundTag tag;
    private static final Codec<ResourceLocation> ENTITY_ID_CODEC = ResourceLocation.CODEC.comapFlatMap(id -> BuiltInRegistries.ENTITY_TYPE.containsKey(id) ? DataResult.success((Object)id) : DataResult.error(() -> String.format("Unknown entity type %s", id)), Function.identity());
    public static final Codec<EntityInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModCodecs.requiredField("id", ENTITY_ID_CODEC).forGetter(entityInfo -> entityInfo.id), (App)ModCodecs.defaultField("tag", new CompoundTag(), CompoundTag.CODEC).forGetter(entityInfo -> entityInfo.tag)).apply((Applicative)instance, EntityInfo::new));
    @Nullable
    private Entity entity;

    public EntityInfo(ResourceLocation id, CompoundTag tag) {
        this.id = id;
        this.tag = tag;
    }

    public ResourceLocation id() {
        return this.id;
    }

    public CompoundTag tag() {
        return this.tag;
    }

    @Nullable
    public Entity getOrCreateEntity(Level level) {
        if (this.entity == null || this.entity.level() != level) {
            this.createEntity(level);
        }
        return this.entity;
    }

    private void createEntity(Level level) {
        if (!BuiltInRegistries.ENTITY_TYPE.containsKey(this.id)) {
            return;
        }
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.id);
        if (!type.requiredFeatures().isSubsetOf(level.enabledFeatures())) {
            return;
        }
        CompoundTag entityTag = this.tag.copy();
        entityTag.putString("id", this.id.toString());
        if (!entityTag.hasUUID("UUID")) {
            entityTag.putUUID("UUID", new UUID(1L, 1L));
        }
        this.entity = EntityType.loadEntityRecursive((CompoundTag)entityTag, (Level)level, Function.identity());
    }
}

