/*
 * Decompiled with CFR 0.152.
 */
package trofers.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;

public abstract class ConditionsHelper {
    private static final String FABRIC = "fabric";
    private static final String FABRIC_LOAD_CONDITIONS = ResourceLocation.fromNamespaceAndPath((String)"fabric", (String)"load_conditions").toString();
    private static final String FABRIC_ALL_MODS_LOADED = ResourceLocation.fromNamespaceAndPath((String)"fabric", (String)"all_mods_loaded").toString();
    private static final String NEOFORGE = "neoforge";
    private static final String NEOFORGE_CONDITIONS = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"conditions").toString();
    private static final String NEOFORGE_MOD_LOADED = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"mod_loaded").toString();

    private static JsonArray getOrCreateList(JsonObject object, String name) {
        if (object.has(name)) {
            return object.getAsJsonArray(name);
        }
        JsonArray conditions = new JsonArray();
        object.add(name, (JsonElement)conditions);
        return conditions;
    }

    private static JsonObject createCondition(JsonObject object, String conditionsName, String conditionName, String conditionValue) {
        JsonArray conditions = ConditionsHelper.getOrCreateList(object, conditionsName);
        JsonObject condition = new JsonObject();
        conditions.add((JsonElement)condition);
        condition.addProperty(conditionName, conditionValue);
        return condition;
    }

    private static JsonObject createFabricCondition(JsonObject object, String type) {
        return ConditionsHelper.createCondition(object, FABRIC_LOAD_CONDITIONS, "condition", type);
    }

    private static JsonObject createForgeCondition(JsonObject object, String type) {
        return ConditionsHelper.createCondition(object, NEOFORGE_CONDITIONS, "type", type);
    }

    public static void addModLoadedConditions(JsonObject object, String ... modIds) {
        if (modIds.length == 0) {
            return;
        }
        ConditionsHelper.addFabricModLoadedCondition(object, modIds);
        ConditionsHelper.addForgeModLoadedCondition(object, modIds);
    }

    private static void addFabricModLoadedCondition(JsonObject object, String ... modIds) {
        JsonObject condition = ConditionsHelper.createFabricCondition(object, FABRIC_ALL_MODS_LOADED);
        JsonArray mods = ConditionsHelper.getOrCreateList(condition, "values");
        for (String modId : modIds) {
            mods.add(modId);
        }
    }

    private static void addForgeModLoadedCondition(JsonObject object, String ... modIds) {
        for (String modId : modIds) {
            ConditionsHelper.createForgeCondition(object, NEOFORGE_MOD_LOADED).addProperty("modid", modId);
        }
    }
}

