/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.energy.GeneratorFuel;
import blusunrize.immersiveengineering.api.energy.ThermoelectricSource;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.client.manual.IEManualInstance;
import blusunrize.immersiveengineering.client.manual.ManualElementBlueprint;
import blusunrize.immersiveengineering.client.manual.ManualElementBottling;
import blusunrize.immersiveengineering.client.manual.ManualElementMixer;
import blusunrize.immersiveengineering.client.manual.ManualElementMultiblock;
import blusunrize.immersiveengineering.client.manual.ShaderManualElement;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.lib.manual.ManualElementItem;
import blusunrize.lib.manual.ManualElementTable;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.utils.ManualRecipeRef;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.VersionChecker;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class IEManual {
    public static void initManual() {
        IEManualInstance ieMan = new IEManualInstance();
        ManualHelper.IE_MANUAL_INSTANCE.setValue(ieMan);
        ManualHelper.ADD_CONFIG_GETTER.setValue(e -> {
            List<Function<String, Object>> list = ieMan.configGetters;
            synchronized (list) {
                ieMan.configGetters.add((Function<String, Object>)e);
            }
        });
        ManualHelper.DYNAMIC_TABLES.put("squeezer", () -> IEManual.formatToTable_ItemIntMap(SqueezerRecipe.getFluidValuesSorted((Level)Minecraft.getInstance().level, (Fluid)IEFluids.PLANTOIL.getStill(), true), "mB"));
        ManualHelper.DYNAMIC_TABLES.put("fermenter", () -> IEManual.formatToTable_ItemIntMap(FermenterRecipe.getFluidValuesSorted((Level)Minecraft.getInstance().level, (Fluid)IEFluids.ETHANOL.getStill(), true), "mB"));
        ManualHelper.DYNAMIC_TABLES.put("thermoelectric", () -> IEManual.formatToTable_ItemIntMap(ThermoelectricSource.getThermalValuesSorted((Level)Minecraft.getInstance().level, true), "K"));
        ManualHelper.DYNAMIC_TABLES.put("generatorfuel", () -> IEManual.formatToTable_ItemIntMap(GeneratorFuel.getManualFuelList((Level)Minecraft.getInstance().level), "ticks"));
        ieMan.registerSpecialElement(IEApi.ieLoc("blueprint"), s -> new ManualElementBlueprint(ieMan, IEManual.collectRecipeStacksFromJSON(s)));
        ieMan.registerSpecialElement(IEApi.ieLoc("bottling"), s -> new ManualElementBottling(ieMan, IEManual.collectRecipeStacksFromJSON(s)));
        ieMan.registerSpecialElement(IEApi.ieLoc("mixer"), s -> new ManualElementMixer((ManualInstance)ieMan, IEManual.collectRecipeFluidsFromJSON(s)));
        ieMan.registerSpecialElement(IEApi.ieLoc("multiblock"), s -> {
            ResourceLocation name = ManualUtils.getLocationForManual(GsonHelper.getAsString((JsonObject)s, (String)"name"), ieMan);
            MultiblockHandler.IMultiblock mb = MultiblockHandler.getByUniqueName(name);
            if (mb == null) {
                throw new NullPointerException("Multiblock " + String.valueOf(name) + " does not exist");
            }
            return new ManualElementMultiblock(ieMan, mb);
        });
        ieMan.registerSpecialElement(IEApi.ieLoc("dynamic_table"), s -> new ManualElementTable(ManualHelper.getManual(), ManualHelper.DYNAMIC_TABLES.get(GsonHelper.getAsString((JsonObject)s, (String)"table")).get(), false));
    }

    public static void addIEManualEntries() {
        IEManualInstance ieMan = (IEManualInstance)ManualHelper.getManual();
        Tree.InnerNode<ResourceLocation, ManualEntry> resourcesCat = ieMan.getRoot().getOrCreateSubnode(IEApi.ieLoc(ManualHelper.CAT_RESOURCES), 0);
        Tree.InnerNode<ResourceLocation, ManualEntry> toolsCat = ieMan.getRoot().getOrCreateSubnode(IEApi.ieLoc(ManualHelper.CAT_TOOLS), 50);
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.readFromFile(IEApi.ieLoc("mineral_deposits"));
        builder.appendText(IEManual::getMineralVeinTexts);
        ieMan.addEntry(resourcesCat, builder.create(), ieMan.atOffsetFrom(resourcesCat, "ores", 0.5));
        builder = new ManualEntry.ManualEntryBuilder(ieMan);
        builder.setContent(() -> "Shader list", () -> "", () -> {
            StringBuilder content = new StringBuilder();
            for (ShaderRegistry.ShaderRegistryEntry shader : ShaderRegistry.shaderRegistry.values()) {
                String key = shader.name.getPath();
                content.append("<&").append(key).append(">").append("<np>");
            }
            int last = content.lastIndexOf("<np>");
            content.delete(last, last + 4);
            return content.toString();
        });
        for (ShaderRegistry.ShaderRegistryEntry shader : ShaderRegistry.shaderRegistry.values()) {
            String key = shader.name.getPath();
            builder.addSpecialElement(new ManualEntry.SpecialElementData(key, 0, new ShaderManualElement(ieMan, shader)));
        }
        builder.setLocation(IEApi.ieLoc("shader_list"));
        ManualEntry e = builder.create();
        ieMan.addEntry(toolsCat, e);
        ieMan.hideEntry(e.getLocation());
        IEManual.addChangelogToManual();
    }

    private static Pair<String, List<ManualEntry.SpecialElementData>> getMineralVeinTexts() {
        StringBuilder text = new StringBuilder();
        ArrayList<ManualEntry.SpecialElementData> specials = new ArrayList<ManualEntry.SpecialElementData>();
        ArrayList<RecipeHolder<MineralMix>> mineralsToAdd = new ArrayList<RecipeHolder<MineralMix>>(MineralMix.RECIPES.getRecipes((Level)Minecraft.getInstance().level));
        Function<RecipeHolder, String> toName = mineral -> {
            String translationKey = MineralMix.getTranslationKey(mineral.id());
            String localizedName = I18n.get((String)translationKey, (Object[])new Object[0]);
            if (localizedName.equals(translationKey)) {
                localizedName = MineralMix.getPlainName(mineral.id());
            }
            return localizedName;
        };
        mineralsToAdd.sort((i1, i2) -> ((String)toName.apply((RecipeHolder)i1)).compareToIgnoreCase((String)toName.apply((RecipeHolder)i2)));
        for (RecipeHolder recipeHolder : mineralsToAdd) {
            MineralMix mineral2 = (MineralMix)recipeHolder.value();
            String biomeText = mineral2.biomeTagPredicates.stream().map(biomeTagPredicate -> biomeTagPredicate.tags().stream().map(biomeTagKey -> {
                String key = biomeTagKey.location().toLanguageKey("tag.biome").replaceAll("/", ".");
                if (I18n.exists((String)key)) {
                    return I18n.get((String)key, (Object[])new Object[0]);
                }
                return biomeTagKey.location().getPath();
            }).reduce((s, s2) -> I18n.get((String)"ie.manual.entry.minerals.biomes_or", (Object[])new Object[]{s, s2})).orElse("")).reduce((s, s2) -> I18n.get((String)"ie.manual.entry.minerals.biomes_and", (Object[])new Object[]{s, s2})).orElse("");
            String openingString = I18n.get((String)"ie.manual.entry.minerals.biomes", (Object[])new Object[]{toName.apply(recipeHolder), biomeText});
            ArrayList<StackWithChance> formattedOutputs = new ArrayList<StackWithChance>(mineral2.outputs);
            ArrayList<StackWithChance> formattedSpoils = new ArrayList<StackWithChance>(mineral2.spoils);
            formattedOutputs.sort(Comparator.comparingDouble(i -> -i.chance()));
            formattedSpoils.sort(Comparator.comparingDouble(i -> -i.chance()));
            StringBuilder outputString = new StringBuilder();
            NonNullList sortedOres = NonNullList.create();
            for (StackWithChance stackWithChance : formattedOutputs) {
                outputString.append("\n").append(new DecimalFormat("00.00").format(stackWithChance.chance() * 100.0f).replaceAll("\\G0", "\u00a0")).append("% ").append(stackWithChance.stack().get().getHoverName().getString());
                sortedOres.add((Object)stackWithChance.stack().get());
            }
            StringBuilder spoilString = new StringBuilder();
            for (StackWithChance sorted3 : formattedSpoils) {
                spoilString.append("\n").append(new DecimalFormat("00.00").format(sorted3.chance() * 100.0f).replaceAll("\\G0", "\u00a0")).append("% ").append(sorted3.stack().get().getHoverName().getString());
                sortedOres.add((Object)sorted3.stack().get());
            }
            specials.add(new ManualEntry.SpecialElementData(recipeHolder.id().toString(), 0, new ManualElementItem(ManualHelper.getManual(), (NonNullList<ItemStack>)sortedOres)));
            String string = I18n.get((String)"ie.manual.entry.minerals_desc", (Object[])new Object[]{openingString, outputString.toString(), spoilString.toString()});
            if (!text.isEmpty()) {
                text.append("<np>");
            }
            text.append("<&").append(recipeHolder.id()).append(">").append(string);
        }
        return Pair.of((Object)text.toString(), specials);
    }

    private static void addChangelogToManual() {
        TreeMap allChanges = new TreeMap(Comparator.reverseOrder());
        ComparableVersion currIEVer = new ComparableVersion(ImmersiveEngineering.VERSION);
        try (InputStream in = ((Resource)Minecraft.getInstance().getResourceManager().getResource(IEApi.ieLoc("changelog.json")).orElseThrow()).open();){
            JsonElement ele = JsonParser.parseReader((Reader)new InputStreamReader(in));
            JsonObject jsonObject = ele.getAsJsonObject();
            for (Object entry : jsonObject.entrySet()) {
                ComparableVersion version = new ComparableVersion((String)entry.getKey());
                ManualEntry manualEntry = IEManual.addVersionToManual(currIEVer, version, ((JsonElement)entry.getValue()).getAsString(), false);
                if (manualEntry == null) continue;
                allChanges.put(version, manualEntry);
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)ModLoadingContext.get().getActiveContainer().getModInfo());
        if (result.status() != VersionChecker.Status.PENDING && result.status() != VersionChecker.Status.FAILED) {
            for (Map.Entry entry : result.changes().entrySet()) {
                if (allChanges.containsKey(entry.getKey())) continue;
                allChanges.put((ComparableVersion)entry.getKey(), IEManual.addVersionToManual(currIEVer, (ComparableVersion)entry.getKey(), (String)entry.getValue(), true));
            }
        }
        ManualInstance ieMan = ManualHelper.getManual();
        Tree.InnerNode<ResourceLocation, ManualEntry> innerNode = ieMan.getRoot().getOrCreateSubnode(IEApi.ieLoc(ManualHelper.CAT_UPDATE), -2);
        for (Object entry : allChanges.values()) {
            ManualHelper.getManual().addEntry(innerNode, (ManualEntry)entry);
        }
    }

    private static ManualEntry addVersionToManual(ComparableVersion currVer, ComparableVersion version, String changes, boolean ahead) {
        String text = changes.replace("\t", "  ");
        ManualEntry.ManualEntryBuilder builder = new ManualEntry.ManualEntryBuilder(ManualHelper.getManual());
        builder.setContent(() -> {
            Object title = version.toString();
            if (ahead) {
                title = (String)title + " - " + I18n.get((String)"ie.manual.newerVersion", (Object[])new Object[0]);
            } else if (currVer.equals((Object)version)) {
                title = (String)title + " - " + I18n.get((String)"ie.manual.currentVersion", (Object[])new Object[0]);
            }
            return title;
        }, () -> "", () -> text);
        builder.setLocation(IEApi.ieLoc("changelog_" + version.toString()));
        return builder.create();
    }

    static Component[][] formatToTable_ItemIntMap(Map<Component, Integer> map, String valueType) {
        ArrayList<Map.Entry<Component, Integer>> sortedMapArray = new ArrayList<Map.Entry<Component, Integer>>(map.entrySet());
        sortedMapArray.sort(Map.Entry.comparingByValue());
        ArrayList<Component[]> list = new ArrayList<Component[]>();
        try {
            for (Map.Entry entry : sortedMapArray) {
                Component item = (Component)entry.getKey();
                if (item == null) {
                    item = Component.empty();
                }
                int bt = (Integer)entry.getValue();
                MutableComponent am = Component.literal((String)(bt + " " + valueType));
                list.add(new Component[]{item, am});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Component[][])list.toArray((T[])new Component[0][]);
    }

    static ManualRecipeRef[] collectRecipeStacksFromJSON(JsonObject json) {
        ManualRecipeRef[] stacks;
        ManualInstance manual = ManualHelper.getManual();
        if (GsonHelper.isArrayNode((JsonObject)json, (String)"recipes")) {
            JsonArray arr = json.get("recipes").getAsJsonArray();
            stacks = new ManualRecipeRef[arr.size()];
            for (int i = 0; i < stacks.length; ++i) {
                stacks[i] = ManualUtils.getRecipeObjFromJson(manual, arr.get(i));
            }
        } else {
            stacks = new ManualRecipeRef[]{ManualUtils.getRecipeObjFromJson(manual, json.get("recipe"))};
        }
        return stacks;
    }

    static Fluid[] collectRecipeFluidsFromJSON(JsonObject json) {
        Fluid[] stacks;
        if (GsonHelper.isArrayNode((JsonObject)json, (String)"recipes")) {
            JsonArray arr = json.get("recipes").getAsJsonArray();
            stacks = new Fluid[arr.size()];
            for (int i = 0; i < stacks.length; ++i) {
                stacks[i] = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)arr.get(i).getAsJsonObject(), (String)"fluid")));
            }
        } else {
            JsonElement recipe = json.get("recipe");
            Preconditions.checkArgument((boolean)recipe.isJsonObject());
            stacks = new Fluid[]{(Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)recipe.getAsJsonObject(), (String)"fluid")))};
        }
        return stacks;
    }
}

