/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.conveyor.ClientConveyors;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorWall;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorBelt;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorModelRender;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ModelConveyor<T extends IConveyorBelt>
extends BakedIEModel {
    private static final ModelProperty<IConveyorBelt> CONVEYOR_MODEL_DATA = new ModelProperty();
    public static final ResourceLocation[] rl_casing = new ResourceLocation[]{IEApi.ieLoc("block/conveyor/casing_top"), IEApi.ieLoc("block/conveyor/casing_side"), IEApi.ieLoc("block/conveyor/casing_walls"), IEApi.ieLoc("block/conveyor/casing_full")};
    private final Map<RenderType, Cache<Object, List<BakedQuad>>> modelCache = new HashMap<RenderType, Cache<Object, List<BakedQuad>>>();
    private final IConveyorType<T> type;
    private final Block fallbackCover;
    TextureAtlasSprite tex_particle;
    private static final ItemOverrides overrideList = new ItemOverrides(){
        private final LoadingCache<Key, BakedModel> itemModelCache = CacheBuilder.newBuilder().maximumSize(100L).build(CacheLoader.from(key -> new ModelConveyor(key.type(), key.defaultCover())));

        public BakedModel resolve(@Nonnull BakedModel originalModel, @Nonnull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int unused) {
            BlockItem asBlock;
            Block b;
            IConveyorType<?> conveyorType;
            Item item = stack.getItem();
            if (item instanceof BlockItem && (conveyorType = ConveyorHandler.getType(b = (asBlock = (BlockItem)item).getBlock())) != null) {
                Block defaultCover = ConveyorBlock.getCover(stack);
                return (BakedModel)this.itemModelCache.getUnchecked((Object)new Key(conveyorType, defaultCover));
            }
            return Minecraft.getInstance().getModelManager().getMissingModel();
        }

        record Key(IConveyorType<?> type, Block defaultCover) {
        }
    };
    private static final Map<ItemDisplayContext, Transformation> TRANSFORMATION_MAP;

    public ModelConveyor(IConveyorType<T> type, Block fallbackCover) {
        this.modelCache.put(RenderType.translucent(), (Cache<Object, List<BakedQuad>>)CacheBuilder.newBuilder().maximumSize(100L).build());
        this.modelCache.put(RenderType.cutout(), (Cache<Object, List<BakedQuad>>)CacheBuilder.newBuilder().maximumSize(100L).build());
        this.modelCache.put(null, (Cache<Object, List<BakedQuad>>)CacheBuilder.newBuilder().maximumSize(100L).build());
        this.type = type;
        this.fallbackCover = fallbackCover;
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        if (side != null) {
            return List.of();
        }
        Direction facing = Direction.NORTH;
        IConveyorBelt conveyor = null;
        if (blockState != null) {
            BlockEntity tile;
            facing = (Direction)blockState.getValue((Property)IEProperties.FACING_HORIZONTAL);
            if (extraData.has(CONVEYOR_MODEL_DATA)) {
                conveyor = (IConveyorBelt)extraData.get(CONVEYOR_MODEL_DATA);
            }
            if (conveyor != null && (tile = conveyor.getBlockEntity()) instanceof IEBlockInterfaces.IDirectionalBE) {
                facing = ((IEBlockInterfaces.IDirectionalBE)tile).getFacing();
            }
        }
        IConveyorModelRender<Object> clientData = ClientConveyors.getData(this.type);
        IConveyorModelRender.RenderContext<Object> context = new IConveyorModelRender.RenderContext<Object>((IConveyorType<Object>)this.type, conveyor, this.fallbackCover);
        Object key = clientData.getModelCacheKey(context);
        Cache<Object, List<BakedQuad>> layerCache = this.modelCache.get(layer);
        List<BakedQuad> cachedQuads = (List<BakedQuad>)layerCache.getIfPresent(key);
        if (cachedQuads == null) {
            cachedQuads = Collections.synchronizedList(Lists.newArrayList());
            Transformation matrix = ClientUtils.rotateTo(facing);
            matrix = clientData.modifyBaseRotationMatrix(matrix);
            ConveyorHandler.ConveyorDirection conDir = conveyor != null ? conveyor.getConveyorDirection() : ConveyorHandler.ConveyorDirection.HORIZONTAL;
            boolean[] walls = new boolean[]{clientData.shouldRenderWall(facing, ConveyorWall.LEFT, context), clientData.shouldRenderWall(facing, ConveyorWall.RIGHT, context)};
            TextureAtlasSprite tex_conveyor = ClientUtils.getSprite(context.isActiveOr(false) ? clientData.getActiveTexture() : clientData.getInactiveTexture());
            DyeColor colourStripes = null;
            TextureAtlasSprite tex_conveyor_colour = null;
            if (conveyor != null && (colourStripes = conveyor.getDyeColour()) != null) {
                tex_conveyor_colour = ClientUtils.getSprite(clientData.getColouredStripesTexture());
            }
            if (layer == null || layer == RenderType.cutout()) {
                cachedQuads.addAll(ModelConveyor.getBaseConveyor(facing, 1.0f, matrix, conDir, tex_conveyor, walls, new boolean[]{true, true}, tex_conveyor_colour, colourStripes));
            }
            cachedQuads = clientData.modifyQuads(cachedQuads, context, layer);
            layerCache.put(key, (Object)ImmutableList.copyOf(cachedQuads));
        }
        return ImmutableList.copyOf((Collection)cachedQuads);
    }

    public static List<BakedQuad> getBaseConveyor(Direction facing, float length, Transformation matrix, ConveyorHandler.ConveyorDirection conDir, TextureAtlasSprite tex_conveyor, boolean[] walls, boolean[] corners, TextureAtlasSprite tex_conveyor_colour, @Nullable DyeColor stripeColour) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        TextureAtlasSprite tex_casing1 = ClientUtils.getSprite(rl_casing[1]);
        TextureAtlasSprite tex_casing2 = ClientUtils.getSprite(rl_casing[2]);
        float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] colourStripes = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        if (stripeColour != null) {
            Vector4f colorVec = Utils.vec4fFromDye(stripeColour);
            colourStripes = new float[]{colorVec.x, colorVec.y, colorVec.z, colorVec.w};
        }
        TextureAtlasSprite topTexture = tex_conveyor_colour != null ? tex_conveyor_colour : tex_casing2;
        float[] topColor = stripeColour != null ? colourStripes : colour;
        double zLength = 1.0f - length;
        Vec3[] bottom = new Vec3[]{new Vec3(0.0, 0.0, zLength), new Vec3(0.0, 0.0, 1.0), new Vec3(1.0, 0.0, 1.0), new Vec3(1.0, 0.0, zLength)};
        Vec3[] bottomBelt = new Vec3[]{new Vec3(0.0625, 0.0, zLength), new Vec3(0.0625, 0.0, 1.0), new Vec3(0.9375, 0.0, 1.0), new Vec3(0.9375, 0.0, zLength)};
        Vec3[] top = new Vec3[]{new Vec3(0.0, 0.125, zLength), new Vec3(0.0, 0.125, 1.0), new Vec3(1.0, 0.125, 1.0), new Vec3(1.0, 0.125, zLength)};
        Vec3[] topBelt = new Vec3[]{new Vec3(0.0625, 0.125, zLength), new Vec3(0.0625, 0.125, 1.0), new Vec3(0.9375, 0.125, 1.0), new Vec3(0.9375, 0.125, zLength)};
        Vec3[] corner = new Vec3[]{new Vec3(0.0, 0.1875, zLength), new Vec3(0.0, 0.1875, 1.0), new Vec3(1.0, 0.1875, 1.0), new Vec3(1.0, 0.1875, zLength)};
        Vec3[] cornerBelt = new Vec3[]{new Vec3(0.0625, 0.1875, zLength), new Vec3(0.0625, 0.1875, 1.0), new Vec3(0.9375, 0.1875, 1.0), new Vec3(0.9375, 0.1875, zLength)};
        double zLengthWall = zLength + 0.0625;
        Vec3[] wallOuter = new Vec3[]{new Vec3(0.0, 0.125, zLengthWall), new Vec3(0.0, 0.125, 0.9375), new Vec3(1.0, 0.125, 0.9375), new Vec3(1.0, 0.125, zLengthWall)};
        Vec3[] wallInner = new Vec3[]{new Vec3(0.0625, 0.125, zLengthWall), new Vec3(0.0625, 0.125, 0.9375), new Vec3(0.9375, 0.125, 0.9375), new Vec3(0.9375, 0.125, zLengthWall)};
        Vec3[] wallOuterTop = new Vec3[]{new Vec3(0.0, 0.1875, zLengthWall), new Vec3(0.0, 0.1875, 0.9375), new Vec3(1.0, 0.1875, 0.9375), new Vec3(1.0, 0.1875, zLengthWall)};
        Vec3[] wallInnerTop = new Vec3[]{new Vec3(0.0625, 0.1875, zLengthWall), new Vec3(0.0625, 0.1875, 0.9375), new Vec3(0.9375, 0.1875, 0.9375), new Vec3(0.9375, 0.1875, zLengthWall)};
        if (conDir != ConveyorHandler.ConveyorDirection.HORIZONTAL) {
            int[] elevatedVerts;
            int[] nArray;
            if (conDir == ConveyorHandler.ConveyorDirection.UP) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0;
                nArray = nArray2;
                nArray2[1] = 3;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = 1;
                nArray = nArray3;
                nArray3[1] = 2;
            }
            for (int i : elevatedVerts = nArray) {
                for (Vec3[] array : new Vec3[][]{bottom, bottomBelt, top, topBelt, corner, cornerBelt}) {
                    array[i] = array[i].add(0.0, (double)length, 0.0);
                }
            }
            for (Vec3[] array : new Vec3[][]{wallOuter, wallInner, wallOuterTop, wallInnerTop}) {
                for (int i = 0; i < array.length; ++i) {
                    double f = i == 0 || i == 3 ? (conDir == ConveyorHandler.ConveyorDirection.UP ? (double)length - 0.0625 : 0.0625) : (conDir == ConveyorHandler.ConveyorDirection.UP ? 0.0625 : (double)length - 0.0625);
                    array[i] = array[i].add(0.0, f, 0.0);
                }
            }
        }
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, bottomBelt), Utils.rotateFacingTowardsDir(Direction.DOWN, facing), tex_conveyor, new double[]{1.0, 0.0, 15.0, length * 16.0f}, colour, true));
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, bottom), Utils.rotateFacingTowardsDir(Direction.DOWN, facing), tex_casing2, new double[]{0.0, 0.0, 16.0, length * 16.0f}, colour, true));
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, top), Utils.rotateFacingTowardsDir(Direction.UP, facing), tex_conveyor, new double[]{0.0, length * 16.0f, 16.0, 0.0}, colour, false));
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, bottom[0], bottom[1], top[1], top[0]), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{0.0, 0.0, 2.0, length * 16.0f}, colour, false));
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, bottom[2], bottom[3], top[3], top[2]), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{0.0, 0.0, 2.0, length * 16.0f}, colour, false));
        double frontUMax = (1.0f - length) * 16.0f;
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, bottomBelt[0], topBelt[0], topBelt[3], bottomBelt[3]), facing, tex_conveyor, new double[]{1.0, frontUMax + 2.0, 15.0, frontUMax}, colour, false));
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, bottom[0], top[0], top[3], bottom[3]), facing, tex_casing2, new double[]{0.0, 2.0, 16.0, 0.0}, colour, false));
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, bottomBelt[1], topBelt[1], topBelt[2], bottomBelt[2]), facing.getOpposite(), tex_conveyor, new double[]{1.0, 0.0, 15.0, 2.0}, colour, true));
        quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, bottom[1], top[1], top[2], bottom[2]), facing.getOpposite(), tex_casing2, new double[]{0.0, 0.0, 16.0, 2.0}, colour, true));
        if (corners[0]) {
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuterTop[1], corner[1], cornerBelt[1], wallInnerTop[1]), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{0.0, 1.0, 1.0, 0.0}, topColor, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuterTop[2], corner[2], cornerBelt[2], wallInnerTop[2]), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{15.0, 1.0, 16.0, 0.0}, topColor, true));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, top[1], corner[1], cornerBelt[1], topBelt[1]), facing.getOpposite(), tex_casing2, new double[]{0.0, 2.0, 1.0, 3.0}, colour, true));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, top[2], corner[2], cornerBelt[2], topBelt[2]), facing.getOpposite(), tex_casing2, new double[]{15.0, 2.0, 16.0, 3.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuter[1], wallOuterTop[1], wallInnerTop[1], wallInner[1]), facing.getOpposite(), tex_casing2, new double[]{0.0, 2.0, 1.0, 3.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuter[2], wallOuterTop[2], wallInnerTop[2], wallInner[2]), facing.getOpposite(), tex_casing2, new double[]{15.0, 2.0, 16.0, 3.0}, colour, true));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuter[1], top[1], corner[1], wallOuterTop[1]), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{0.0, 2.0, 1.0, 3.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallInner[1], topBelt[1], cornerBelt[1], wallInnerTop[1]), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{15.0, 2.0, 16.0, 3.0}, colour, true));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, top[2], wallOuter[2], wallOuterTop[2], corner[2]), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{15.0, 2.0, 16.0, 3.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, topBelt[2], wallInner[2], wallInnerTop[2], cornerBelt[2]), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{0.0, 2.0, 1.0, 3.0}, colour, true));
        }
        if (corners[1]) {
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuterTop[3], corner[3], cornerBelt[3], wallInnerTop[3]), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{0.0, 16.0, 1.0, 15.0}, topColor, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuterTop[0], corner[0], cornerBelt[0], wallInnerTop[0]), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{15.0, 16.0, 16.0, 15.0}, topColor, true));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, top[3], corner[3], cornerBelt[3], topBelt[3]), facing.getOpposite(), tex_casing2, new double[]{0.0, 2.0, 1.0, 3.0}, colour, true));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, top[0], corner[0], cornerBelt[0], topBelt[0]), facing.getOpposite(), tex_casing2, new double[]{15.0, 2.0, 16.0, 3.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuter[3], wallOuterTop[3], wallInnerTop[3], wallInner[3]), facing.getOpposite(), tex_casing2, new double[]{0.0, 2.0, 1.0, 3.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuter[0], wallOuterTop[0], wallInnerTop[0], wallInner[0]), facing.getOpposite(), tex_casing2, new double[]{15.0, 2.0, 16.0, 3.0}, colour, true));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuter[3], top[3], corner[3], wallOuterTop[3]), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{0.0, 2.0, 1.0, 3.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallInner[3], topBelt[3], cornerBelt[3], wallInnerTop[3]), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{15.0, 2.0, 16.0, 3.0}, colour, true));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, top[0], wallOuter[0], wallOuterTop[0], corner[0]), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{15.0, 2.0, 16.0, 3.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, topBelt[0], wallInner[0], wallInnerTop[0], cornerBelt[0]), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{0.0, 2.0, 1.0, 3.0}, colour, true));
        }
        if (walls[0]) {
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuterTop[0], wallOuterTop[1], wallInnerTop[1], wallInnerTop[0]), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{0.0, 15.0, 1.0, 1.0}, topColor, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuter[0], wallOuter[1], wallOuterTop[1], wallOuterTop[0]), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{2.0, 15.0, 3.0, 1.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallInner[0], wallInner[1], wallInnerTop[1], wallInnerTop[0]), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{2.0, 15.0, 3.0, 1.0}, colour, true));
        }
        if (walls[1]) {
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuterTop[2], wallOuterTop[3], wallInnerTop[3], wallInnerTop[2]), Utils.rotateFacingTowardsDir(Direction.UP, facing), topTexture, new double[]{15.0, 15.0, 16.0, 1.0}, topColor, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallInner[3], wallInner[2], wallInnerTop[2], wallInnerTop[3]), Utils.rotateFacingTowardsDir(Direction.WEST, facing), tex_casing1, new double[]{2.0, 15.0, 3.0, 1.0}, colour, false));
            quads.add(ModelUtils.createBakedQuad(ClientUtils.applyMatrixToVertices(matrix, wallOuter[3], wallOuter[2], wallOuterTop[2], wallOuterTop[3]), Utils.rotateFacingTowardsDir(Direction.EAST, facing), tex_casing1, new double[]{2.0, 15.0, 3.0, 1.0}, colour, true));
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite getParticleIcon() {
        if (this.tex_particle == null) {
            this.tex_particle = ClientUtils.getSprite(IEApi.ieLoc("block/conveyor/off"));
        }
        return this.tex_particle;
    }

    @Nonnull
    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }

    @Nonnull
    public ItemOverrides getOverrides() {
        return overrideList;
    }

    @Nonnull
    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack stack, boolean applyLeftHandTransform) {
        Transformation transform = TRANSFORMATION_MAP.get(transformType);
        if (transform != null) {
            Vector3f translate = transform.getTranslation();
            stack.translate(translate.x(), translate.y(), translate.z());
            stack.mulPose(transform.getLeftRotation());
            Vector3f scale = transform.getScale();
            stack.scale(scale.x(), scale.y(), scale.z());
            stack.mulPose(transform.getRightRotation());
        }
        return this;
    }

    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        Block b = state.getBlock();
        IConveyorType<?> conveyorName = ConveyorHandler.getType(b);
        if (conveyorName == null) {
            return tileData;
        }
        BlockEntity bEntity = world.getBlockEntity(pos);
        if (!(bEntity instanceof ConveyorHandler.IConveyorBlockEntity)) {
            return tileData;
        }
        return tileData.derive().with(CONVEYOR_MODEL_DATA, ConveyorHandler.getConveyor(conveyorName, bEntity)).build();
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return List.of(NeoForgeRenderTypes.ITEM_LAYERED_CUTOUT.get());
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout(), RenderType.translucent()});
    }

    static {
        EnumMap<ItemDisplayContext, Matrix4> matrixMap = new EnumMap<ItemDisplayContext, Matrix4>(ItemDisplayContext.class);
        matrixMap.put(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, new Matrix4().scale(0.5, 0.5, 0.5).translate(0.0, 0.25, 0.0).rotate(Math.toRadians(-45.0), 0.0, 1.0, 0.0));
        matrixMap.put(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, new Matrix4().scale(0.5, 0.5, 0.5).translate(0.0, 0.25, 0.0).rotate(Math.toRadians(-45.0), 0.0, 1.0, 0.0));
        matrixMap.put(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.3125, 0.3125, 0.3125).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        matrixMap.put(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, new Matrix4().translate(0.0, 0.0625, -0.125).scale(0.3125, 0.3125, 0.3125).rotate(Math.toRadians(30.0), 1.0, 0.0, 0.0).rotate(Math.toRadians(130.0), 0.0, 1.0, 0.0));
        matrixMap.put(ItemDisplayContext.GUI, new Matrix4().scale(0.625, 0.625, 0.625).rotate(Math.toRadians(-45.0), 0.0, 1.0, 0.0).rotate(Math.toRadians(-20.0), 0.0, 0.0, 1.0).rotate(Math.toRadians(20.0), 1.0, 0.0, 0.0));
        matrixMap.put(ItemDisplayContext.FIXED, new Matrix4().scale(0.625, 0.625, 0.625).rotate(Math.PI, 0.0, 1.0, 0.0).translate(0.0, 0.0, 0.3125));
        matrixMap.put(ItemDisplayContext.GROUND, new Matrix4().scale(0.25, 0.25, 0.25));
        TRANSFORMATION_MAP = matrixMap.entrySet().stream().map(e -> Pair.of((Object)((ItemDisplayContext)e.getKey()), (Object)((Matrix4)e.getValue()).toTransformationMatrix())).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public static class ConveyorLoader
    implements IGeometryLoader<RawConveyorModel> {
        public static final ResourceLocation LOCATION = IEApi.ieLoc("models/conveyor");
        public static final String TYPE_KEY = "conveyorType";

        @Nonnull
        public RawConveyorModel read(JsonObject modelContents, @Nonnull JsonDeserializationContext deserializationContext) {
            String typeName = modelContents.get(TYPE_KEY).getAsString();
            IConveyorType<?> type = ConveyorHandler.getConveyorType(ResourceLocation.parse((String)typeName));
            return new RawConveyorModel(Objects.requireNonNull(type));
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=EventBusSubscriber.Bus.MOD)
    public record RawConveyorModel(IConveyorType<?> type) implements IUnbakedGeometry<RawConveyorModel>
    {
        private static final AtomicBoolean REFRESHED_SINCE_BAKE = new AtomicBoolean(false);

        public BakedModel bake(IGeometryBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
            if (!REFRESHED_SINCE_BAKE.getAndSet(true)) {
                for (IConveyorType<?> conveyorType : ConveyorHandler.getConveyorTypes()) {
                    ClientConveyors.getData(conveyorType).updateCachedModels(bakery, spriteGetter);
                }
            }
            return new ModelConveyor(this.type, Blocks.AIR);
        }

        @SubscribeEvent
        public static void onModelBakingDone(ModelEvent.BakingCompleted ev) {
            REFRESHED_SINCE_BAKE.set(false);
        }
    }
}

