/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.api.client.ieobj.BlockCallback;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.ShelfLogic;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ShelfCallbacks
implements BlockCallback<Key> {
    public static final ShelfCallbacks INSTANCE = new ShelfCallbacks();

    @Override
    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState blockState, BlockEntity blockEntity) {
        IMultiblockBE multiblockBE;
        Object State2;
        if (blockEntity instanceof IMultiblockBE && (State2 = (multiblockBE = (IMultiblockBE)blockEntity).getHelper().getState()) instanceof ShelfLogic.State) {
            ShelfLogic.State state = (ShelfLogic.State)State2;
            return this.extractKey(state);
        }
        return this.getDefaultKey();
    }

    public Key extractKey(ShelfLogic.State state) {
        Function atlas = ClientUtils.mc().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        HashMap<String, TextureAtlasSprite> texMap = new HashMap<String, TextureAtlasSprite>();
        for (int i = 0; i < state.renderCrates.length; ++i) {
            if (state.renderCrates[i] == null) continue;
            texMap.put("crate_" + i, (TextureAtlasSprite)atlas.apply(state.renderCrates[i]));
        }
        return new Key(texMap);
    }

    @Override
    public Key getDefaultKey() {
        return new Key(Collections.emptyMap());
    }

    @Override
    public boolean shouldRenderGroup(Key key, String group, RenderType layer) {
        if (group.startsWith("crate_")) {
            return key.texMap().containsKey(group);
        }
        return true;
    }

    @Override
    @Nullable
    public TextureAtlasSprite getTextureReplacement(Key key, String group, String material) {
        return key.texMap().get(group);
    }

    public record Key(Map<String, TextureAtlasSprite> texMap) {
    }
}

