/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.BlueprintRenderer;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEMultiblockRenderer;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.AutoWorkbenchLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public class AutoWorkbenchRenderer
extends IEMultiblockRenderer<AutoWorkbenchLogic.State> {
    public static final String NAME = "auto_workbench_animated";
    public static DynamicModel DYNAMIC;

    @Override
    public void render(IMultiblockContext<AutoWorkbenchLogic.State> ctx, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BakedModel model = DYNAMIC.get();
        AutoWorkbenchLogic.State state = ctx.getState();
        float[][] itemDisplays = new float[state.processor.getQueueSize()][];
        float drill = 0.0f;
        float lift = 0.0f;
        float press = 0.0f;
        float liftPress = 0.0f;
        Level level = ctx.getLevel().getRawLevel();
        for (int i = 0; i < itemDisplays.length; ++i) {
            float processTimer;
            MultiblockProcess process = state.processor.getQueue().get(i);
            if (process == null || process.processTick <= 0 || process.processTick == process.getMaxTicks(level) || (processTimer = (float)process.processTick / (float)process.getMaxTicks(level) * 180.0f) <= 9.0f) continue;
            float itemX = -1.0f;
            float itemY = -0.34375f;
            float itemZ = -0.9375f;
            float itemAngle = 1.5707964f;
            if (processTimer <= 24.0f) {
                itemAngle = 1.1780972f;
                if (processTimer <= 19.0f) {
                    itemZ = (float)((double)itemZ + (0.25 + (double)((19.0f - processTimer) / 10.0f * 0.5f)));
                    itemY = (float)((double)itemY + (0.25 + (double)((19.0f - processTimer) / 10.0f * 0.21875f)));
                } else {
                    itemZ += (24.0f - processTimer) / 5.0f * 0.25f;
                    itemY += (24.0f - processTimer) / 5.0f * 0.25f;
                }
            } else if (processTimer <= 40.0f) {
                itemX += (processTimer - 24.0f) / 16.0f;
            } else if (processTimer <= 100.0f) {
                itemX += 1.0f;
                float drillStep = 0.0f;
                if (processTimer <= 60.0f) {
                    lift = (processTimer - 40.0f) / 20.0f * 0.3125f;
                    drillStep = 4.0f + (60.0f - processTimer) * 4.0f;
                } else if (processTimer <= 80.0f) {
                    lift = 0.3125f;
                    drillStep = 4.0f;
                } else {
                    lift = (100.0f - processTimer) / 20.0f * 0.3125f;
                    drillStep = 4.0f + (processTimer - 80.0f) * 4.0f;
                }
                if (drillStep > 0.0f) {
                    drill = processTimer % drillStep / drillStep * 2.0f * (float)Math.PI;
                }
                itemY = (float)((double)itemY + Math.max(0.0, (double)lift - 0.0625));
            } else if (processTimer <= 116.0f) {
                itemX += 1.0f;
                itemZ += (processTimer - 100.0f) / 16.0f;
            } else if (processTimer <= 132.0f) {
                itemX += 1.0f + (processTimer - 116.0f) / 16.0f;
                itemZ += 1.0f;
            } else if (processTimer <= 172.0f) {
                itemX += 2.0f;
                itemZ += 1.0f;
                press = processTimer <= 142.0f ? (processTimer - 132.0f) / 10.0f : (processTimer <= 162.0f ? 1.0f : (172.0f - processTimer) / 10.0f);
                liftPress = press * 0.0625f;
                itemY += liftPress;
            } else if (processTimer <= 180.0f) {
                itemX += 2.0f + (processTimer - 172.0f) / 16.0f;
                itemZ += 1.0f;
            }
            itemDisplays[i] = new float[]{processTimer, itemX, itemY, itemZ, itemAngle};
        }
        MultiblockOrientation orientation = ctx.getLevel().getOrientation();
        matrixStack.pushPose();
        bufferIn = BERenderUtils.mirror(orientation, matrixStack, bufferIn);
        Direction facing = orientation.front();
        if (orientation.mirrored()) {
            if (facing.getAxis() == Direction.Axis.Z) {
                matrixStack.translate(-1.0f, 0.0f, 0.0f);
            } else {
                matrixStack.translate(0.0f, 0.0f, -1.0f);
            }
        }
        AutoWorkbenchRenderer.rotateForFacing(matrixStack, facing);
        matrixStack.translate(0.5, 0.5, 0.5);
        matrixStack.pushPose();
        ItemStack blueprintStack = state.inventory.getStackInSlot(0);
        if (!blueprintStack.isEmpty()) {
            AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, model, combinedLightIn, combinedOverlayIn, "blueprint");
        }
        matrixStack.translate(0.0f, lift, 0.0f);
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, model, combinedLightIn, combinedOverlayIn, "lift");
        matrixStack.translate(0.0f, -lift, 0.0f);
        float tx = 0.0f;
        float tz = -0.9375f;
        matrixStack.pushPose();
        matrixStack.translate(tx, 0.0f, tz);
        matrixStack.mulPose(new Quaternionf().rotateXYZ(0.0f, drill, 0.0f));
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, model, combinedLightIn, combinedOverlayIn, "drill");
        matrixStack.popPose();
        tx = 0.0f;
        tz = -0.59375f;
        matrixStack.pushPose();
        matrixStack.translate((double)tx, -0.21875, (double)tz);
        matrixStack.mulPose(new Quaternionf().rotateXYZ(press * 1.5707964f, 0.0f, 0.0f));
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, model, combinedLightIn, combinedOverlayIn, "press");
        matrixStack.popPose();
        matrixStack.translate(0.0f, liftPress, 0.0f);
        AutoWorkbenchRenderer.renderModelPart(matrixStack, blockRenderer, bufferIn, model, combinedLightIn, combinedOverlayIn, "pressLift");
        matrixStack.popPose();
        for (int i = 0; i < itemDisplays.length; ++i) {
            MultiblockProcess process;
            if (itemDisplays[i] == null || !((process = state.processor.getQueue().get(i)) instanceof MultiblockProcessInWorld)) continue;
            MultiblockProcessInWorld inWorld = (MultiblockProcessInWorld)process;
            float scale = 0.3125f;
            List<ItemStack> dList = inWorld.getDisplayItem(level);
            if (dList.isEmpty()) continue;
            if (dList.size() < 2) {
                matrixStack.pushPose();
                matrixStack.translate(itemDisplays[i][1], itemDisplays[i][2], itemDisplays[i][3]);
                matrixStack.mulPose(new Quaternionf().rotateXYZ(itemDisplays[i][4], 0.0f, 0.0f));
                matrixStack.scale(scale, scale, 0.5f);
                ClientUtils.mc().getItemRenderer().renderStatic(dList.get(0), ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, level, 0);
                matrixStack.popPose();
                continue;
            }
            int size = dList.size();
            int lines = (int)Math.ceil((float)size / 2.0f);
            float spacer = (float)(lines - 1) * 0.234375f;
            for (int d = 0; d < size; ++d) {
                float oX = (size > 2 ? -0.3125f : 0.0f) + (float)(lines - d / 2) * 0.0625f + (float)(d % 2) * 0.3125f;
                float oZ = -spacer / 2.0f + (float)(d / 2) * 0.234375f;
                float oY = 0.0f;
                float localItemX = itemDisplays[i][1] + oX;
                float localItemY = itemDisplays[i][2] + oY;
                float localItemZ = itemDisplays[i][3] + oZ;
                float subProcess = itemDisplays[i][0] - (float)(d / 2 * 4);
                float localAngle = itemDisplays[i][4];
                if (subProcess <= 24.0f) {
                    localAngle = 67.5f;
                    if (subProcess <= 19.0f) {
                        localItemZ = -0.75f + (19.0f - subProcess) / 10.0f * 0.5f;
                        localItemY = -0.09375f + (19.0f - subProcess) / 10.0f * 0.21875f;
                    } else {
                        localItemZ = -1.0f + (oZ - (24.0f - subProcess) / 5.0f * oZ);
                        localItemY = -0.34375f + (24.0f - subProcess) / 5.0f * 0.25f;
                    }
                }
                matrixStack.pushPose();
                matrixStack.translate(localItemX, localItemY, localItemZ);
                matrixStack.mulPose(new Quaternionf().rotateXYZ((float)Math.toRadians(localAngle), 0.0f, 0.0f));
                matrixStack.scale(scale, scale, 0.5f);
                ClientUtils.mc().getItemRenderer().renderStatic(dList.get(d), ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, level, 0);
                matrixStack.popPose();
            }
        }
        double playerDistanceSq = ClientUtils.mc().player.distanceToSqr(Vec3.atCenterOf((Vec3i)ctx.getLevel().toAbsolute(IEMultiblockLogic.AUTO_WORKBENCH.masterPosInMB())));
        if (!blueprintStack.isEmpty() && playerDistanceSq < 1000.0) {
            BlueprintRenderer.BlueprintLines blueprint;
            List<RecipeHolder<BlueprintCraftingRecipe>> recipes = BlueprintCraftingRecipe.findRecipes(level, IEApiDataComponents.getBlueprintType(blueprintStack));
            BlueprintCraftingRecipe recipe = state.selectedRecipe < 0 || state.selectedRecipe >= recipes.size() ? null : (BlueprintCraftingRecipe)recipes.get(state.selectedRecipe).value();
            BlueprintRenderer.BlueprintLines blueprintLines = blueprint = recipe == null ? null : BlueprintRenderer.getBlueprintDrawable(recipe, level);
            if (blueprint != null) {
                matrixStack.pushPose();
                matrixStack.translate(-0.195, 0.125, 0.97);
                matrixStack.mulPose(new Quaternionf().rotateXYZ(-0.7853982f, 0.0f, 0.0f));
                float scale = 0.5f / (float)blueprint.textureScale;
                matrixStack.scale(scale, -scale, scale);
                matrixStack.translate(0.5, 0.5, 0.5);
                blueprint.draw(matrixStack, bufferIn, combinedLightIn);
                matrixStack.popPose();
            }
        }
        matrixStack.popPose();
    }

    public static void renderModelPart(PoseStack matrix, BlockRenderDispatcher blockRenderer, MultiBufferSource buffers, BakedModel model, int light, int overlay, String parts) {
        matrix.pushPose();
        matrix.translate(-0.5, -0.5, -0.5);
        ModelData data = ModelDataUtils.single(DynamicSubmodelCallbacks.getProperty(), IEProperties.VisibilityList.show(parts));
        blockRenderer.getModelRenderer().renderModel(matrix.last(), buffers.getBuffer(RenderType.solid()), null, model, 1.0f, 1.0f, 1.0f, light, overlay, data, RenderType.solid());
        matrix.popPose();
    }
}

