/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.utils;

import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.UnionMultiblock;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import org.joml.Quaternionf;

public class UnionMBManualData
implements ClientMultiblocks.MultiblockManualData {
    private final Supplier<NonNullList<ItemStack>> materials = Suppliers.memoize(() -> {
        NonNullList stacks = NonNullList.create();
        for (UnionMultiblock.TransformedMultiblock part : parts) {
            for (ItemStack stack : ClientMultiblocks.get(part.multiblock()).getTotalMaterials()) {
                boolean added = false;
                for (ItemStack ex : stacks) {
                    if (!ItemStack.isSameItem((ItemStack)ex, (ItemStack)stack)) continue;
                    ex.grow(stack.getCount());
                    added = true;
                    break;
                }
                if (added) continue;
                stacks.add((Object)stack.copy());
            }
        }
        return stacks;
    });
    private final List<ClientSubMultiblock> partData;

    public UnionMBManualData(List<UnionMultiblock.TransformedMultiblock> parts, Vec3i min) {
        this.partData = parts.stream().map(mb -> UnionMBManualData.toClientMultiblock(mb, min)).filter(p -> p.mbData().canRenderFormedStructure()).toList();
    }

    @Override
    public NonNullList<ItemStack> getTotalMaterials() {
        return this.materials.get();
    }

    @Override
    public boolean canRenderFormedStructure() {
        return true;
    }

    @Override
    public void renderFormedStructure(PoseStack transform, MultiBufferSource buffer) {
        for (ClientSubMultiblock part : this.partData) {
            transform.pushPose();
            Vec3i offset = part.offset();
            transform.translate((float)offset.getX(), (float)offset.getY(), (float)offset.getZ());
            transform.translate(0.5, 0.5, 0.5);
            transform.mulPose(part.rotation());
            transform.translate(-0.5, -0.5, -0.5);
            part.mbData().renderFormedStructure(transform, buffer);
            transform.popPose();
        }
    }

    private static float getAngle(Rotation rot) {
        return switch (rot) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> 0.0f;
            case Rotation.CLOCKWISE_90 -> -90.0f;
            case Rotation.CLOCKWISE_180 -> 180.0f;
            case Rotation.COUNTERCLOCKWISE_90 -> 90.0f;
        };
    }

    private static ClientSubMultiblock toClientMultiblock(UnionMultiblock.TransformedMultiblock mb, Vec3i min) {
        ClientMultiblocks.MultiblockManualData data = ClientMultiblocks.get(mb.multiblock());
        Vec3i offset = mb.offset().subtract(min);
        Quaternionf rotation = new Quaternionf().rotationY(UnionMBManualData.getAngle(mb.rotation()) * ((float)Math.PI / 180));
        return new ClientSubMultiblock(data, offset, rotation);
    }

    private record ClientSubMultiblock(ClientMultiblocks.MultiblockManualData mbData, Vec3i offset, Quaternionf rotation) {
    }
}

