/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyMeterBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class EnergyMeterBlock
extends ConnectorBlock<EnergyMeterBlockEntity> {
    public static final Property<Direction> FACING = IEProperties.FACING_HORIZONTAL;
    public static final Property<Boolean> DUMMY = IEProperties.MULTIBLOCKSLAVE;

    public EnergyMeterBlock(BlockBehaviour.Properties props) {
        super(props, IEBlockEntities.ENERGY_METER);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{DUMMY, FACING, BlockStateProperties.WATERLOGGED});
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        Direction newFacing = rot.rotate((Direction)state.getValue(FACING));
        return (BlockState)state.setValue(FACING, (Comparable)newFacing);
    }

    @Override
    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        if (mirrorIn == Mirror.NONE) {
            return state;
        }
        Direction oldFacing = (Direction)state.getValue(FACING);
        Direction newFacing = mirrorIn.mirror(oldFacing);
        return (BlockState)state.setValue(FACING, (Comparable)newFacing);
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction updateSide, BlockState updatedState, LevelAccessor worldIn, BlockPos currentPos, BlockPos updatedPos) {
        Direction facing = (Direction)stateIn.getValue(FACING);
        boolean dummy = (Boolean)stateIn.getValue(DUMMY);
        BlockPos otherHalf = currentPos.above(dummy ? -1 : 1);
        BlockState otherState = worldIn.getBlockState(otherHalf);
        if (otherState.getBlock() == this) {
            if (otherState.getValue(FACING) == facing && (Boolean)otherState.getValue(DUMMY) == !dummy) {
                return stateIn;
            }
            return (BlockState)stateIn.setValue(FACING, (Comparable)((Direction)otherState.getValue(FACING)));
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    public boolean canIEBlockBePlaced(BlockState newState, BlockPlaceContext context) {
        return EnergyMeterBlock.areAllReplaceable(context.getClickedPos(), context.getClickedPos().above(1), context);
    }
}

