/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.wires.IEWireTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FeedthroughBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IStateBasedDirectional {
    public static final String WIRE = "wire";
    private static final String OFFSET = "offset";
    public static final String MIDDLE_STATE = "middle";
    @Nonnull
    public WireType reference = WireType.COPPER;
    @Nonnull
    public BlockState stateForMiddle = Blocks.DIRT.defaultBlockState();
    public int offset = 0;
    public boolean currentlyDisassembling = false;
    private VoxelShape aabb;

    public FeedthroughBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.FEEDTHROUGH.get(), pos, state);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.writeCustomNBT(nbt, descPacket, provider);
        nbt.putString(WIRE, this.reference.getUniqueName());
        nbt.putInt(OFFSET, this.offset);
        CompoundTag stateNbt = NbtUtils.writeBlockState((BlockState)this.stateForMiddle);
        nbt.put(MIDDLE_STATE, (Tag)stateNbt);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.readCustomNBT(nbt, descPacket, provider);
        this.reference = WireType.getValue(nbt.getString(WIRE));
        this.offset = nbt.getInt(OFFSET);
        HolderLookup.RegistryLookup lookup = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
        this.stateForMiddle = NbtUtils.readBlockState((HolderGetter)lookup, (CompoundTag)nbt.getCompound(MIDDLE_STATE));
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        double l = WireApi.INFOS.get(this.reference).connOffset();
        int factor = here.equals(this.getPositivePoint()) ? 1 : -1;
        return new Vec3(0.5 + (0.5 + l) * (double)this.getFacing().getStepX() * (double)factor, 0.5 + (0.5 + l) * (double)this.getFacing().getStepY() * (double)factor, 0.5 + (0.5 + l) * (double)this.getFacing().getStepZ() * (double)factor);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        if (!WireApi.canMix(this.reference, cableType)) {
            return false;
        }
        Collection<Connection> existing = this.globalNet.getLocalNet(target).getConnections(target);
        for (Connection c : existing) {
            if (c.isInternal()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        return ImmutableSet.of((Object)this.worldPosition.relative(this.getFacing(), 1), (Object)this.worldPosition.relative(this.getFacing(), -1));
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        return this.worldPosition.relative(this.getFacing(), -this.offset);
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        WireApi.FeedthroughModelInfo info = WireApi.INFOS.get(this.reference);
        if (this.offset == 0) {
            Utils.getDrops(this.stateForMiddle, context, drop);
        } else {
            drop.accept(new ItemStack((ItemLike)info.connector().getBlock()));
        }
    }

    @Override
    public ItemStack getPickBlock(@Nullable Player player, BlockState state, HitResult rayRes) {
        if (this.offset == 0) {
            return Utils.getPickBlock(this.stateForMiddle, rayRes, player);
        }
        return IEBlockInterfaces.IBlockEntityDrop.super.getPickBlock(player, state, rayRes);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        ItemData data = (ItemData)stack.get(IEDataComponents.FEEDTHROUGH_DATA);
        if (data != null) {
            this.reference = data.type();
            this.stateForMiddle = data.middleState();
        }
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_LIKE;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        if (this.offset == 0) {
            return Shapes.block();
        }
        if (this.aabb == null) {
            this.aabb = EnergyConnectorBlockEntity.getConnectorBounds(this.offset < 0 ? this.getFacing() : this.getFacing().getOpposite(), (float)WireApi.INFOS.get(this.reference).connLength());
        }
        return this.aabb;
    }

    @Override
    public boolean triggerEvent(int id, int arg) {
        if (id == 253) {
            this.checkLight();
            return true;
        }
        return super.triggerEvent(id, arg);
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)this.getNegativePoint(), (Object)this.getPositivePoint());
    }

    public ConnectionPoint getNegativePoint() {
        return new ConnectionPoint(this.worldPosition, FeedthroughBlockEntity.getIndexForOffset(-1));
    }

    public ConnectionPoint getPositivePoint() {
        return new ConnectionPoint(this.worldPosition, FeedthroughBlockEntity.getIndexForOffset(1));
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        return ImmutableList.of((Object)new Connection(this.worldPosition, 0, 1));
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        if (offset.equals((Object)this.getFacing().getNormal())) {
            return this.getPositivePoint();
        }
        if (offset.equals((Object)this.getFacing().getOpposite().getNormal())) {
            return this.getNegativePoint();
        }
        return null;
    }

    public static int getIndexForOffset(int offset) {
        if (offset == -1) {
            return 1;
        }
        if (offset == 1) {
            return 0;
        }
        return -1;
    }

    public record ItemData(WireType type, BlockState middleState) {
        public static final DualCodec<ByteBuf, ItemData> CODECS = DualCompositeCodecs.composite((DualMapCodec)WireType.CODECS.fieldOf("type"), ItemData::type, (DualMapCodec)DualCodecs.BLOCK_STATE.fieldOf("middleState"), ItemData::middleState, ItemData::new);
        public static final ItemData FALLBACK = new ItemData(IEWireTypes.COPPER, Blocks.STONE.defaultBlockState());
    }

    public record FeedthroughData(BlockState baseState, WireType wire, Direction facing, int offset, int colorMultiplier) {
    }
}

