/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorType;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.client.render.conveyor.BasicConveyorRender;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;

public class DropConveyor
extends ConveyorBase {
    public static final ResourceLocation NAME = IEApi.ieLoc("dropper");
    public static ResourceLocation texture_on = IEApi.ieLoc("block/conveyor/dropper");
    public static ResourceLocation texture_off = IEApi.ieLoc("block/conveyor/dropper_off");
    public static final IConveyorType<DropConveyor> TYPE = new BasicConveyorType<DropConveyor>(NAME, false, true, DropConveyor::new, () -> new BasicConveyorRender(texture_on, texture_off));
    private static final VoxelShape REQUIRED_SPACE = Shapes.box((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75);
    private VoxelShape cachedDownShape = Shapes.empty();
    private boolean cachedOpenBelow = true;

    public DropConveyor(BlockEntity tile) {
        super(tile);
    }

    public IConveyorType<DropConveyor> getType() {
        return TYPE;
    }

    @Override
    public void handleInsertion(ItemEntity entity, ConveyorHandler.ConveyorDirection conDir, double distX, double distZ) {
        if (!this.isPowered()) {
            boolean contact;
            BlockPos posDown = this.getBlockEntity().getBlockPos().below();
            BlockEntity inventoryTile = this.getBlockEntity().getLevel().getBlockEntity(posDown);
            boolean bl = contact = Math.abs(this.getFacing().getAxis() == Direction.Axis.Z ? (double)this.getBlockEntity().getBlockPos().getZ() + 0.5 - entity.getZ() : (double)this.getBlockEntity().getBlockPos().getX() + 0.5 - entity.getX()) < 0.2;
            if (contact && !(inventoryTile instanceof ConveyorHandler.IConveyorBlockEntity)) {
                ItemUtils.tryInsertEntity(this.getBlockEntity().getLevel(), posDown, Direction.UP, entity);
            }
            if (entity.isAlive() && contact && this.isEmptySpace(this.getBlockEntity().getLevel(), posDown, inventoryTile)) {
                entity.setDeltaMovement(0.0, entity.getDeltaMovement().y, 0.0);
                entity.setPos((double)this.getBlockEntity().getBlockPos().getX() + 0.5, (double)this.getBlockEntity().getBlockPos().getY() - 0.5, (double)this.getBlockEntity().getBlockPos().getZ() + 0.5);
                if (!(inventoryTile instanceof ConveyorHandler.IConveyorBlockEntity)) {
                    ConveyorHandler.revertMagnetSuppression((Entity)entity, (ConveyorHandler.IConveyorBlockEntity)this.getBlockEntity());
                }
            } else {
                super.handleInsertion(entity, conDir, distX, distZ);
            }
        } else {
            super.handleInsertion(entity, conDir, distX, distZ);
        }
    }

    boolean isEmptySpace(Level world, BlockPos pos, BlockEntity tile) {
        if (tile instanceof ConveyorHandler.IConveyorBlockEntity) {
            return true;
        }
        if (world.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)Direction.UP) != null) {
            return false;
        }
        BlockState state = world.getBlockState(pos);
        VoxelShape shape = state.getCollisionShape((BlockGetter)world, pos);
        if (shape != this.cachedDownShape) {
            this.cachedOpenBelow = !Shapes.joinIsNotEmpty((VoxelShape)REQUIRED_SPACE, (VoxelShape)shape, (BooleanOp)BooleanOp.AND);
            this.cachedDownShape = shape;
        }
        return this.cachedOpenBelow;
    }
}

