/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.shapes;

import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AdvBlastFurnaceShapes
implements Function<BlockPos, VoxelShape> {
    public static final Function<BlockPos, VoxelShape> SHAPE_GETTER = new AdvBlastFurnaceShapes();

    private AdvBlastFurnaceShapes() {
    }

    @Override
    public VoxelShape apply(BlockPos posInMultiblock) {
        if (posInMultiblock.getX() == 1 && posInMultiblock.getZ() == 1 || Set.of(new BlockPos(1, 0, 0), new BlockPos(1, 1, 0), new BlockPos(1, 3, 1)).contains(posInMultiblock)) {
            return Shapes.block();
        }
        if (new BlockPos(1, 0, 2).equals((Object)posInMultiblock)) {
            return Shapes.box((double)0.1875, (double)0.0, (double)0.0, (double)0.8125, (double)0.8125, (double)1.0);
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        float indent = 1.0f;
        if (posInMultiblock.getY() == 0) {
            indent = posInMultiblock.getZ() == 1 ? 0.5f : 0.6875f;
        } else if (posInMultiblock.getY() == 1) {
            indent = 0.5f;
        } else if (posInMultiblock.getY() == 2) {
            indent = 0.625f;
        }
        if (posInMultiblock.getX() == 2) {
            xMax = 1.0f - indent;
        }
        if (posInMultiblock.getX() == 0) {
            xMin = indent;
        }
        if (posInMultiblock.getZ() == 2) {
            zMax = 1.0f - indent;
        }
        if (posInMultiblock.getZ() == 0) {
            zMin = indent;
        }
        return Shapes.box((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
    }
}

