/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.shapes;

import blusunrize.immersiveengineering.api.utils.shapes.ShapeUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrusherShapes
implements Function<BlockPos, VoxelShape> {
    public static final Function<BlockPos, VoxelShape> SHAPE_GETTER = new CrusherShapes();
    private static final Set<BlockPos> SLABS = ImmutableSet.of((Object)new BlockPos(3, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(0, 0, 2), (Object)new BlockPos(3, 0, 1), (Object)new BlockPos(1, 0, 1), (Object)new BlockPos(3, 0, 0), (Object[])new BlockPos[]{new BlockPos(2, 0, 0), new BlockPos(1, 0, 0), new BlockPos(0, 0, 0), new BlockPos(0, 1, 1)});

    private CrusherShapes() {
    }

    @Override
    public VoxelShape apply(BlockPos posInMultiblock) {
        if (posInMultiblock.getZ() == 1 && posInMultiblock.getX() == 2) {
            return CrusherShapes.getBasicShape(posInMultiblock);
        }
        if (new BlockPos(0, 0, 2).equals((Object)posInMultiblock)) {
            return Shapes.or((VoxelShape)Shapes.box((double)0.125, (double)0.5, (double)0.625, (double)0.25, (double)1.0, (double)0.875), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), Shapes.box((double)0.75, (double)0.5, (double)0.625, (double)0.875, (double)1.0, (double)0.875)});
        }
        if (new BoundingBox(1, 1, 1, 3, 2, 1).isInside((Vec3i)posInMultiblock)) {
            float maxX;
            VoxelShape result = Shapes.empty();
            float minY = 0.5f;
            float minX = posInMultiblock.getX() == 1 ? 0.4375f : 0.0f;
            float f = maxX = posInMultiblock.getX() == 3 ? 0.5625f : 1.0f;
            if (posInMultiblock.getY() == 1) {
                result = Shapes.or((VoxelShape)result, (VoxelShape)Shapes.box((double)minX, (double)0.5, (double)0.0, (double)maxX, (double)0.75, (double)1.0));
            } else {
                minY = 0.0f;
            }
            if (posInMultiblock.getX() == 1) {
                minX = 0.1875f;
            } else {
                float f2 = minX = posInMultiblock.getX() == 3 ? 0.5625f : 0.0f;
            }
            maxX = posInMultiblock.getX() == 3 ? 0.8125f : (posInMultiblock.getX() == 1 ? 0.4375f : 1.0f);
            return Shapes.or((VoxelShape)result, (VoxelShape)Shapes.box((double)minX, (double)minY, (double)0.0, (double)maxX, (double)1.0, (double)1.0));
        }
        if ((posInMultiblock.getZ() == 0 || posInMultiblock.getZ() == 2) && posInMultiblock.getY() > 0 && posInMultiblock.getX() > 0 && posInMultiblock.getX() < 4) {
            float maxZ;
            boolean front = posInMultiblock.getZ() == 0;
            boolean right = posInMultiblock.getX() == 1;
            boolean left = posInMultiblock.getX() == 3;
            VoxelShape result = Shapes.empty();
            float minY = 0.5f;
            float minX = right ? 0.4375f : 0.0f;
            float maxX = left ? 0.5625f : 1.0f;
            float minZ = front ? 0.4375f : 0.0f;
            float f = maxZ = !front ? 0.5625f : 1.0f;
            if (posInMultiblock.getY() == 1) {
                result = Shapes.or((VoxelShape)result, (VoxelShape)Shapes.box((double)minX, (double)0.5, (double)minZ, (double)maxX, (double)0.75, (double)maxZ));
            } else {
                minY = 0.0f;
            }
            minX = right ? 0.1875f : 0.0f;
            maxX = left ? 0.8125f : 1.0f;
            minZ = front ? 0.1875f : 0.5625f;
            maxZ = !front ? 0.8125f : 0.4375f;
            result = Shapes.or((VoxelShape)result, (VoxelShape)Shapes.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)1.0, (double)maxZ));
            if (!ImmutableSet.of((Object)new BlockPos(2, 1, 2), (Object)new BlockPos(2, 2, 2), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(2, 2, 0)).contains((Object)posInMultiblock)) {
                minX = right ? 0.1875f : 0.5625f;
                maxX = left ? 0.8125f : 0.4375f;
                minZ = front ? 0.4375f : 0.0f;
                maxZ = !front ? 0.5625f : 1.0f;
                result = Shapes.or((VoxelShape)result, (VoxelShape)Shapes.box((double)minX, (double)minY, (double)minZ, (double)maxX, (double)1.0, (double)maxZ));
                if (ImmutableSet.of((Object)new BlockPos(3, 1, 2), (Object)new BlockPos(2, 1, 2), (Object)new BlockPos(1, 1, 2), (Object)new BlockPos(3, 1, 0), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(1, 1, 0), (Object[])new BlockPos[0]).contains((Object)posInMultiblock)) {
                    minZ = front ? 0.25f : 0.5f;
                    maxZ = front ? 0.5f : 0.75f;
                    result = Shapes.or((VoxelShape)result, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)minZ, (double)0.75, (double)0.5, (double)maxZ));
                }
            }
            return result;
        }
        if (ImmutableSet.of((Object)new BlockPos(3, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(3, 0, 0), (Object)new BlockPos(1, 0, 0)).contains((Object)posInMultiblock)) {
            return ShapeUtils.join(Utils.flipBoxes(posInMultiblock.getZ() == 0, posInMultiblock.getX() == 3, new AABB(0.25, 0.5, 0.5, 0.5, 1.0, 0.75), new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)));
        }
        return CrusherShapes.getBasicShape(posInMultiblock);
    }

    public static VoxelShape getBasicShape(BlockPos posInMultiblock) {
        if (SLABS.contains(posInMultiblock)) {
            return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        }
        if (new BlockPos(2, 1, 1).equals((Object)posInMultiblock)) {
            return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0);
        }
        if (new BlockPos(2, 2, 1).equals((Object)posInMultiblock)) {
            return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        if (posInMultiblock.getY() > 0 && posInMultiblock.getX() > 0 && posInMultiblock.getX() < 4) {
            float minX = 0.0f;
            float maxX = 1.0f;
            float minZ = 0.0f;
            float maxZ = 1.0f;
            if (posInMultiblock.getX() == 3) {
                minX = 0.1875f;
            } else if (posInMultiblock.getX() == 1) {
                maxX = 0.8125f;
            }
            if (posInMultiblock.getZ() == 2) {
                maxZ = 0.8125f;
            }
            return Shapes.box((double)minX, (double)0.0, (double)minZ, (double)maxX, (double)1.0, (double)maxZ);
        }
        if (new BlockPos(0, 1, 2).equals((Object)posInMultiblock)) {
            return Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
        }
        return Shapes.block();
    }
}

