/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.api.crafting.cache.IListRecipe;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingCalculator;
import blusunrize.immersiveengineering.common.crafting.PotionRecipeGenerators;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Unit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class GeneratedListRecipe<R extends Recipe<?>, E>
extends IESerializableRecipe
implements IListRecipe {
    public static Map<ResourceLocation, RecipeListGenerator<?, ?>> LIST_GENERATORS = new HashMap();
    public static Supplier<IERecipeSerializer<GeneratedListRecipe<?, ?>>> SERIALIZER;
    @Nullable
    private List<Recipe<?>> cachedRecipes;
    private final RecipeListGenerator<R, E> generator;
    private E earlyResult;
    private final ResourceLocation generatorID;

    public static GeneratedListRecipe<?, ?> from(ResourceLocation id) {
        GeneratedListRecipe<?, ?> result = GeneratedListRecipe.fromInternal(id);
        result.initEarly();
        return result;
    }

    private static GeneratedListRecipe<?, ?> fromInternal(ResourceLocation id) {
        RecipeListGenerator<?, ?> gen = LIST_GENERATORS.get(id);
        Preconditions.checkNotNull(gen, (Object)id);
        return new GeneratedListRecipe(id, gen);
    }

    public static GeneratedListRecipe<?, ?> resolved(ResourceLocation id, List<Recipe<?>> recipes) {
        GeneratedListRecipe<?, ?> result = GeneratedListRecipe.fromInternal(id);
        result.cachedRecipes = recipes;
        return result;
    }

    private GeneratedListRecipe(ResourceLocation id, RecipeListGenerator<R, E> generator) {
        super(TagOutput.EMPTY, generator.recipeType);
        this.generator = generator;
        this.generatorID = id;
    }

    private void initEarly() {
        this.earlyResult = this.generator.makeEarlyResult().get();
    }

    protected IERecipeSerializer<GeneratedListRecipe<?, ?>> getIESerializer() {
        return SERIALIZER.get();
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider access) {
        return ItemStack.EMPTY;
    }

    @Override
    public boolean isSpecial() {
        return true;
    }

    @Override
    public List<Recipe<?>> getSubRecipes() {
        if (this.cachedRecipes == null) {
            this.cachedRecipes = List.copyOf((Collection)this.generator.generator().apply(this.earlyResult));
        }
        return this.cachedRecipes;
    }

    public ResourceLocation getGeneratorID() {
        return this.generatorID;
    }

    static {
        LIST_GENERATORS.put(ImmersiveEngineering.rl("mixer_potion_list"), RecipeListGenerator.simple(PotionRecipeGenerators::initPotionRecipes, MixerRecipe.SERIALIZER, IERecipeTypes.MIXER));
        LIST_GENERATORS.put(ImmersiveEngineering.rl("potion_bottling_list"), RecipeListGenerator.simple(PotionRecipeGenerators::getPotionBottlingRecipes, BottlingMachineRecipe.SERIALIZER, IERecipeTypes.BOTTLING_MACHINE));
        LIST_GENERATORS.put(ImmersiveEngineering.rl("arc_recycling_list"), RecipeListGenerator.fromSerializer(ArcRecyclingCalculator::makeFuture, recyclingList -> Objects.requireNonNull((List)recyclingList.getValue()), ArcFurnaceRecipe.SERIALIZER, IERecipeTypes.ARC_FURNACE));
    }

    public record RecipeListGenerator<T extends Recipe<?>, EarlyResult>(Supplier<EarlyResult> makeEarlyResult, Function<EarlyResult, List<? extends T>> generator, ResourceLocation serialized, IERecipeTypes.TypeWithClass<T> recipeType) {
        public static <T extends Recipe<?>, ER> RecipeListGenerator<T, ER> fromSerializer(Supplier<ER> makeEarlyResult, Function<ER, List<? extends T>> generator, Holder<? extends RecipeSerializer<?>> serialized, IERecipeTypes.TypeWithClass<T> recipeType) {
            ResourceLocation serializedKey = ((ResourceKey)serialized.unwrapKey().orElseThrow()).location();
            return new RecipeListGenerator<T, ER>(makeEarlyResult, generator, serializedKey, recipeType);
        }

        public static <R extends Recipe<?>> RecipeListGenerator<R, ?> simple(Supplier<List<? extends R>> generator, Holder<? extends RecipeSerializer<?>> serialized, IERecipeTypes.TypeWithClass<R> recipeType) {
            return RecipeListGenerator.fromSerializer(() -> Unit.INSTANCE, $ -> (List)generator.get(), serialized, recipeType);
        }
    }
}

