/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractFluidAwareRecipe;
import blusunrize.immersiveengineering.common.crafting.fluidaware.IngredientFluidStack;
import blusunrize.immersiveengineering.common.util.IELogger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

public interface IFluidAwareRecipe<MatchLocation extends AbstractFluidAwareRecipe.IMatchLocation>
extends CraftingRecipe {
    @Nonnull
    default public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingInput inv) {
        NonNullList remaining = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        MatchLocation offset = this.findMatch(inv);
        if (offset == null) {
            IELogger.logger.error("IRecipe#getRemainingItems was called with an inventory that does not match the recipe");
            IELogger.logger.error("according to IRecipe#matches. This is probably a bug in some mod in the following stacktrace,");
            IELogger.logger.error("if in doubt report it to Immersive Engineering", (Throwable)new IllegalArgumentException());
            return super.getRemainingItems((RecipeInput)inv);
        }
        for (int x = 0; x < inv.width(); ++x) {
            for (int y = 0; y < inv.height(); ++y) {
                int invIndex = this.getInventoryIndex(inv, x, y);
                int ingrIndex = offset.getListIndex(x, y);
                if (ingrIndex < 0 || ingrIndex >= this.getIngredients().size()) continue;
                Ingredient ingr = (Ingredient)this.getIngredients().get(ingrIndex);
                ItemStack item = inv.getItem(invIndex);
                ItemStack result = ItemStack.EMPTY;
                ICustomIngredient iCustomIngredient = ingr.getCustomIngredient();
                if (iCustomIngredient instanceof IngredientFluidStack) {
                    IngredientFluidStack fluidIngred = (IngredientFluidStack)iCustomIngredient;
                    result = fluidIngred.getExtractedStack(item.copy());
                } else if (item.hasCraftingRemainingItem()) {
                    result = item.getCraftingRemainingItem();
                }
                if (result == item) {
                    result = result.copy();
                }
                remaining.set(invIndex, (Object)result);
            }
        }
        return remaining;
    }

    @Nullable
    public MatchLocation findMatch(CraftingInput var1);

    default public boolean matches(@Nonnull CraftingInput inv, @Nonnull Level worldIn) {
        return this.findMatch(inv) != null;
    }

    @Nonnull
    default public ItemStack assemble(@Nonnull CraftingInput inv, HolderLookup.Provider access) {
        return this.getResultItem(access).copy();
    }

    private int getInventoryIndex(CraftingInput inv, int x, int y) {
        return x + y * inv.width();
    }
}

