/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.RefineryLogic;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class RefineryMenu
extends IEContainerMenu {
    public final IEnergyStorage energy;
    public final RefineryLogic.RefineryTanks tanks;

    public static RefineryMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, IEContainerMenu.MultiblockMenuContext<RefineryLogic.State> ctx) {
        RefineryLogic.State state = ctx.mbContext().getState();
        return new RefineryMenu(RefineryMenu.multiblockCtx(type, id, ctx), invPlayer, (IItemHandler)state.inventory, state.getEnergy(), state.tanks);
    }

    public static RefineryMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new RefineryMenu(RefineryMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(3), new MutableEnergyStorage(16000), new RefineryLogic.RefineryTanks());
    }

    public RefineryMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler inv, IMutableEnergyStorage energy, RefineryLogic.RefineryTanks tanks) {
        super(ctx);
        int i;
        this.energy = energy;
        this.tanks = tanks;
        this.addSlot((Slot)new SlotItemHandler(inv, this.ownSlotCount++, 73, 26));
        this.addSlot((Slot)new IESlot.NewFluidContainer(inv, this.ownSlotCount++, 133, 15, IESlot.NewFluidContainer.Filter.ANY));
        this.addSlot((Slot)new IESlot.NewOutput(inv, this.ownSlotCount++, 133, 54));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 85 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 143));
        }
        this.addGenericData(GenericContainerData.energy(energy));
        this.addGenericData(GenericContainerData.fluid(tanks.leftInput()));
        this.addGenericData(GenericContainerData.fluid(tanks.rightInput()));
        this.addGenericData(GenericContainerData.fluid(tanks.output()));
    }
}

