/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.common.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.DieselToolItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.items.IItemHandler;

@EventBusSubscriber(modid="immersiveengineering", bus=EventBusSubscriber.Bus.GAME)
public class DrillItem
extends DieselToolItem {
    public static final String TYPE = "DRILL";

    public DrillItem() {
        super(new Item.Properties().stacksTo(1).component(IEDataComponents.DRILL_SINGLEBLOCK, (Object)false), TYPE, 5);
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.WithPredicate(toolInventory, 0, 98, 22, itemStack -> itemStack.getItem() instanceof IDrillHead), new IESlot.Upgrades(container, toolInventory, 1, 78, 52, TYPE, stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 2, 98, 52, TYPE, stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 3, 118, 52, TYPE, stack, true, level, getPlayer)};
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (!(inv == null || inv.getStackInSlot(0).isEmpty() || inv.getStackInSlot(1).isEmpty() || inv.getStackInSlot(2).isEmpty() || inv.getStackInSlot(3).isEmpty())) {
            Utils.unlockIEAdvancement(player, "tools/upgrade_drill");
        }
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack, RegistryAccess registries) {
        super.finishUpgradeRecalculation(stack, registries);
        Holder.Reference fortune = (Holder.Reference)registries.registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.FORTUNE).orElseThrow();
        ItemEnchantments.Mutable newEnchantments = new ItemEnchantments.Mutable((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY));
        if (DrillItem.getUpgradesStatic(stack).has(UpgradeEffect.FORTUNE)) {
            newEnchantments.set((Holder)fortune, 3);
        } else {
            newEnchantments.removeIf(Predicate.isEqual(fortune));
        }
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)newEnchantments.toImmutable());
    }

    @Override
    public final ItemStack getHead(ItemStack drill) {
        return DrillItem.getHeadStatic(drill);
    }

    public static ItemStack getHeadStatic(ItemStack drill) {
        IItemHandler cap = (IItemHandler)drill.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap != null) {
            ItemStack head = cap.getStackInSlot(0);
            return !head.isEmpty() && head.getItem() instanceof IDrillHead ? head : ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setHead(ItemStack drill, ItemStack head) {
        DrillItem.setHeadStatic(drill, head);
    }

    public static void setHeadStatic(ItemStack drill, ItemStack head) {
        DrillItem.makeInternalItemHandler(drill).setStackInSlot(0, head);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        list.add(IEItemFluidHandler.fluidItemInfoFlavor(this.getFluid(stack), this.getCapacity(stack, 2000)));
        if (this.getHead(stack).isEmpty()) {
            list.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.flavour.drill.noHead"), ChatFormatting.GRAY));
        } else {
            int maxDmg = this.getMaxHeadDamage(stack);
            int dmg = maxDmg - this.getHeadDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            ChatFormatting status = (double)quote < 0.1 ? ChatFormatting.RED : ((double)quote < 0.3 ? ChatFormatting.GOLD : ((double)quote < 0.6 ? ChatFormatting.YELLOW : ChatFormatting.GREEN));
            list.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.flavour.drill.headDamage"), ChatFormatting.GRAY).append(" ").append((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.percent", (Object[])new Object[]{(int)(quote * 100.0f)}), status)));
        }
    }

    @Override
    protected double getAttackDamage(ItemStack stack, ItemStack head) {
        return ((IDrillHead)head.getItem()).getAttackDamage(head) + (float)this.getUpgrades(stack).get(UpgradeEffect.DAMAGE).intValue();
    }

    public static boolean isSingleBlockMode(ItemStack stack) {
        return (Boolean)stack.getOrDefault(IEDataComponents.DRILL_SINGLEBLOCK, (Object)false);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            boolean mode = !DrillItem.isSingleBlockMode(stack);
            stack.set(IEDataComponents.DRILL_SINGLEBLOCK, (Object)mode);
            player.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.drill_mode." + (mode ? "single" : "multi"))), true);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public boolean canToolBeUsed(ItemStack drill) {
        return this.getHeadDamage(drill) < this.getMaxHeadDamage(drill) && !this.getFluid(drill).isEmpty();
    }

    @SubscribeEvent
    public static void handleUnderwaterDrill(PlayerEvent.HarvestCheck ev) {
        ItemStack drill = ev.getEntity().getInventory().getSelected();
        Item item = drill.getItem();
        if (!(item instanceof DrillItem)) {
            return;
        }
        DrillItem drillItem = (DrillItem)item;
        if (ev.getEntity().isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) && !drillItem.getUpgrades(drill).has(UpgradeEffect.WATERPROOF)) {
            ev.setCanHarvest(false);
        }
    }

    @Override
    public int getMaxHeadDamage(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        return !head.isEmpty() ? ((IDrillHead)head.getItem()).getMaximumHeadDamage(head) : 0;
    }

    @Override
    public int getHeadDamage(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        return !head.isEmpty() ? ((IDrillHead)head.getItem()).getHeadDamage(head) : 0;
    }

    @Override
    protected void damageHead(ItemStack head, int amount, LivingEntity living) {
        ((IDrillHead)head.getItem()).damageHead(head, amount);
    }

    @Override
    public Holder<SoundEvent> getIdleSound(ItemStack stack) {
        return IESounds.drill_idle;
    }

    @Override
    public Holder<SoundEvent> getBusySound(ItemStack stack) {
        return IESounds.drill_busy;
    }

    @Override
    public Holder<SoundEvent> getFadingSound(ItemStack stack) {
        return IESounds.drill_fade;
    }

    @Override
    public Holder<SoundEvent> getAttackSound(ItemStack stack) {
        return IESounds.drill_attack;
    }

    @Override
    public Holder<SoundEvent> getHarvestSound(ItemStack stack) {
        return IESounds.drill_harvest;
    }

    @Override
    public boolean ableToMakeNoise(ItemStack stack) {
        return this.canToolBeUsed(stack);
    }

    @Override
    public boolean noisySameStack(ItemStack mainStack, ItemStack otherStack) {
        DrillItem drillItem;
        Item item = mainStack.getItem();
        return item instanceof DrillItem && (drillItem = (DrillItem)item).equals(otherStack.getItem());
    }

    @Override
    public Tier getHarvestLevel(ItemStack stack, @Nullable Player player) {
        ItemStack head = this.getHead(stack);
        if (!head.isEmpty() && this.canToolBeUsed(stack)) {
            return ((IDrillHead)head.getItem()).getMiningLevel(head);
        }
        return null;
    }

    @Override
    public boolean isEffective(ItemStack stack, BlockState state) {
        return state.is(IETags.drillHarvestable);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        ItemStack head = this.getHead(stack);
        if (!head.isEmpty() && this.canToolBeUsed(stack)) {
            return ((IDrillHead)head.getItem()).getMiningSpeed(head) + this.getUpgrades(stack).get(UpgradeEffect.SPEED).floatValue();
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean canBreakExtraBlock(Level world, BlockPos pos, BlockState state, Player player, ItemStack drill, ItemStack head) {
        if (!(state.canHarvestBlock((BlockGetter)world, pos, player) && this.isEffective(drill, state) && this.canToolBeUsed(drill))) {
            return false;
        }
        return !((IDrillHead)head.getItem()).beforeBlockbreak(drill, head, player);
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState centerState, BlockPos centerPos, LivingEntity entity) {
        if (world.isClientSide || !(entity instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)entity;
        this.onBlockMined(centerState, world, centerPos, stack, entity);
        if (player.isShiftKeyDown() || DrillItem.isSingleBlockMode(stack)) {
            return false;
        }
        BlockHitResult mop = DrillItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        ItemStack head = this.getHead(stack);
        if (mop == null || head.isEmpty() || !this.canToolBeUsed(stack)) {
            return false;
        }
        ImmutableList<BlockPos> additional = ((IDrillHead)head.getItem()).getExtraBlocksDug(head, world, (Player)player, (HitResult)mop);
        for (BlockPos pos : additional) {
            BlockEvent.BreakEvent event;
            if (!world.hasChunkAt(pos)) continue;
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            if (state.isAir() || state.getDestroyProgress((Player)player, (BlockGetter)world, pos) == 0.0f || !this.canBreakExtraBlock(world, pos, state, (Player)player, stack, head) || (event = CommonHooks.fireBlockBreak((Level)world, (GameType)player.gameMode.getGameModeForPlayer(), (ServerPlayer)player, (BlockPos)pos, (BlockState)state)).isCanceled()) continue;
            if (player.getAbilities().instabuild) {
                if (block.onDestroyedByPlayer(state, world, pos, (Player)player, false, state.getFluidState())) {
                    block.destroy((LevelAccessor)world, pos, state);
                }
            } else {
                BlockEntity te = world.getBlockEntity(pos);
                this.onBlockMined(state, world, pos, stack, entity);
                if (block.onDestroyedByPlayer(state, world, pos, (Player)player, true, state.getFluidState())) {
                    block.destroy((LevelAccessor)world, pos, state);
                    block.playerDestroy(world, (Player)player, pos, state, te, stack);
                }
            }
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
            player.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
        }
        return false;
    }

    private void onBlockMined(BlockState state, Level world, BlockPos pos, ItemStack stack, LivingEntity entity) {
        ItemStack head;
        if (state.getDestroySpeed((BlockGetter)world, pos) != 0.0f && !(head = this.getHead(stack)).isEmpty()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.getAbilities().instabuild) {
                    return;
                }
                ((IDrillHead)head.getItem()).afterBlockbreak(stack, head, player);
            }
            this.consumeDurability(stack, world, state, pos, entity);
        }
    }
}

