/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.fakeworld;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.util.fakeworld.EmptyLevelEntityGetter;
import blusunrize.immersiveengineering.common.util.fakeworld.EmptyTickAccess;
import blusunrize.immersiveengineering.common.util.fakeworld.FakeRegisteredHolder;
import blusunrize.immersiveengineering.common.util.fakeworld.FakeSpawnInfo;
import blusunrize.immersiveengineering.common.util.fakeworld.TemplateChunkProvider;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;

public class TemplateWorld
extends Level {
    private static final DimensionType DIMENSION_TYPE = new DimensionType(OptionalLong.empty(), false, false, false, false, 1.0, false, false, 0, 256, 256, BlockTags.INFINIBURN_OVERWORLD, ResourceLocation.withDefaultNamespace((String)"missingno"), 0.0f, new DimensionType.MonsterSettings(true, false, (IntProvider)ConstantInt.ZERO, 0));
    private static final ResourceLocation DIMENSION_TYPE_ID = ImmersiveEngineering.rl("multiblock_preview");
    private static final Holder<DimensionType> STRUCTURE_DIMENSION = new FakeRegisteredHolder<DimensionType>(DIMENSION_TYPE, ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)DIMENSION_TYPE_ID));
    private final Map<MapId, MapItemSavedData> maps = new HashMap<MapId, MapItemSavedData>();
    private final Scoreboard scoreboard = new Scoreboard();
    private final RecipeManager recipeManager;
    private final TemplateChunkProvider chunkProvider;
    private final TickRateManager tickRateManager = new TickRateManager();

    public static LevelReader createSingleBlock(BlockState stateAtZero, RegistryAccess regAccess) {
        return new TemplateWorld(List.of(new StructureTemplate.StructureBlockInfo(BlockPos.ZERO, stateAtZero, null)), bp -> true, regAccess);
    }

    public TemplateWorld(List<StructureTemplate.StructureBlockInfo> blocks, Predicate<BlockPos> shouldShow, RegistryAccess regAccess) {
        super((WritableLevelData)new FakeSpawnInfo(), Level.OVERWORLD, regAccess, STRUCTURE_DIMENSION, () -> InactiveProfiler.INSTANCE, true, false, 0L, 0);
        this.chunkProvider = new TemplateChunkProvider(blocks, this, shouldShow);
        this.recipeManager = new RecipeManager((HolderLookup.Provider)regAccess);
    }

    public void sendBlockUpdated(@Nonnull BlockPos pos, @Nonnull BlockState oldState, @Nonnull BlockState newState, int flags) {
    }

    public void playSeededSound(@Nullable Player p_262953_, double p_263004_, double p_263398_, double p_263376_, Holder<SoundEvent> p_263359_, SoundSource p_263020_, float p_263055_, float p_262914_, long p_262991_) {
    }

    public void playSeededSound(@Nullable Player p_220372_, Entity p_220373_, Holder<SoundEvent> p_263500_, SoundSource p_220375_, float p_220376_, float p_220377_, long p_220378_) {
    }

    @Nonnull
    public String gatherChunkSourceStats() {
        return "";
    }

    @Nullable
    public Entity getEntity(int id) {
        return null;
    }

    public TickRateManager tickRateManager() {
        return this.tickRateManager;
    }

    @Nullable
    public MapItemSavedData getMapData(MapId p_324234_) {
        return this.maps.get(p_324234_);
    }

    public void setMapData(MapId p_324009_, MapItemSavedData p_151534_) {
        this.maps.put(p_324009_, p_151534_);
    }

    public MapId getFreeMapId() {
        int i = 0;
        while (this.maps.containsKey(new MapId(i))) {
            ++i;
        }
        return new MapId(i);
    }

    public void destroyBlockProgress(int breakerId, @Nonnull BlockPos pos, int progress) {
    }

    @Nonnull
    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    @Nonnull
    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    @Nonnull
    protected LevelEntityGetter<Entity> getEntities() {
        return new EmptyLevelEntityGetter<Entity>();
    }

    @Nonnull
    public LevelTickAccess<Block> getBlockTicks() {
        return new EmptyTickAccess<Block>();
    }

    @Nonnull
    public LevelTickAccess<Fluid> getFluidTicks() {
        return new EmptyTickAccess<Fluid>();
    }

    @Nonnull
    public ChunkSource getChunkSource() {
        return this.chunkProvider;
    }

    public void levelEvent(@Nullable Player player, int type, @Nonnull BlockPos pos, int data) {
    }

    public void gameEvent(Holder<GameEvent> p_316267_, Vec3 p_220405_, GameEvent.Context p_220406_) {
    }

    @Nonnull
    public RegistryAccess registryAccess() {
        Level clientWorld = ImmersiveEngineering.proxy.getClientWorld();
        return Objects.requireNonNull(clientWorld).registryAccess();
    }

    public PotionBrewing potionBrewing() {
        return null;
    }

    public void setDayTimeFraction(float dayTimeFraction) {
    }

    public float getDayTimeFraction() {
        return 1.0f;
    }

    public float getDayTimePerTick() {
        return 1.0f;
    }

    public void setDayTimePerTick(float dayTimePerTick) {
    }

    public FeatureFlagSet enabledFeatures() {
        return ImmersiveEngineering.proxy.getClientWorld().enabledFeatures();
    }

    public float getShade(@Nonnull Direction p_230487_1_, boolean p_230487_2_) {
        return 1.0f;
    }

    @Nonnull
    public List<? extends Player> players() {
        return ImmutableList.of();
    }

    @Nonnull
    public Holder<Biome> getUncachedNoiseBiome(int x, int y, int z) {
        return Holder.direct((Object)((Biome)this.registryAccess().registryOrThrow(Registries.BIOME).getOrThrow(Biomes.PLAINS)));
    }

    public int getBrightness(@Nonnull LightLayer lightType, @Nonnull BlockPos pos) {
        return 15;
    }
}

