/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.sound;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;

public class SkyhookSound
implements TickableSoundInstance {
    private final SkylineHookEntity hook;
    private final ResourceLocation soundLoc;
    private Sound sound;
    private float speed = 0.01f;

    public SkyhookSound(SkylineHookEntity hook, ResourceLocation soundLoc) {
        this.hook = hook;
        this.soundLoc = soundLoc;
    }

    public boolean isStopped() {
        return !this.hook.isAlive();
    }

    @Nonnull
    public ResourceLocation getLocation() {
        return this.soundLoc;
    }

    @Nullable
    public WeighedSoundEvents resolve(@Nonnull SoundManager handler) {
        WeighedSoundEvents soundEvent = handler.getSoundEvent(this.soundLoc);
        this.sound = soundEvent == null ? SoundManager.EMPTY_SOUND : soundEvent.getSound(ApiUtils.RANDOM_SOURCE);
        return soundEvent;
    }

    @Nonnull
    public Sound getSound() {
        return this.sound;
    }

    @Nonnull
    public SoundSource getSource() {
        return SoundSource.NEUTRAL;
    }

    public boolean isLooping() {
        return true;
    }

    public int getDelay() {
        return 0;
    }

    public float getVolume() {
        return Math.min(this.speed, 0.75f);
    }

    public float getPitch() {
        return Math.min(0.5f * this.speed, 0.75f);
    }

    public double getX() {
        return (float)this.hook.getX();
    }

    public double getY() {
        return (float)this.hook.getY();
    }

    public double getZ() {
        return (float)this.hook.getZ();
    }

    @Nonnull
    public SoundInstance.Attenuation getAttenuation() {
        return SoundInstance.Attenuation.LINEAR;
    }

    public void tick() {
        this.speed = (float)this.hook.getSpeed();
        if ((double)this.speed < 0.01) {
            this.speed = 0.01f;
        }
    }

    public boolean isRelative() {
        return false;
    }
}

