/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.network;

import com.google.common.base.Preconditions;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.NetworkRegistry;

public class PayloadHelper {
    private static final Map<CustomPacketPayload.Type<?>, PayloadProvider<?>> ALL_PROVIDERS = new HashMap();
    private static boolean locked = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CustomPacketPayload> void registerPayload(PayloadProvider<T> prov) {
        Preconditions.checkNotNull(prov);
        Map<CustomPacketPayload.Type<?>, PayloadProvider<?>> map = ALL_PROVIDERS;
        synchronized (map) {
            if (locked) {
                throw new UnsupportedOperationException("Attempted to register a payload provider after registration has finished.");
            }
            if (ALL_PROVIDERS.containsKey(prov.getType())) {
                throw new UnsupportedOperationException("Attempted to register payload provider with duplicate ID: " + String.valueOf(prov.getType().id()));
            }
            ALL_PROVIDERS.put(prov.getType(), prov);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void registerProviders(RegisterPayloadHandlersEvent event) {
        Map<CustomPacketPayload.Type<?>, PayloadProvider<?>> map = ALL_PROVIDERS;
        synchronized (map) {
            for (PayloadProvider<?> prov : ALL_PROVIDERS.values()) {
                NetworkRegistry.register(prov.getType(), prov.getCodec(), new PayloadHandler(prov), prov.getSupportedProtocols(), prov.getFlow(), (String)prov.getVersion(), (boolean)prov.isOptional());
            }
            locked = true;
        }
    }

    private static class PayloadHandler<T extends CustomPacketPayload>
    implements IPayloadHandler<T> {
        private PayloadProvider<T> provider;
        private Optional<PacketFlow> flow;
        private List<ConnectionProtocol> protocols;

        private PayloadHandler(PayloadProvider<T> provider) {
            this.provider = provider;
            this.flow = provider.getFlow();
            this.protocols = provider.getSupportedProtocols();
            Preconditions.checkArgument((!this.protocols.isEmpty() ? 1 : 0) != 0, (Object)("The payload registration for " + String.valueOf(provider.getType().id()) + " must specify at least one valid protocol."));
        }

        public void handle(T payload, IPayloadContext context) {
            if (this.flow.isPresent() && this.flow.get() != context.flow()) {
                Placebo.LOGGER.error("Received a payload {} on the incorrect side.", (Object)payload.type().id());
                return;
            }
            if (!this.protocols.contains(context.protocol())) {
                Placebo.LOGGER.error("Received a payload {} on the incorrect protocol.", (Object)payload.type().id());
                return;
            }
            switch (this.provider.getHandlerThread()) {
                case MAIN: {
                    context.enqueueWork(() -> this.provider.handle((CustomPacketPayload)payload, context));
                    break;
                }
                case NETWORK: {
                    this.provider.handle(payload, context);
                }
            }
        }
    }
}

