/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.MultiImage;
import net.tejty.gamediscs.games.graphics.Renderer;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.Sprite;
import net.tejty.gamediscs.games.util.VecUtil;

public class PongGame
extends Game {
    private Sprite player = new Sprite(new Vec2(10.0f, 40.0f), new Vec2(5.0f, 20.0f), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/white_concrete.png"));
    private Sprite oponent = new Sprite(new Vec2(125.0f, 40.0f), new Vec2(5.0f, 20.0f), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/white_concrete.png"));
    private Sprite ball = new Sprite(new Vec2(68.0f, 48.0f), new Vec2(4.0f, 4.0f), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/white_concrete.png"));
    private Sprite numberRenderer = new Sprite(new Vec2(0.0f, 0.0f), new Vec2(8.0f, 12.0f), new MultiImage(ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/games/sprite/numbers.png"), 8, 120, 10));
    private static final int SPEED = 3;
    private int oponentScore = 0;
    private int ballTimer;
    private float ballSpeed = 3.0f;

    @Override
    public void prepare() {
        super.prepare();
        this.player = new Sprite(new Vec2(10.0f, 40.0f), new Vec2(5.0f, 20.0f), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/white_concrete.png"));
        this.oponent = new Sprite(new Vec2(125.0f, 40.0f), new Vec2(5.0f, 20.0f), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/white_concrete.png"));
        this.ballSpeed = 4.0f;
        this.ball = new Sprite(new Vec2(68.0f, 48.0f), new Vec2(4.0f, 4.0f), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/white_concrete.png")).setVelocity(new Vec2((float)((this.random.nextInt(2) * 2 - 1) * 2), (float)((this.random.nextInt(2) * 2 - 1) * 2)));
        this.oponentScore = 0;
    }

    public void resetBall() {
        this.ballSpeed = 4.0f;
        this.ball.setPos(new Vec2(68.0f, 48.0f));
        this.ball.setVelocity(new Vec2((float)(this.random.nextInt(2) * 2 - 1), (float)(this.random.nextInt(2) * 2 - 1)).normalized().scale(this.ballSpeed));
        this.ballTimer = 60;
    }

    @Override
    public void start() {
        super.start();
        this.ballTimer = 60;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ballTimer > 0) {
            --this.ballTimer;
        }
    }

    @Override
    public void gameTick() {
        super.gameTick();
        if (this.ticks % 20 == 0) {
            this.ballSpeed += 0.1f;
        }
        if (this.controls.isButtonDown(Button.UP)) {
            this.player.moveBy(VecUtil.VEC_UP.scale(3.0f));
        }
        if (this.controls.isButtonDown(Button.DOWN)) {
            this.player.moveBy(VecUtil.VEC_DOWN.scale(3.0f));
        }
        if (this.ball.getCenterPos().y < this.oponent.getCenterPos().y) {
            this.oponent.moveBy(VecUtil.VEC_UP.scale(3.0f));
        }
        if (this.ball.getCenterPos().y > this.oponent.getCenterPos().y) {
            this.oponent.moveBy(VecUtil.VEC_DOWN.scale(3.0f));
        }
        this.player.setY(Math.min(Math.max(this.player.getY(), 0.0f), 100.0f - this.player.getHeight()));
        this.oponent.setY(Math.min(Math.max(this.oponent.getY(), 0.0f), 100.0f - this.oponent.getHeight()));
        if (this.ballTimer <= 0) {
            this.ball.moveBy(new Vec2(this.ball.getVelocity().x, 0.0f));
            if (this.ball.getX() < 0.0f) {
                ++this.oponentScore;
                this.resetBall();
            }
            if (this.ball.getX() + this.ball.getWidth() > 140.0f) {
                ++this.score;
                this.soundPlayer.playPoint();
                this.resetBall();
            }
            if (this.ballTimer <= 0) {
                this.ball.moveBy(new Vec2(0.0f, this.ball.getVelocity().y));
                if (this.ball.getY() < 0.0f || this.ball.getY() + this.ball.getHeight() > 100.0f) {
                    this.ball.moveBy(new Vec2(0.0f, -this.ball.getVelocity().y));
                    this.ball.setVelocity(new Vec2(this.ball.getVelocity().x, -this.ball.getVelocity().y));
                    this.soundPlayer.playJump();
                }
                if (this.ball.isTouching(this.player)) {
                    this.ball.setVelocity(this.ball.getCenterPos().add(this.player.getCenterPos().add(new Vec2(-2.0f, 0.0f)).negated()).normalized().scale(this.ballSpeed));
                    this.soundPlayer.playJump();
                }
                if (this.ball.isTouching(this.oponent)) {
                    this.ball.setVelocity(this.ball.getCenterPos().add(this.oponent.getCenterPos().add(new Vec2(2.0f, 0.0f)).negated()).normalized().scale(this.ballSpeed));
                    this.soundPlayer.playJump();
                }
            }
        }
        if (this.score >= 10) {
            this.win();
        }
        if (this.oponentScore >= 10) {
            this.die();
        }
    }

    @Override
    public void die() {
        super.die();
    }

    @Override
    public void render(GuiGraphics graphics, int posX, int posY) {
        MultiImage image;
        Renderer renderer;
        super.render(graphics, posX, posY);
        this.player.render(graphics, posX, posY);
        this.oponent.render(graphics, posX, posY);
        this.ball.render(graphics, posX, posY);
        this.renderParticles(graphics, posX, posY);
        if (this.score < 10) {
            renderer = this.numberRenderer.getImage();
            if (renderer instanceof MultiImage) {
                image = (MultiImage)renderer;
                image.setImage(this.score);
            }
            this.numberRenderer.setPos(new Vec2(70.0f - this.numberRenderer.getWidth() - 4.0f, 4.0f));
            this.numberRenderer.render(graphics, posX, posY);
        } else {
            renderer = this.numberRenderer.getImage();
            if (renderer instanceof MultiImage) {
                image = (MultiImage)renderer;
                image.setImage(1);
            }
            this.numberRenderer.setPos(new Vec2(70.0f - this.numberRenderer.getWidth() * 2.0f - 8.0f, 4.0f));
            this.numberRenderer.render(graphics, posX, posY);
            renderer = this.numberRenderer.getImage();
            if (renderer instanceof MultiImage) {
                image = (MultiImage)renderer;
                image.setImage(0);
            }
            this.numberRenderer.setPos(new Vec2(70.0f - this.numberRenderer.getWidth() - 4.0f, 4.0f));
            this.numberRenderer.render(graphics, posX, posY);
        }
        if (this.oponentScore < 10) {
            renderer = this.numberRenderer.getImage();
            if (renderer instanceof MultiImage) {
                image = (MultiImage)renderer;
                image.setImage(this.oponentScore);
            }
            this.numberRenderer.setPos(new Vec2(74.0f, 4.0f));
            this.numberRenderer.render(graphics, posX, posY);
        } else {
            renderer = this.numberRenderer.getImage();
            if (renderer instanceof MultiImage) {
                image = (MultiImage)renderer;
                image.setImage(1);
            }
            this.numberRenderer.setPos(new Vec2(74.0f, 4.0f));
            this.numberRenderer.render(graphics, posX, posY);
            renderer = this.numberRenderer.getImage();
            if (renderer instanceof MultiImage) {
                image = (MultiImage)renderer;
                image.setImage(0);
            }
            this.numberRenderer.setPos(new Vec2(70.0f + this.numberRenderer.getWidth() + 8.0f, 4.0f));
            this.numberRenderer.render(graphics, posX, posY);
        }
        this.renderOverlay(graphics, posX, posY);
    }

    @Override
    public void buttonDown(Button button) {
        super.buttonDown(button);
    }

    @Override
    public ResourceLocation getBackground() {
        return ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/games/background/pong_background.png");
    }

    @Override
    public boolean showScore() {
        return false;
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"gamediscs.pong");
    }

    @Override
    public ResourceLocation getIcon() {
        return ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/item/game_disc_pong_no_anim.png");
    }
}

