/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.gamediscs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.graphics.Image;
import net.tejty.gamediscs.games.graphics.MultiImage;
import net.tejty.gamediscs.games.util.Game;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.Grid;
import net.tejty.gamediscs.games.util.ParticleLevel;
import net.tejty.gamediscs.games.util.Sprite;
import net.tejty.gamediscs.games.util.VecUtil;

public class TntSweeperGame
extends Game {
    private final MultiImage TILE = new MultiImage(ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/games/sprite/tnt_sweeper.png"), 6, 84, 14);
    private static final ResourceLocation SELECT = ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/games/sprite/select.png");
    private static final Vec2 GAME_POS = new Vec2(1.0f, 9.0f);
    private static final int TILE_SIZE = 6;
    private static final int GAME_WIDTH = 23;
    private static final int GAME_HEIGHT = 15;
    private static final int TNT_COUNT = 70;
    private int flags;
    private List<Vec2> bombs = new ArrayList<Vec2>();
    private Grid grid = new Grid(23, 15, 6, this.TILE);
    private static final int NOTHING = 0;
    private static final int FLAG = 1;
    private static final int EMPTY = 2;
    private static final int ONE = 3;
    private static final int TWO = 4;
    private static final int THREE = 5;
    private static final int FOUR = 6;
    private static final int FIVE = 7;
    private static final int SIX = 8;
    private static final int SEVEN = 9;
    private static final int EIGHT = 10;
    private static final int TNT = 11;
    private static final int BLOWN_TNT = 12;
    private static final int WRONG_FLAG = 13;
    private Vec2 selectionPos = VecUtil.round(new Vec2(22.0f, 14.0f).scale(0.5f));
    private Sprite selection = new Sprite(this.calcPos(this.selectionPos).add(VecUtil.of(-1.0f)), VecUtil.of(8.0f), new Image(SELECT, 8, 8));

    private boolean isTntOn(Vec2 pos) {
        for (Vec2 bomb : this.bombs) {
            if (!VecUtil.is(bomb, pos)) continue;
            return true;
        }
        return false;
    }

    private int calculateBombsAround(Vec2 pos) {
        int count = 0;
        for (Vec2 rel : VecUtil.RELATIVES) {
            if (!this.isTntOn(pos.add(rel))) continue;
            ++count;
        }
        return count;
    }

    private static int numberTile(int number) {
        return number + 2;
    }

    @Override
    public void prepare() {
        super.prepare();
        this.grid = new Grid(23, 15, 6, this.TILE);
        this.bombs = new ArrayList<Vec2>();
        this.flags = 70;
    }

    @Override
    public void start() {
        super.start();
        for (int i = 0; i < 70; ++i) {
            Vec2 pos = null;
            while (pos == null || this.isTntOn(pos) || !(Math.sqrt(pos.distanceToSqr(this.selectionPos)) > 2.0)) {
                pos = VecUtil.randomInt(Vec2.ZERO, new Vec2(23.0f, 15.0f), this.random);
            }
            this.bombs.add(pos);
        }
    }

    @Override
    public void gameTick() {
        super.gameTick();
    }

    @Override
    public void tick() {
        super.tick();
        if ((this.stage == GameStage.PLAYING || this.stage == GameStage.START) && this.ticks % 2 == 0) {
            if (this.controls.isButtonDown(Button.UP) && this.controls.wasButtonDown(Button.UP)) {
                this.selectionPos = this.selectionPos.add(VecUtil.VEC_UP);
            }
            if (this.controls.isButtonDown(Button.DOWN) && this.controls.wasButtonDown(Button.DOWN)) {
                this.selectionPos = this.selectionPos.add(VecUtil.VEC_DOWN);
            }
            if (this.controls.isButtonDown(Button.LEFT) && this.controls.wasButtonDown(Button.LEFT)) {
                this.selectionPos = this.selectionPos.add(VecUtil.VEC_LEFT);
            }
            if (this.controls.isButtonDown(Button.RIGHT) && this.controls.wasButtonDown(Button.RIGHT)) {
                this.selectionPos = this.selectionPos.add(VecUtil.VEC_RIGHT);
            }
            this.selectionPos = new Vec2(Math.min(Math.max(this.selectionPos.x, 0.0f), 22.0f), Math.min(Math.max(this.selectionPos.y, 0.0f), 14.0f));
            this.selection.setPos(this.calcPos(this.selectionPos).add(VecUtil.of(-1.0f)));
        }
    }

    @Override
    public void render(GuiGraphics graphics, int posX, int posY) {
        super.render(graphics, posX, posY);
        this.grid.render(graphics, posX + (int)TntSweeperGame.GAME_POS.x, posY + (int)TntSweeperGame.GAME_POS.y);
        this.selection.render(graphics, posX, posY);
        this.renderParticles(graphics, posX, posY);
        this.renderOverlay(graphics, posX, posY);
        Font font = Minecraft.getInstance().font;
        String text = String.valueOf(this.flags);
        graphics.drawString(font, text, posX + 2, posY + 2, 0x373737, false);
        graphics.drawString(font, text, posX + 1, posY + 1, 0xFFFFFF, false);
        if (this.stage == GameStage.PLAYING) {
            text = String.valueOf(this.ticks / 20);
            graphics.drawString(font, text, posX + 140 - font.width(text) - 1, posY + 2, 0x373737, false);
            graphics.drawString(font, text, posX + 140 - font.width(text) - 2, posY + 1, 0xFFFFFF, false);
        }
    }

    private Vec2 calcTile(Vec2 pos) {
        return pos.add(GAME_POS.negated()).scale(0.16666667f);
    }

    private Vec2 calcPos(Vec2 tile) {
        return tile.scale(6.0f).add(GAME_POS);
    }

    @Override
    public void buttonDown(Button button) {
        this.soundPlayer.playClick(true);
        if (this.stage == GameStage.PLAYING || this.stage == GameStage.START) {
            if (button == Button.UP) {
                this.selectionPos = this.selectionPos.add(VecUtil.VEC_UP);
            }
            if (button == Button.DOWN) {
                this.selectionPos = this.selectionPos.add(VecUtil.VEC_DOWN);
            }
            if (button == Button.LEFT) {
                this.selectionPos = this.selectionPos.add(VecUtil.VEC_LEFT);
            }
            if (button == Button.RIGHT) {
                this.selectionPos = this.selectionPos.add(VecUtil.VEC_RIGHT);
            }
            this.selectionPos = new Vec2(Math.min(Math.max(this.selectionPos.x, 0.0f), 22.0f), Math.min(Math.max(this.selectionPos.y, 0.0f), 14.0f));
            this.selection.setPos(this.calcPos(this.selectionPos).add(VecUtil.of(-1.0f)));
            if (button == Button.BUTTON2) {
                if (this.grid.get(this.selectionPos) == 0 && this.flags > 0) {
                    this.grid.set(this.selectionPos, 1);
                    --this.flags;
                    this.checkForWin();
                    this.soundPlayer.play(SoundEvents.WOOL_PLACE);
                } else if (this.grid.get(this.selectionPos) == 1) {
                    this.grid.set(this.selectionPos, 0);
                    ++this.flags;
                    this.soundPlayer.play(SoundEvents.WOOL_BREAK);
                }
            }
        }
        if (this.stage == GameStage.START && button == Button.BUTTON1) {
            this.start();
        }
        if ((this.stage == GameStage.WON || this.stage == GameStage.DIED) && this.ticks > 8) {
            this.prepare();
        }
        if (this.stage == GameStage.PLAYING && button == Button.BUTTON1) {
            this.dig(this.selectionPos);
        }
    }

    private void dig(Vec2 pos) {
        if (this.grid.isIn(pos) && this.grid.get((int)pos.x, (int)pos.y) == 0) {
            if (this.isTntOn(pos)) {
                this.die();
            } else {
                ++this.score;
                this.grid.set((int)pos.x, (int)pos.y, TntSweeperGame.numberTile(this.calculateBombsAround(pos)));
                if (this.grid.get((int)pos.x, (int)pos.y) == 2) {
                    for (Vec2 rel : VecUtil.RELATIVES) {
                        this.dig(pos.add(rel));
                    }
                }
                this.soundPlayer.play(SoundEvents.DEEPSLATE_BRICKS_BREAK);
                this.checkForWin();
            }
        }
    }

    private void checkForWin() {
        if (this.flags == 0 && this.score == 275) {
            this.win();
        }
    }

    @Override
    public void die() {
        super.die();
        for (Vec2 bomb : this.bombs) {
            this.grid.set(bomb, 11);
            this.spawnParticleExplosion(this.calcPos(bomb), 10, 2, 20, ParticleLevel.GAME);
        }
        this.grid.set(this.selectionPos, 12);
    }

    @Override
    public boolean showScore() {
        return false;
    }

    @Override
    public boolean showPressAnyKey() {
        return false;
    }

    @Override
    public ResourceLocation getBackground() {
        return ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/games/background/tnt_sweeper_background.png");
    }

    @Override
    public Component getName() {
        return Component.translatable((String)"gamediscs.tnt_sweeper");
    }

    @Override
    public ResourceLocation getIcon() {
        return ResourceLocation.fromNamespaceAndPath((String)"gamediscs", (String)"textures/item/game_disc_tnt_sweeper.png");
    }
}

