/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.util;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.graphics.BasicParticleRenderer;
import net.tejty.gamediscs.games.graphics.BreakParticleRenderer;
import net.tejty.gamediscs.games.graphics.ParticleColor;
import net.tejty.gamediscs.games.graphics.ParticleRenderer;
import net.tejty.gamediscs.games.graphics.Renderer;
import net.tejty.gamediscs.games.util.GameStage;
import net.tejty.gamediscs.games.util.ParticleLevel;

public class Particle {
    private int lifetime;
    public ParticleLevel level;
    private Vec2 pos = Vec2.ZERO;
    private Vec2 vel = Vec2.ZERO;
    private Renderer image = new Renderer();

    public Particle(Vec2 pos, ParticleColor color, int lifetime, ParticleLevel level) {
        this.pos = pos;
        this.image = new BasicParticleRenderer(color);
        this.lifetime = lifetime;
        this.level = level;
    }

    public Particle(Vec2 pos, Renderer image, int lifetime, ParticleLevel level) {
        this.pos = pos;
        this.image = image;
        this.lifetime = lifetime;
        this.level = level;
    }

    public Particle(Vec2 pos, ResourceLocation file, int fileWidth, int fileHeight, int lifetime, ParticleLevel level) {
        this.pos = pos;
        this.lifetime = lifetime;
        this.level = level;
        this.image = new BreakParticleRenderer(file, fileWidth, fileHeight);
    }

    public Particle(Vec2 pos, ResourceLocation file, int fileWidth, int fileHeight, int posX, int posY, int width, int height, int lifetime, ParticleLevel level) {
        this.pos = pos;
        this.lifetime = lifetime;
        this.level = level;
        this.image = new ParticleRenderer(file, fileWidth, fileHeight, posX, posY, width, height);
    }

    public Vec2 getPos() {
        return this.pos;
    }

    public float getX() {
        return this.pos.x;
    }

    public float getY() {
        return this.pos.y;
    }

    public void setPos(Vec2 pos) {
        this.pos = pos;
    }

    public void moveBy(Vec2 offset) {
        this.pos = this.pos.add(offset);
    }

    public Vec2 getVelocity() {
        return this.vel;
    }

    public void setVelocity(Vec2 vel) {
        this.vel = vel;
    }

    public void addVelocity(Vec2 vel) {
        this.vel = this.vel.add(vel);
    }

    public void tick() {
        this.pos = this.pos.add(this.vel);
        --this.lifetime;
    }

    public void render(GuiGraphics graphics, int gameX, int gameY, GameStage stage) {
        if (this.level.isFor(stage)) {
            this.image.render(graphics, gameX + (int)this.pos.x, gameY + (int)this.pos.y);
        }
    }

    public boolean isForOverlay() {
        return this.level == ParticleLevel.OVERLAY;
    }

    public boolean isDead() {
        return this.lifetime <= 0;
    }
}

