/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.util;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.tejty.gamediscs.games.graphics.AnimatedImage;
import net.tejty.gamediscs.games.graphics.Image;
import net.tejty.gamediscs.games.graphics.Renderer;

public class Sprite {
    private Vec2 pos = Vec2.ZERO;
    private Vec2 size = Vec2.ZERO;
    private Vec2 vel = Vec2.ZERO;
    private Renderer image = new Renderer();
    private boolean shown = true;

    public Sprite(Vec2 pos, Vec2 size, Renderer image) {
        this.pos = pos;
        this.size = size;
        this.image = image;
    }

    public Sprite(Vec2 pos, Vec2 size, ResourceLocation image) {
        this.pos = pos;
        this.size = size;
        this.image = new Image(image, (int)size.x, (int)size.y);
    }

    public Vec2 getPos() {
        return this.pos;
    }

    public float getX() {
        return this.pos.x;
    }

    public float getY() {
        return this.pos.y;
    }

    public Vec2 getCenterPos() {
        return this.pos.add(this.size.scale(0.5f));
    }

    public void setPos(Vec2 pos) {
        this.pos = pos;
    }

    public void setX(float x) {
        this.pos = new Vec2(x, this.getY());
    }

    public void setY(float y) {
        this.pos = new Vec2(this.getX(), y);
    }

    public void moveBy(Vec2 offset) {
        this.pos = this.pos.add(offset);
    }

    public Vec2 getSize() {
        return this.size;
    }

    public float getWidth() {
        return this.size.x;
    }

    public float getHeight() {
        return this.size.y;
    }

    public void setSize(Vec2 size) {
        this.size = size;
    }

    public Vec2 getVelocity() {
        return this.vel;
    }

    public Sprite setVelocity(Vec2 vel) {
        this.vel = vel;
        return this;
    }

    public Sprite addVelocity(Vec2 vel) {
        this.vel = this.vel.add(vel);
        return this;
    }

    public Renderer getImage() {
        return this.image;
    }

    public void setImage(Renderer image) {
        this.image = image;
    }

    public void setImage(ResourceLocation image) {
        this.image = new Image(image, (int)this.size.x, (int)this.size.y);
    }

    public void show() {
        this.shown = true;
    }

    public void hide() {
        this.shown = false;
    }

    public void tick() {
        this.pos = this.pos.add(this.vel);
    }

    public void animTick() {
        Renderer renderer = this.image;
        if (renderer instanceof AnimatedImage) {
            AnimatedImage animation = (AnimatedImage)renderer;
            animation.tick();
        }
    }

    public boolean isTouching(Sprite other) {
        return this.getX() < other.getX() + other.getWidth() && this.getX() + this.getWidth() > other.getX() && this.getY() < other.getY() + other.getHeight() && this.getY() + this.getHeight() > other.getY();
    }

    public void render(GuiGraphics graphics, int gameX, int gameY) {
        if (this.shown) {
            this.image.render(graphics, gameX + (int)this.pos.x, gameY + (int)this.pos.y);
        }
    }
}

