/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.util.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ItemTagModifier
extends LootModifier {
    public static final MapCodec<ItemTagModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> ItemTagModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(m -> m.tag)).apply((Applicative)inst, ItemTagModifier::new));
    private final TagKey<Item> tag;

    public ItemTagModifier(LootItemCondition[] conditionsIn, TagKey<Item> itemTag) {
        super(conditionsIn);
        this.tag = itemTag;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        LootTable lootTable = LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)TagEntry.expandTag(this.tag))).build();
        lootTable.getRandomItems(context, arg_0 -> generatedLoot.add(arg_0));
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

