/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.gui;

import com.qendolin.betterclouds.gui.ConfigScreen;
import com.qendolin.betterclouds.gui.CustomOptionListWidget;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.api.utils.MutableDimension;
import dev.isxander.yacl3.gui.ElementListWidgetExt;
import dev.isxander.yacl3.gui.OptionDescriptionWidget;
import dev.isxander.yacl3.gui.OptionListWidget;
import dev.isxander.yacl3.gui.SearchFieldWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.tab.ListHolderWidget;
import dev.isxander.yacl3.gui.tab.TabExt;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class CustomCategoryTab
implements TabExt {
    private final Minecraft client;
    private final ConfigScreen screen;
    private final ConfigCategory category;
    private final Tooltip tooltip;
    private final Supplier<ScreenRectangle> areaGetter;
    private ListHolderWidget<OptionListWidget> optionList;
    private final Button saveFinishedButton;
    private final Button cancelResetButton;
    private final Button hideShowButton;
    private final SearchFieldWidget searchField;
    private OptionDescriptionWidget descriptionWidget;

    public CustomCategoryTab(Minecraft client, ConfigScreen screen, Supplier<ScreenRectangle> areaGetter, ConfigCategory category) {
        this.client = client;
        this.screen = screen;
        this.category = category;
        this.tooltip = Tooltip.create((Component)category.tooltip());
        this.areaGetter = areaGetter;
        int columnWidth = screen.width / 3;
        int padding = columnWidth / 20;
        columnWidth = Math.min(columnWidth, 400);
        int paddedWidth = columnWidth - padding * 2;
        MutableDimension actionDim = Dimension.ofInt((int)(screen.width / 3 * 2 + screen.width / 6), (int)(screen.height - padding - 20), (int)paddedWidth, (int)20);
        this.saveFinishedButton = Button.builder((Component)Component.literal((String)"Done"), btn -> screen.finishOrSave()).pos((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).size(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).build();
        actionDim.expand((Number)(-((Integer)actionDim.width()).intValue() / 2 - 2), (Number)0).move((Number)(-((Integer)actionDim.width()).intValue() / 2 - 2), (Number)-22);
        this.cancelResetButton = Button.builder((Component)Component.literal((String)"Cancel"), btn -> screen.cancelOrReset()).pos((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).size(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).build();
        this.cancelResetButton.active = false;
        actionDim.move((Number)((Integer)actionDim.width() + 4), (Number)0);
        this.hideShowButton = Button.builder((Component)Component.translatable((String)"betterclouds.config.hide"), btn -> this.hideOrShow()).pos((Integer)actionDim.x() - (Integer)actionDim.width() / 2, ((Integer)actionDim.y()).intValue()).size(((Integer)actionDim.width()).intValue(), ((Integer)actionDim.height()).intValue()).build();
        this.hideShowButton.active = client.level != null;
        this.searchField = new SearchFieldWidget((YACLScreen)screen, client.font, screen.width / 3 * 2 + screen.width / 6 - paddedWidth / 2 + 1, this.hideShowButton.getY() - 22, paddedWidth - 2, 18, (Component)Component.translatable((String)"gui.recipebook.search_hint"), (Component)Component.translatable((String)"gui.recipebook.search_hint"), searchQuery -> ((OptionListWidget)this.optionList.getList()).updateSearchQuery(searchQuery));
        this.optionList = new ListHolderWidget(() -> new ScreenRectangle(((ScreenRectangle)areaGetter.get()).position(), ((ScreenRectangle)areaGetter.get()).width() / 3 * 2 + 1, ((ScreenRectangle)areaGetter.get()).height()), (ElementListWidgetExt)new CustomOptionListWidget(screen, category, client, 0, 0, screen.width / 3 * 2 + 1, screen.height, desc -> this.descriptionWidget.setOptionDescription(desc)));
        this.descriptionWidget = new OptionDescriptionWidget(() -> new ScreenRectangle(screen.width / 3 * 2 + padding, ((ScreenRectangle)areaGetter.get()).top() + padding, paddedWidth, this.searchField.getY() - 1 - ((ScreenRectangle)areaGetter.get()).top() - padding * 2), null);
        this.updateButtons();
    }

    public void hideOrShow() {
        if (this.client.screen == this.screen) {
            this.hideShowButton.setMessage((Component)Component.translatable((String)"betterclouds.config.show"));
            ConfigScreen.HiddenScreen hiddenScreen = new ConfigScreen.HiddenScreen(this.screen.getTitle(), this.hideShowButton);
            this.client.setScreen((Screen)hiddenScreen);
        } else {
            this.hideShowButton.setMessage((Component)Component.translatable((String)"betterclouds.config.hide"));
            this.client.setScreen((Screen)this.screen);
        }
    }

    public void updateButtons() {
        boolean pendingChanges = this.screen.pendingChanges();
        if (Screen.hasShiftDown()) {
            this.cancelResetButton.active = true;
            this.cancelResetButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"betterclouds.config.reset.tooltip")));
        } else {
            this.cancelResetButton.active = false;
            this.cancelResetButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"betterclouds.config.reset.tooltip.holdShift")));
        }
        this.cancelResetButton.setMessage((Component)(pendingChanges ? GuiUtils.translatableFallback((String)"yacl.gui.cancel", (Component)CommonComponents.GUI_CANCEL) : Component.translatable((String)"controls.reset")));
        this.saveFinishedButton.setMessage((Component)(pendingChanges ? Component.translatable((String)"yacl.gui.save") : GuiUtils.translatableFallback((String)"yacl.gui.done", (Component)CommonComponents.GUI_DONE)));
        this.saveFinishedButton.setTooltip(Tooltip.create((Component)(pendingChanges ? Component.translatable((String)"yacl.gui.save.tooltip") : Component.translatable((String)"yacl.gui.finished.tooltip"))));
    }

    public Component getTabTitle() {
        return this.category.name();
    }

    public void visitChildren(Consumer<AbstractWidget> consumer) {
        consumer.accept((AbstractWidget)this.optionList);
        consumer.accept((AbstractWidget)this.saveFinishedButton);
        consumer.accept((AbstractWidget)this.cancelResetButton);
        consumer.accept((AbstractWidget)this.hideShowButton);
        consumer.accept((AbstractWidget)this.searchField);
        consumer.accept((AbstractWidget)this.descriptionWidget);
    }

    public void doLayout(ScreenRectangle screenRectangle) {
    }

    public void tick() {
        this.updateButtons();
        this.descriptionWidget.tick();
    }

    @Nullable
    public Tooltip getTooltip() {
        return this.tooltip;
    }
}

