/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.gui;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.DescriptionWithName;
import dev.isxander.yacl3.gui.OptionListWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.LabelController;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.jetbrains.annotations.Nullable;

public class CustomOptionListWidget
extends OptionListWidget {
    public CustomOptionListWidget(YACLScreen screen, ConfigCategory category, Minecraft client, int x, int y, int width, int height, Consumer<DescriptionWithName> hoverEvent) {
        super(screen, category, client, x, y, width, height, hoverEvent);
    }

    public void refreshOptions() {
        super.refreshOptions();
        this.addEntry((AbstractSelectionList.Entry)new PaddingEntry(this));
        for (OptionListWidget.Entry child : this.children()) {
            if (child instanceof OptionListWidget.ListGroupSeparatorEntry) continue;
            if (child instanceof OptionListWidget.OptionEntry) {
                OptionListWidget.OptionEntry optionEntry = (OptionListWidget.OptionEntry)child;
                if (optionEntry.option.controller() instanceof LabelController) {
                    this.addEntryBelow((OptionListWidget.Entry)optionEntry, new ProxyEntry(this, (OptionListWidget.Entry)optionEntry).onBeforeRender((delegate, context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta) -> {
                        if (this.minecraft.level == null) {
                            return;
                        }
                        Dimension dim = delegate.widget.getDimension();
                        context.fill(((Integer)dim.x()).intValue(), ((Integer)dim.y()).intValue(), ((Integer)dim.xLimit()).intValue(), ((Integer)dim.yLimit()).intValue(), 0x6B000000);
                    }));
                    this.removeEntry((OptionListWidget.Entry)optionEntry);
                    continue;
                }
            }
            if (!(child instanceof OptionListWidget.GroupSeparatorEntry)) continue;
            OptionListWidget.GroupSeparatorEntry groupSeparatorEntry = (OptionListWidget.GroupSeparatorEntry)child;
            this.addEntryBelow((OptionListWidget.Entry)groupSeparatorEntry, new ProxyEntry(this, (OptionListWidget.Entry)groupSeparatorEntry).onBeforeRender((delegate, context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta) -> {
                if (this.minecraft.level == null) {
                    return;
                }
                context.fill(x, y, x + entryWidth, y + 19, 0x6B000000);
            }));
            this.removeEntry((OptionListWidget.Entry)groupSeparatorEntry);
        }
        this.recacheViewableChildren();
        this.setScrollAmount(0.0);
        this.resetSmoothScrolling();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        for (OptionListWidget.Entry child : this.children()) {
            if (!child.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) continue;
            return true;
        }
        this.setScrollAmount(this.getScrollAmount() - verticalAmount * 20.0);
        return true;
    }

    private class PaddingEntry
    extends OptionListWidget.Entry {
        private PaddingEntry(CustomOptionListWidget customOptionListWidget) {
            super((OptionListWidget)customOptionListWidget);
        }

        public List<? extends NarratableEntry> narratables() {
            return List.of();
        }

        public List<? extends GuiEventListener> children() {
            return List.of();
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        }

        public int getItemHeight() {
            return 5;
        }
    }

    public static class ProxyEntry<T extends OptionListWidget.Entry>
    extends OptionListWidget.Entry {
        private final T delegate;
        public BeforeRenderCallback<T> beforeRender;
        public AfterRenderCallback<T> afterRender;
        final /* synthetic */ CustomOptionListWidget this$0;

        public ProxyEntry(T delegate) {
            this.this$0 = this$0;
            super((OptionListWidget)this$0);
            this.delegate = delegate;
        }

        public ProxyEntry<T> onBeforeRender(BeforeRenderCallback<T> callback) {
            this.beforeRender = callback;
            return this;
        }

        public ProxyEntry<T> onAfterRender(AfterRenderCallback<T> callback) {
            this.afterRender = callback;
            return this;
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.beforeRender != null) {
                this.beforeRender.onBeforeRender(this.delegate, context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            }
            this.delegate.render(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            if (this.afterRender != null) {
                this.afterRender.onAfterRender(this.delegate, context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            }
        }

        public List<? extends NarratableEntry> narratables() {
            return this.delegate.narratables();
        }

        public List<? extends GuiEventListener> children() {
            return this.delegate.children();
        }

        public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
            return this.delegate.getChildAt(mouseX, mouseY);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.delegate.mouseMoved(mouseX, mouseY);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return this.delegate.mouseReleased(mouseX, mouseY, button);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            return this.delegate.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return this.delegate.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
            return this.delegate.keyReleased(keyCode, scanCode, modifiers);
        }

        public boolean charTyped(char chr, int modifiers) {
            return this.delegate.charTyped(chr, modifiers);
        }

        @Nullable
        public ComponentPath getCurrentFocusPath() {
            return this.delegate.getCurrentFocusPath();
        }

        public ScreenRectangle getRectangle() {
            return this.delegate.getRectangle();
        }

        public boolean isViewable() {
            return this.delegate.isViewable();
        }

        public boolean isHovered() {
            return Objects.equals(this.this$0.getHovered(), (Object)this);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return this.delegate.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.delegate.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean isDragging() {
            return this.delegate.isDragging();
        }

        public void setDragging(boolean dragging) {
            this.delegate.setDragging(dragging);
        }

        @Nullable
        public GuiEventListener getFocused() {
            return this.delegate.getFocused();
        }

        @Nullable
        public ComponentPath focusPathAtIndex(FocusNavigationEvent navigation, int index) {
            return this.delegate.focusPathAtIndex(navigation, index);
        }

        @Nullable
        public ComponentPath nextFocusPath(FocusNavigationEvent navigation) {
            return this.delegate.nextFocusPath(navigation);
        }

        public boolean isFocused() {
            return this.delegate.isFocused();
        }

        public void setFocused(@Nullable GuiEventListener focused) {
            this.delegate.setFocused(focused);
        }

        public void setFocused(boolean focused) {
            this.delegate.setFocused(focused);
        }

        public void renderBack(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.delegate.renderBack(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.delegate.isMouseOver(mouseX, mouseY);
        }

        public int getItemHeight() {
            return this.delegate.getItemHeight();
        }

        public int getTabOrderGroup() {
            return this.delegate.getTabOrderGroup();
        }
    }

    @FunctionalInterface
    public static interface BeforeRenderCallback<T extends OptionListWidget.Entry> {
        public void onBeforeRender(T var1, GuiGraphics var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, boolean var10, float var11);
    }

    @FunctionalInterface
    public static interface AfterRenderCallback<T extends OptionListWidget.Entry> {
        public void onAfterRender(T var1, GuiGraphics var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, boolean var10, float var11);
    }
}

