/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.mixin.required;

import com.mojang.blaze3d.vertex.PoseStack;
import com.qendolin.betterclouds.BetterClouds;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.Renderer;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.compat.ProfilerWrapper;
import com.qendolin.betterclouds.config.ConfigManager;
import com.qendolin.betterclouds.duck.WorldRendererDuck;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import com.qendolin.betterclouds.telemetry.IssueReportManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=900)
public abstract class WorldRendererMixin
implements WorldRendererDuck {
    @Unique
    private final Vector3d tempVector = new Vector3d();
    @Unique
    private Renderer cloudRenderer;
    @Shadow
    private Frustum cullingFrustum;
    @Shadow
    @Nullable
    private Frustum capturedFrustum;
    @Shadow
    @Nullable
    private ClientLevel level;
    @Shadow
    private int ticks;
    @Shadow
    @Final
    private Vector3d frustumPos;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"<init>(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/renderer/entity/EntityRenderDispatcher;Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderDispatcher;Lnet/minecraft/client/renderer/RenderBuffers;)V"}, at={@At(value="TAIL")})
    private void init(Minecraft client, EntityRenderDispatcher entityRenderDispatcher, BlockEntityRenderDispatcher blockEntityRenderDispatcher, RenderBuffers bufferBuilders, CallbackInfo ci) {
        if (GLCompat.glCompat.isIncompatible()) {
            return;
        }
        this.cloudRenderer = new Renderer(client);
    }

    @Override
    public Renderer betterclouds$getRenderer() {
        return this.cloudRenderer;
    }

    @Inject(at={@At(value="TAIL")}, method={"onResourceManagerReload(Lnet/minecraft/server/packs/resources/ResourceManager;)V"})
    private void onReload(ResourceManager manager, CallbackInfo ci) {
        block5: {
            if (!BetterClouds.isInitialized()) {
                return;
            }
            if (GLCompat.glCompat.isIncompatible()) {
                return;
            }
            try {
                if (this.cloudRenderer != null) {
                    this.cloudRenderer.reload(manager);
                }
            }
            catch (Throwable e) {
                if (IssueReportManager.handle(e, "An error occurred while reloading resources: " + e.getMessage())) break block5;
                throw e;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setLevel(Lnet/minecraft/client/multiplayer/ClientLevel;)V"})
    private void onSetWorld(ClientLevel world, CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.setWorld(world);
        }
    }

    @Unique
    private Vector3d getCapturedFrustumPosition() {
        return new Vector3d((Vector3dc)this.frustumPos);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderClouds(Lcom/mojang/blaze3d/vertex/PoseStack;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;FDDD)V"}, cancellable=true)
    private void renderClouds(PoseStack matrices, Matrix4f viewMat, Matrix4f projMat, float tickDelta, double camX, double camY, double camZ, CallbackInfo ci) {
        block14: {
            if (this.cloudRenderer == null) {
                return;
            }
            if (GLCompat.glCompat.isIncompatible()) {
                return;
            }
            if (this.level == null) {
                return;
            }
            if (!ConfigManager.instance().enabledDimensions.contains(this.level.dimensionTypeRegistration().unwrapKey().orElse(null))) {
                return;
            }
            if (!BetterClouds.isEnabled()) {
                return;
            }
            ProfilerWrapper.getProfiler().push("betterclouds");
            GLCompat.glCompat.pushDebugGroupDev("Better Clouds");
            Vector3d cam = this.tempVector.set(camX, camY, camZ);
            Frustum frustum = this.cullingFrustum;
            Vector3d frustumPos = cam;
            if (this.capturedFrustum != null) {
                frustumPos = this.getCapturedFrustumPosition();
                frustum = this.capturedFrustum;
                frustum.prepare(frustumPos.x, frustumPos.y, frustumPos.z);
            }
            int ticks = this.ticks;
            if (Debug.animationPause >= 0) {
                if (Debug.animationPause == 0) {
                    Debug.animationPause = ticks;
                } else {
                    ticks = Debug.animationPause;
                }
                tickDelta = 0.0f;
            }
            try {
                Renderer.PrepareResult prepareResult = this.cloudRenderer.prepare(viewMat, projMat, ticks, tickDelta, cam);
                if (RenderDoc.isFrameCapturing()) {
                    GLCompat.glCompat.debugMessage("renderer prepare returned " + prepareResult.name());
                }
                if (prepareResult != Renderer.PrepareResult.FALLBACK) {
                    ci.cancel();
                }
                if (prepareResult == Renderer.PrepareResult.RENDER) {
                    this.cloudRenderer.render(ticks, tickDelta, cam, frustumPos, frustum);
                }
            }
            catch (Throwable e) {
                if (IssueReportManager.handle(e, "An error occurred while rendering: " + e.getMessage())) break block14;
                throw e;
            }
        }
        ProfilerWrapper.getProfiler().pop();
        GLCompat.glCompat.popDebugGroupDev();
    }

    @Inject(at={@At(value="HEAD")}, method={"close()V"})
    private void close(CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.close();
        }
    }
}

