/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.platform;

import com.qendolin.betterclouds.BetterCloudsStatic;
import com.qendolin.betterclouds.platform.ModVersion;
import com.qendolin.betterclouds.platform.neoforge.ModVersionImpl;
import java.nio.file.Path;
import java.util.Optional;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.LoadingModList;

public final class ModLoader {
    public static Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    public static boolean isModLoaded(String modId) {
        ModList modList = ModList.get();
        if (modList != null) {
            return modList.isLoaded(modId);
        }
        LoadingModList loadingModList = LoadingModList.get();
        if (loadingModList != null) {
            return loadingModList.getModFileById(modId) != null;
        }
        return false;
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    public static boolean isClientEnvironment() {
        return FMLLoader.getDist().isClient();
    }

    public static ModVersion getModVersion(String modId) {
        ModList modList = ModList.get();
        if (modList == null) {
            BetterCloudsStatic.getLogger().warn("getModVersion called before the mod list is initialized.");
            return ModVersion.NONE;
        }
        Optional mod = modList.getModContainerById(modId);
        if (mod.isEmpty()) {
            return ModVersion.NONE;
        }
        return new ModVersionImpl(((ModContainer)mod.get()).getModInfo().getVersion());
    }
}

