/*
 * Decompiled with CFR 0.152.
 */
package net.enchant_limiter.mixin;

import net.enchant_limiter.api.ItemComponentTypes;
import net.enchant_limiter.api.LimitComponent;
import net.enchant_limiter.api.LimitHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Enchantment.class})
public class EnchantmentMixin {
    @Inject(method={"canEnchant(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isAcceptableItem_HEAD_EnchantLimiter(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        LimitComponent limiter = (LimitComponent)stack.get(ItemComponentTypes.ENCHANT_LIMITER);
        ItemEnchantments existingEnchantments = stack.getEnchantments();
        if (limiter != null && existingEnchantments != null) {
            boolean atLimit;
            Enchantment enchantment = (Enchantment)this;
            boolean existingEnchantment = existingEnchantments.keySet().stream().anyMatch(entry -> ((Enchantment)entry.value()).equals((Object)enchantment));
            int limitCount = LimitHelper.getLimitCount(stack);
            boolean bl = atLimit = existingEnchantments.keySet().size() >= limitCount;
            if (atLimit && !existingEnchantment) {
                cir.setReturnValue((Object)false);
                cir.cancel();
            }
        }
    }
}

