/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import doggytalents.client.entity.model.SyncedAccessoryModel;
import doggytalents.client.entity.model.dog.DogModel;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.joml.Vector3f;

public class SyncedRenderFunctionWithHeadModel
extends SyncedAccessoryModel {
    private Vector3f pivot = DogModel.DEFAULT_ROOT_PIVOT;

    public SyncedRenderFunctionWithHeadModel(ModelPart root) {
        super(root);
    }

    @Override
    public void sync(DogModel dogModel) {
        this.root.copyFrom(dogModel.root);
        this.syncPart(this.head, dogModel.head);
        this.syncPart(this.realHead, dogModel.realHead);
        this.pivot = DogModel.DEFAULT_ROOT_PIVOT;
        Vector3f custom_pivot = dogModel.getCustomRootPivotPoint();
        if (custom_pivot != null) {
            this.pivot = custom_pivot;
        }
    }

    private void syncPart(Optional<ModelPart> part, ModelPart dogPart) {
        part.ifPresent(p -> p.copyFrom(dogPart));
    }

    @Override
    protected void populatePart(ModelPart box) {
        this.head = Optional.of(box.getChild("head"));
        this.realHead = Optional.of(((ModelPart)this.head.get()).getChild("real_head"));
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.5f, (float)-7.0f));
        PartDefinition real_head = head.addOrReplaceChild("real_head", CubeListBuilder.create(), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    @Override
    public void renderToBuffer(PoseStack stack, VertexConsumer p_103014_, int p_103015_, int p_103016_, int unused) {
    }

    public void startRenderFromRoot(PoseStack stack, Renderer actualRendering) {
        stack.pushPose();
        stack.translate((double)(this.root.x / 16.0f), (double)(this.root.y / 16.0f), (double)(this.root.z / 16.0f));
        stack.translate((double)(this.pivot.x / 16.0f), (double)(this.pivot.y / 16.0f), (double)(this.pivot.z / 16.0f));
        if (this.root.zRot != 0.0f) {
            stack.mulPose(Axis.ZP.rotation(this.root.zRot));
        }
        if (this.root.yRot != 0.0f) {
            stack.mulPose(Axis.YP.rotation(this.root.yRot));
        }
        if (this.root.xRot != 0.0f) {
            stack.mulPose(Axis.XP.rotation(this.root.xRot));
        }
        float xRot0 = this.root.xRot;
        float yRot0 = this.root.yRot;
        float zRot0 = this.root.zRot;
        float x0 = this.root.x;
        float y0 = this.root.y;
        float z0 = this.root.z;
        this.root.xRot = 0.0f;
        this.root.yRot = 0.0f;
        this.root.zRot = 0.0f;
        this.root.x = 0.0f;
        this.root.y = 0.0f;
        this.root.z = 0.0f;
        stack.pushPose();
        stack.translate((double)(-this.pivot.x / 16.0f), (double)(-this.pivot.y / 16.0f), (double)(-this.pivot.z / 16.0f));
        if (this.young) {
            stack.pushPose();
            stack.scale(2.0f, 2.0f, 2.0f);
            stack.translate(0.0, -0.5, 0.15);
            this.startRenderItemFromHead(stack, actualRendering);
            stack.popPose();
        } else {
            this.startRenderItemFromHead(stack, actualRendering);
        }
        stack.popPose();
        stack.popPose();
        this.root.xRot = xRot0;
        this.root.yRot = yRot0;
        this.root.zRot = zRot0;
        this.root.x = x0;
        this.root.y = y0;
        this.root.z = z0;
    }

    public void startRenderItemFromHead(PoseStack matrixStack, Renderer renderer) {
        matrixStack.pushPose();
        ((ModelPart)this.head.get()).translateAndRotate(matrixStack);
        matrixStack.pushPose();
        ((ModelPart)this.realHead.get()).translateAndRotate(matrixStack);
        renderer.doRender(matrixStack);
        matrixStack.popPose();
        matrixStack.popPose();
    }

    public static interface Renderer {
        public void doRender(PoseStack var1);
    }
}

