/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.dog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.events.RegisterCustomDogModelsEvent;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import org.joml.Vector3f;

public class CustomDogModel
extends DogModel {
    private final RegisterCustomDogModelsEvent.DogModelProps props;
    private ModelPart glowingEyes;
    private ModelPart realGlowingEyes;

    public CustomDogModel(ModelPart box, RegisterCustomDogModelsEvent.DogModelProps props) {
        super(box);
        this.props = props;
        if (this.props.glowingEyes) {
            this.setupGlowingEyes();
        }
    }

    private void setupGlowingEyes() {
        this.glowingEyes = this.root.getChild("glowing_eyes");
        this.realGlowingEyes = this.glowingEyes.getChild("real_glowing_eyes");
    }

    @Override
    public boolean acessoryShouldRender(Dog dog, AccessoryInstance inst) {
        if (this.props.renderModelAccessoriesOnly) {
            return inst.getAccessory().getAccessoryRenderType() == Accessory.AccessoryRenderType.MODEL;
        }
        return this.props.shouldRenderAccessories;
    }

    @Override
    public boolean incapShouldRender(Dog dog) {
        return this.props.shouldRenderIncapacitated;
    }

    @Override
    public boolean scaleBabyDog() {
        return false;
    }

    @Override
    @Nullable
    public Vector3f getCustomRootPivotPoint() {
        return this.props.customRootPivot;
    }

    @Override
    public boolean hasDefaultScale() {
        return this.props.hasDefaultScale;
    }

    @Override
    public float getDefaultScale() {
        return this.props.defaultScale;
    }

    @Override
    public boolean armorShouldRender(Dog dog) {
        return false;
    }

    @Override
    public DogModel.AccessoryState getAccessoryState() {
        if (this.props.shouldRenderAccessories) {
            return DogModel.AccessoryState.HAVE_NOT_TESTED;
        }
        if (this.props.renderModelAccessoriesOnly) {
            return DogModel.AccessoryState.MODEL_ONLY;
        }
        return DogModel.AccessoryState.NON_COMPATIBLE;
    }

    @Override
    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.props.glowingEyes) {
            this.glowingEyes.copyFrom(this.head);
            this.realGlowingEyes.copyFrom(this.realHead);
            this.glowingEyes.visible = this.head.visible;
            this.realGlowingEyes.visible = this.realHead.visible;
        }
    }

    @Override
    protected AnimationDefinition getAnimationSequence(DogAnimation anim) {
        Map<DogAnimation, AnimationDefinition> animOverride = this.props.getAnimOverride();
        if (animOverride.isEmpty()) {
            return super.getAnimationSequence(anim);
        }
        AnimationDefinition animDef = animOverride.get((Object)anim);
        if (animDef == null) {
            return super.getAnimationSequence(anim);
        }
        return animDef;
    }

    @Override
    public void renderToBuffer(PoseStack p_102034_, VertexConsumer p_102035_, int p_102036_, int p_102037_, int color_overlay) {
        Vector3f pivot = DEFAULT_ROOT_PIVOT;
        Vector3f custom_pivot = this.getCustomRootPivotPoint();
        if (custom_pivot != null) {
            pivot = custom_pivot;
        }
        p_102034_.pushPose();
        p_102034_.translate((double)(this.root.x / 16.0f), (double)(this.root.y / 16.0f), (double)(this.root.z / 16.0f));
        p_102034_.translate((double)(pivot.x / 16.0f), (double)(pivot.y / 16.0f), (double)(pivot.z / 16.0f));
        if (this.root.zRot != 0.0f) {
            p_102034_.mulPose(Axis.ZP.rotation(this.root.zRot));
        }
        if (this.root.yRot != 0.0f) {
            p_102034_.mulPose(Axis.YP.rotation(this.root.yRot));
        }
        if (this.root.xRot != 0.0f) {
            p_102034_.mulPose(Axis.XP.rotation(this.root.xRot));
        }
        float xRot0 = this.root.xRot;
        float yRot0 = this.root.yRot;
        float zRot0 = this.root.zRot;
        float x0 = this.root.x;
        float y0 = this.root.y;
        float z0 = this.root.z;
        this.root.xRot = 0.0f;
        this.root.yRot = 0.0f;
        this.root.zRot = 0.0f;
        this.root.x = 0.0f;
        this.root.y = 0.0f;
        this.root.z = 0.0f;
        p_102034_.pushPose();
        p_102034_.translate((double)(-pivot.x / 16.0f), (double)(-pivot.y / 16.0f), (double)(-pivot.z / 16.0f));
        if (this.young && this.scaleBabyDog()) {
            boolean headVisible0 = this.head.visible;
            this.head.visible = false;
            p_102034_.pushPose();
            this.root.render(p_102034_, p_102035_, p_102036_, p_102037_, color_overlay);
            p_102034_.popPose();
            this.head.visible = headVisible0;
            p_102034_.pushPose();
            p_102034_.scale(2.0f, 2.0f, 2.0f);
            p_102034_.translate(0.0, -0.5, 0.15);
            this.head.render(p_102034_, p_102035_, p_102036_, p_102037_, color_overlay);
            p_102034_.popPose();
        } else {
            boolean glowingEyes_visible0 = false;
            if (this.props.glowingEyes) {
                glowingEyes_visible0 = this.glowingEyes.visible;
                this.glowingEyes.render(p_102034_, p_102035_, 0xF000F0, p_102037_, color_overlay);
                this.glowingEyes.visible = false;
            }
            this.root.render(p_102034_, p_102035_, p_102036_, p_102037_, color_overlay);
            if (this.props.glowingEyes) {
                this.glowingEyes.visible = glowingEyes_visible0;
            }
        }
        p_102034_.popPose();
        p_102034_.popPose();
        this.root.xRot = xRot0;
        this.root.yRot = yRot0;
        this.root.zRot = zRot0;
        this.root.x = x0;
        this.root.y = y0;
        this.root.z = z0;
    }
}

