/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.dog;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.model.animation.DogAnimationRegistry;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.entity.anim.DogAnimationState;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.util.Util;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class DogModel
extends EntityModel<Dog> {
    public static final float[] MANE_LYING_OFF = new float[]{0.0f, 6.0f, 1.0f};
    public static final float[] MANE_SITTING_OFF = new float[]{0.0f, 2.0f, 0.0f};
    public static final float[] TAIL_LYING_OFF = new float[]{0.0f, 6.0f, 0.0f};
    public static final float[] TAIL_SITTING_OFF = new float[]{0.0f, 9.0f, -2.0f};
    public static final Vector3f DEFAULT_ROOT_PIVOT = new Vector3f(0.0f, 15.0f, 0.0f);
    public ModelPart head;
    public ModelPart realHead;
    public ModelPart body;
    public ModelPart mane;
    public ModelPart legBackRight;
    public ModelPart legBackLeft;
    public ModelPart legFrontRight;
    public ModelPart legFrontLeft;
    public ModelPart tail;
    public ModelPart realTail;
    public ModelPart root;
    public Optional<ModelPart> earLeft;
    public Optional<ModelPart> earRight;
    Vector3f vecObj = new Vector3f();
    private float headXRot0 = 0.0f;
    private float headYRot0 = 0.0f;
    private float realHeadZRot0 = 0.0f;
    private AccessoryState accessoryState = AccessoryState.HAVE_NOT_TESTED;
    protected float wetShade = 1.0f;

    public DogModel(ModelPart box) {
        this.root = box;
        this.head = box.getChild("head");
        this.realHead = this.head.getChild("real_head");
        this.body = box.getChild("body");
        this.mane = box.getChild("upper_body");
        this.legBackRight = box.getChild("right_hind_leg");
        this.legBackLeft = box.getChild("left_hind_leg");
        this.legFrontRight = box.getChild("right_front_leg");
        this.legFrontLeft = box.getChild("left_front_leg");
        this.tail = box.getChild("tail");
        this.realTail = this.tail.getChild("real_tail");
        this.addOptionalParts(box);
        this.correctInitalPose();
    }

    public DogModel(ModelPart box, Function<ResourceLocation, RenderType> renderType) {
        super(renderType);
        this.root = box;
        this.head = box.getChild("head");
        this.realHead = this.head.getChild("real_head");
        this.body = box.getChild("body");
        this.mane = box.getChild("upper_body");
        this.legBackRight = box.getChild("right_hind_leg");
        this.legBackLeft = box.getChild("left_hind_leg");
        this.legFrontRight = box.getChild("right_front_leg");
        this.legFrontLeft = box.getChild("left_front_leg");
        this.tail = box.getChild("tail");
        this.realTail = this.tail.getChild("real_tail");
        this.addOptionalParts(box);
        this.correctInitalPose();
    }

    protected void addOptionalParts(ModelPart box) {
        this.earLeft = this.getChildIfPresent(this.realHead, "left_ear");
        this.earRight = this.getChildIfPresent(this.realHead, "right_ear");
    }

    protected Optional<ModelPart> getChildIfPresent(ModelPart box, String name) {
        if (!box.hasChild(name)) {
            return Optional.empty();
        }
        return Optional.of(box.getChild(name));
    }

    public static LayerDefinition createBodyLayer() {
        return DogModel.createBodyLayerInternal(CubeDeformation.NONE);
    }

    public boolean useDefaultModelForAccessories() {
        return false;
    }

    private static LayerDefinition createBodyLayerInternal(CubeDeformation scale) {
        MeshDefinition var0 = new MeshDefinition();
        PartDefinition var1 = var0.getRoot();
        float var2 = 13.5f;
        PartDefinition var3 = var1.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.5f, (float)-7.0f));
        PartDefinition real_head = var3.addOrReplaceChild("real_head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, scale).texOffs(0, 10).addBox(-1.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, scale), PartPose.ZERO);
        real_head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(16, 14).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-3.0f, (float)0.5f));
        real_head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(16, 14).addBox(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-3.0f, (float)0.5f));
        var1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 14).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, scale), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        var1.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(21, 0).addBox(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, scale), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder var4 = CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale);
        var1.addOrReplaceChild("right_hind_leg", var4, PartPose.offset((float)-1.5f, (float)16.0f, (float)7.0f));
        var1.addOrReplaceChild("left_hind_leg", var4, PartPose.offset((float)1.5f, (float)16.0f, (float)7.0f));
        var1.addOrReplaceChild("right_front_leg", var4, PartPose.offset((float)-1.5f, (float)16.0f, (float)-4.0f));
        var1.addOrReplaceChild("left_front_leg", var4, PartPose.offset((float)1.5f, (float)16.0f, (float)-4.0f));
        PartDefinition var5 = var1.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        var5.addOrReplaceChild("real_tail", CubeListBuilder.create().texOffs(9, 18).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, scale), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)var0, (int)64, (int)32);
    }

    public void prepareMobModel(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.resetAllPose();
        DogPose pose = dog.getDogPose();
        DogAnimation anim = dog.getAnim();
        if (anim != DogAnimation.NONE) {
            if (anim.freeHead() && pose.canBeg) {
                this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
            }
            return;
        }
        switch (pose) {
            case FAINTED: {
                this.setupFaintPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case FAINTED_2: {
                this.setupFaintPose2(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case SIT: {
                this.setUpSitPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case REST: {
                this.setupRestPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case LYING_2: {
                this.setupLyingPose2(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case DROWN: {
                this.setupDrownPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case FLYING: {
                this.setupFlyPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            case REST_BELLY: {
                this.setupRestBellyPose(dog, limbSwing, limbSwingAmount, partialTickTime);
                break;
            }
            default: {
                this.setUpStandPose(dog, limbSwing, limbSwingAmount, partialTickTime);
            }
        }
        if (pose.canShake) {
            this.translateShakingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
        if (pose.canBeg) {
            this.translateBeggingDog(dog, limbSwing, limbSwingAmount, partialTickTime);
        }
    }

    public void setUpStandPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.animateStandWalking(dog, limbSwing, limbSwingAmount, partialTickTime);
    }

    public void animateStandWalking(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        float w = Mth.cos((float)(limbSwing * 0.6662f));
        float w1 = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI));
        float swing = Mth.clamp((float)limbSwingAmount, (float)0.0f, (float)1.0f);
        float modifier = 2.5f;
        this.body.xRot += this.getAnimateWalkingValue(w, swing, modifier * -5.0f * ((float)Math.PI / 180));
        this.body.y += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.body.z += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.mane.xRot += this.getAnimateWalkingValue(w, swing, modifier * 2.5f * ((float)Math.PI / 180));
        this.mane.y += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.head.y += this.getAnimateWalkingValue(w, swing, -0.25f * modifier);
        this.tail.y += this.getAnimateWalkingValue(w, swing, 0.5f * modifier);
        this.tail.z += this.getAnimateWalkingValue(w, swing, -0.5f * modifier);
        if (this.earRight.isPresent()) {
            this.earRight.get().xRot += this.getAnimateWalkingValue(w, swing, -0.6981317f);
            this.earRight.get().zRot += this.getAnimateWalkingValue(w, swing, -0.47996554f);
            this.earRight.get().y += this.getAnimateWalkingValue(w, swing, 0.5f);
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().xRot += this.getAnimateWalkingValue(w, swing, -0.6981317f);
            this.earLeft.get().zRot += this.getAnimateWalkingValue(w, swing, 0.47996554f);
            this.earLeft.get().y += this.getAnimateWalkingValue(w, swing, 0.5f);
        }
        this.legBackRight.xRot += w * 1.4f * limbSwingAmount;
        this.legBackLeft.xRot += w1 * 1.4f * limbSwingAmount;
        this.legFrontRight.xRot += w1 * 1.4f * limbSwingAmount;
        this.legFrontLeft.xRot += w * 1.4f * limbSwingAmount;
    }

    private float getAnimateWalkingValue(float w, float swingAmount, float amplitude) {
        int sign = Mth.sign((double)amplitude);
        amplitude = Math.abs(amplitude);
        return (float)sign * Math.abs(amplitude * swingAmount * w);
    }

    public void setUpSitPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-9.0f, (float)-2.0f));
        this.legFrontLeft.offsetRotation(KeyframeAnimations.degreeVec((float)-27.0f, (float)0.0f, (float)0.0f));
        this.legFrontLeft.offsetPos(KeyframeAnimations.posVec((float)0.01f, (float)-1.0f, (float)0.0f));
        this.legFrontRight.offsetRotation(KeyframeAnimations.degreeVec((float)-27.0f, (float)0.0f, (float)0.0f));
        this.legFrontRight.offsetPos(KeyframeAnimations.posVec((float)0.01f, (float)-1.0f, (float)0.0f));
        this.legBackLeft.offsetRotation(KeyframeAnimations.degreeVec((float)-90.0f, (float)0.0f, (float)0.0f));
        this.legBackLeft.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.0f, (float)-5.0f));
        this.legBackRight.offsetRotation(KeyframeAnimations.degreeVec((float)-90.0f, (float)0.0f, (float)0.0f));
        this.legBackRight.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.0f, (float)-5.0f));
        this.mane.offsetRotation(KeyframeAnimations.degreeVec((float)-18.0f, (float)0.0f, (float)0.0f));
        this.mane.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-2.0f, (float)0.0f));
        this.body.offsetRotation(KeyframeAnimations.degreeVec((float)-45.0f, (float)0.0f, (float)0.0f));
        this.body.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-4.0f, (float)-2.0f));
        this.head.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f));
        this.head.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f));
    }

    public void setupFaintPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.offsetRotation(KeyframeAnimations.degreeVec((float)6.2f, (float)4.97f, (float)-2.04f));
        this.head.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-1.0f, (float)-0.5f));
        this.body.offsetRotation(KeyframeAnimations.degreeVec((float)2.5f, (float)0.0f, (float)0.0f));
        this.body.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.5f, (float)0.0f));
        this.legBackRight.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-22.5f));
        this.legBackRight.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f));
        this.legBackLeft.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-15.0f));
        this.legBackLeft.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f));
        this.legFrontRight.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-30.0f));
        this.legFrontRight.offsetPos(KeyframeAnimations.posVec((float)-1.0f, (float)-1.0f, (float)0.0f));
        this.legFrontLeft.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)-7.5f));
        this.legFrontLeft.offsetPos(KeyframeAnimations.posVec((float)1.0f, (float)-0.25f, (float)0.0f));
        this.tail.offsetRotation(KeyframeAnimations.degreeVec((float)162.35f, (float)11.59f, (float)38.36f));
        this.tail.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.29f, (float)0.15f));
        this.mane.offsetRotation(KeyframeAnimations.degreeVec((float)7.5f, (float)0.0f, (float)0.0f));
        this.mane.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-1.0f, (float)0.75f));
        this.root.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)90.0f));
        this.root.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-5.0f, (float)0.0f));
        if (this.earRight.isPresent()) {
            this.earRight.get().offsetRotation(KeyframeAnimations.degreeVec((float)40.11192f, (float)-29.43433f, (float)-3.24563f));
            this.earRight.get().offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.25f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().offsetRotation(KeyframeAnimations.degreeVec((float)38.7522f, (float)-4.33973f, (float)12.33768f));
            this.earLeft.get().offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.25f, (float)0.0f));
        }
    }

    public void setupFaintPose2(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.offsetRotation(KeyframeAnimations.degreeVec((float)4.34f, (float)-4.46f, (float)16.94f));
        this.head.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-7.0f, (float)0.25f));
        this.body.offsetRotation(KeyframeAnimations.degreeVec((float)-7.5f, (float)0.0f, (float)0.0f));
        this.body.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.5f, (float)-1.5f));
        this.mane.offsetRotation(KeyframeAnimations.degreeVec((float)-5.0f, (float)0.0f, (float)0.0f));
        this.mane.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.75f, (float)0.0f));
        this.legBackRight.offsetRotation(KeyframeAnimations.degreeVec((float)87.38f, (float)-17.48f, (float)0.79f));
        this.legBackRight.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-7.5f, (float)-1.0f));
        this.legBackLeft.offsetRotation(KeyframeAnimations.degreeVec((float)90.0f, (float)22.5f, (float)0.0f));
        this.legBackLeft.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-7.5f, (float)-1.25f));
        this.legFrontRight.offsetRotation(KeyframeAnimations.degreeVec((float)-88.01f, (float)24.9f, (float)-2.33f));
        this.legFrontRight.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.75f, (float)0.0f));
        this.legFrontLeft.offsetRotation(KeyframeAnimations.degreeVec((float)-91.14f, (float)-29.72f, (float)4.31f));
        this.legFrontLeft.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-7.0f, (float)0.0f));
        this.tail.xRot = dog.getTailRotation();
        this.tail.offsetRotation(KeyframeAnimations.degreeVec((float)62.36f, (float)-4.65f, (float)2.29f));
        this.tail.offsetPos(KeyframeAnimations.posVec((float)0.17f, (float)-7.48f, (float)-1.35f));
        if (this.earRight.isPresent()) {
            this.earRight.get().offsetRotation(KeyframeAnimations.degreeVec((float)51.29f, (float)23.61f, (float)-14.74f));
            this.earRight.get().offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.5f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().offsetRotation(KeyframeAnimations.degreeVec((float)53.71f, (float)-14.26f, (float)10.25f));
            this.earLeft.get().offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.5f, (float)0.0f));
        }
    }

    public void setupRestPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.offsetRotation(KeyframeAnimations.degreeVec((float)-7.54f, (float)0.76f, (float)2.5f));
        this.head.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-5.0f, (float)2.0f));
        this.body.offsetRotation(KeyframeAnimations.degreeVec((float)0.5f, (float)0.0f, (float)0.0f));
        this.body.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.5f, (float)0.0f));
        this.legBackRight.offsetRotation(KeyframeAnimations.degreeVec((float)-90.0f, (float)22.5f, (float)0.0f));
        this.legBackRight.offsetPos(KeyframeAnimations.posVec((float)-0.5f, (float)-7.0f, (float)1.0f));
        this.legBackLeft.offsetRotation(KeyframeAnimations.degreeVec((float)-90.0f, (float)-22.5f, (float)0.0f));
        this.legBackLeft.offsetPos(KeyframeAnimations.posVec((float)0.5f, (float)-7.0f, (float)1.0f));
        this.legFrontRight.offsetRotation(KeyframeAnimations.degreeVec((float)-87.41193f, (float)14.98539f, (float)0.66963f));
        this.legFrontRight.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.75f, (float)2.0f));
        this.legFrontLeft.offsetRotation(KeyframeAnimations.degreeVec((float)-87.41193f, (float)-14.98539f, (float)-0.66963f));
        this.legFrontLeft.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.75f, (float)2.0f));
        this.tail.xRot = dog.getTailRotation();
        this.tail.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)-40.0f, (float)0.0f));
        this.tail.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-7.0f, (float)-0.25f));
        this.mane.offsetRotation(KeyframeAnimations.degreeVec((float)-2.5f, (float)0.0f, (float)0.0f));
        this.mane.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.5f, (float)2.0f));
        if (this.earRight.isPresent()) {
            this.earRight.get().offsetRotation(KeyframeAnimations.degreeVec((float)26.57f, (float)14.48f, (float)-26.57f));
            this.earRight.get().offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.5f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().offsetRotation(KeyframeAnimations.degreeVec((float)26.57f, (float)-14.48f, (float)26.57f));
            this.earLeft.get().offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.5f, (float)0.0f));
        }
    }

    public void setupLyingPose2(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)27.5f));
        this.head.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.75f, (float)2.0f));
        this.body.offsetRotation(KeyframeAnimations.degreeVec((float)0.5f, (float)0.0f, (float)0.0f));
        this.body.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.5f, (float)0.0f));
        this.legBackRight.offsetRotation(KeyframeAnimations.degreeVec((float)-90.0f, (float)22.5f, (float)0.0f));
        this.legBackRight.offsetPos(KeyframeAnimations.posVec((float)-0.5f, (float)-7.0f, (float)1.0f));
        this.legBackLeft.offsetRotation(KeyframeAnimations.degreeVec((float)-90.0f, (float)-22.5f, (float)0.0f));
        this.legBackLeft.offsetPos(KeyframeAnimations.posVec((float)0.5f, (float)-7.0f, (float)1.0f));
        this.legFrontRight.offsetRotation(KeyframeAnimations.degreeVec((float)-87.41193f, (float)14.98539f, (float)0.66963f));
        this.legFrontRight.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.75f, (float)2.0f));
        this.legFrontLeft.offsetRotation(KeyframeAnimations.degreeVec((float)-87.41193f, (float)-14.98539f, (float)-0.66963f));
        this.legFrontLeft.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.75f, (float)2.0f));
        this.tail.xRot = dog.getTailRotation();
        this.tail.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f));
        this.tail.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-7.0f, (float)-0.25f));
        this.mane.offsetRotation(KeyframeAnimations.degreeVec((float)-2.5f, (float)0.0f, (float)0.0f));
        this.mane.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-6.5f, (float)2.0f));
        if (this.earRight.isPresent()) {
            this.earRight.get().offsetRotation(KeyframeAnimations.degreeVec((float)26.57f, (float)14.48f, (float)-26.57f));
            this.earRight.get().offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.5f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().offsetRotation(KeyframeAnimations.degreeVec((float)26.57f, (float)-14.48f, (float)26.57f));
            this.earLeft.get().offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.5f, (float)0.0f));
        }
    }

    public void setupFlyPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.offsetRotation(KeyframeAnimations.degreeVec((float)84.84f, (float)-5.13f, (float)-5.65f));
        this.tail.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-1.18f, (float)-1.63f));
        this.legFrontLeft.offsetRotation(KeyframeAnimations.degreeVec((float)-84.33f, (float)0.0f, (float)0.0f));
        this.legFrontLeft.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-1.21f, (float)0.0f));
        this.legFrontRight.offsetRotation(KeyframeAnimations.degreeVec((float)-100.98f, (float)0.0f, (float)0.0f));
        this.legFrontRight.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-1.21f, (float)0.0f));
        this.legBackLeft.offsetRotation(KeyframeAnimations.degreeVec((float)78.49f, (float)0.0f, (float)0.0f));
        this.legBackLeft.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)-1.85f));
        this.legBackRight.offsetRotation(KeyframeAnimations.degreeVec((float)59.61f, (float)0.0f, (float)0.0f));
        this.legBackRight.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)-1.85f));
        this.mane.offsetRotation(KeyframeAnimations.degreeVec((float)-9.67f, (float)0.0f, (float)0.0f));
        this.mane.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-1.21f, (float)0.46f));
        this.head.offsetRotation(KeyframeAnimations.degreeVec((float)-13.12f, (float)0.0f, (float)0.0f));
        this.head.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)0.0f));
        this.root.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f));
        this.root.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)2.03f, (float)0.0f));
        this.body.offsetRotation(KeyframeAnimations.degreeVec((float)1.02f, (float)0.0f, (float)0.0f));
        this.body.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-1.03f, (float)-1.32f));
        if (this.earRight.isPresent()) {
            this.earRight.get().offsetRotation(KeyframeAnimations.degreeVec((float)-55.69f, (float)2.98f, (float)-3.43f));
            this.earRight.get().offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.35f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().offsetRotation(KeyframeAnimations.degreeVec((float)-55.69f, (float)-2.98f, (float)3.43f));
            this.earLeft.get().offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.35f, (float)0.0f));
        }
    }

    public void setupDrownPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.offsetRotation(KeyframeAnimations.degreeVec((float)35.0f, (float)0.0f, (float)0.0f));
        this.head.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.5f, (float)0.25f));
        this.body.offsetRotation(KeyframeAnimations.degreeVec((float)-22.5f, (float)0.0f, (float)0.0f));
        this.body.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)1.5f, (float)-2.5f));
        this.mane.offsetRotation(KeyframeAnimations.degreeVec((float)10.0f, (float)0.0f, (float)0.0f));
        this.mane.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)1.0f, (float)0.0f));
        this.legBackRight.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f));
        this.legBackRight.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)-3.5f));
        this.legBackLeft.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f));
        this.legBackLeft.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)0.0f, (float)-3.5f));
        this.legFrontRight.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f));
        this.legFrontRight.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)2.0f, (float)0.0f));
        this.legFrontLeft.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)0.0f, (float)0.0f));
        this.legFrontLeft.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)1.0f, (float)0.0f));
        this.tail.xRot = dog.getTailRotation();
        this.tail.offsetRotation(KeyframeAnimations.degreeVec((float)10.0f, (float)0.0f, (float)0.0f));
        this.tail.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.5f, (float)-2.0f));
    }

    public void setupRestBellyPose(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.head.offsetRotation(KeyframeAnimations.degreeVec((float)-38.87f, (float)-25.09f, (float)-23.41f));
        this.head.offsetPos(KeyframeAnimations.posVec((float)-0.01f, (float)-1.9f, (float)0.36f));
        this.body.offsetRotation(KeyframeAnimations.degreeVec((float)-18.36f, (float)14.74f, (float)22.42f));
        this.body.offsetPos(KeyframeAnimations.posVec((float)0.21f, (float)-3.81f, (float)-0.83f));
        this.legBackRight.offsetRotation(KeyframeAnimations.degreeVec((float)-26.7f, (float)14.23f, (float)47.53f));
        this.legBackRight.offsetPos(KeyframeAnimations.posVec((float)-0.09f, (float)-3.49f, (float)-0.65f));
        this.legBackLeft.offsetRotation(KeyframeAnimations.degreeVec((float)-38.05f, (float)-3.87f, (float)0.0f));
        this.legBackLeft.offsetPos(KeyframeAnimations.posVec((float)0.09f, (float)-6.17f, (float)-2.3f));
        this.legFrontRight.offsetRotation(KeyframeAnimations.degreeVec((float)-42.32f, (float)19.74f, (float)41.58f));
        this.legFrontRight.offsetPos(KeyframeAnimations.posVec((float)-0.5f, (float)-2.0f, (float)1.18f));
        this.legFrontLeft.offsetRotation(KeyframeAnimations.degreeVec((float)-29.77f, (float)2.06f, (float)-2.6f));
        this.legFrontLeft.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-2.0f, (float)0.35f));
        this.tail.offsetRotation(KeyframeAnimations.degreeVec((float)0.0f, (float)29.9f, (float)0.0f));
        this.tail.offsetPos(KeyframeAnimations.posVec((float)1.24f, (float)-6.7f, (float)-1.49f));
        this.mane.offsetRotation(KeyframeAnimations.degreeVec((float)-12.78f, (float)7.97f, (float)26.29f));
        this.mane.offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-2.79f, (float)0.35f));
        this.root.offsetRotation(KeyframeAnimations.degreeVec((float)22.48072f, (float)-0.95645f, (float)132.3099f));
        this.root.offsetPos(KeyframeAnimations.posVec((float)2.0f, (float)-8.0f, (float)0.0f));
        if (this.earRight.isPresent()) {
            this.earRight.get().offsetRotation(KeyframeAnimations.degreeVec((float)37.09314f, (float)13.50103f, (float)-46.63682f));
            this.earRight.get().offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.12f, (float)0.0f));
        }
        if (this.earLeft.isPresent()) {
            this.earLeft.get().offsetRotation(KeyframeAnimations.degreeVec((float)32.49638f, (float)13.81807f, (float)-32.61916f));
            this.earLeft.get().offsetPos(KeyframeAnimations.posVec((float)0.0f, (float)-0.51f, (float)0.0f));
        }
    }

    public void translateShakingDog(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.mane.zRot = dog.getShakeAngle(partialTickTime, -0.08f);
        this.body.zRot = dog.getShakeAngle(partialTickTime, -0.16f);
        this.realTail.zRot = dog.getShakeAngle(partialTickTime, -0.2f);
    }

    public void translateBeggingDog(Dog dog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.realHead.zRot = dog.getInterestedAngle(partialTickTime) + dog.getShakeAngle(partialTickTime, 0.0f);
    }

    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        DogPose pose = dog.getDogPose();
        DogAnimationManager animationManager = dog.animationManager;
        if (dog.isDogInAnimDebug() && dog.getAnim().isNone()) {
            this.setDogUpDebugAnim(dog);
            return;
        }
        if (pose.freeHead) {
            this.head.xRot += headPitch * ((float)Math.PI / 180);
            this.head.yRot = this.head.yRot + netHeadYaw * (dog.isInSittingPose() && dog.isLying() ? 0.005f : (float)Math.PI / 180);
        }
        if (pose.freeTail) {
            this.tail.xRot = dog.getTailRotation();
            this.tail.yRot = dog.getWagAngle(limbSwing, limbSwingAmount, ageInTicks);
        }
        DogAnimationState animState = animationManager.animationState;
        DogAnimation anim = dog.getAnim();
        if (anim == DogAnimation.NONE) {
            return;
        }
        AnimationDefinition sequence = this.getAnimationSequence(anim);
        if (sequence == null) {
            return;
        }
        if (pose.freeHead && anim.freeHead()) {
            this.headXRot0 = this.head.xRot;
            this.headYRot0 = this.head.yRot;
            this.realHeadZRot0 = this.realHead.zRot;
        } else if (pose.freeHead && anim.freeHeadXRotOnly()) {
            this.headXRot0 = this.head.xRot;
        }
        anim.rootRotation().ifPresent(x -> this.root.yRot += x.floatValue() * ((float)Math.PI / 180));
        if (animState.isStarted()) {
            animState.updateTime(ageInTicks, anim.getSpeedModifier());
            DogKeyframeAnimations.animate(this, dog, sequence, animState.getAccumulatedTimeMillis(), 1.0f, this.vecObj);
        }
    }

    private void setDogUpDebugAnim(Dog dog) {
        this.resetAllPose();
        DogAnimationManager.DogAnimDebugState debug_state = dog.getDogAnimDebugState();
        DogAnimation dog_anim = debug_state.anim();
        AnimationDefinition sequence = DogAnimationRegistry.getSequence(dog_anim);
        if (sequence == null) {
            return;
        }
        long timestamp_millis = Util.tickMayWithPartialToMillis(debug_state.timestamp());
        DogKeyframeAnimations.animate(this, dog, sequence, timestamp_millis, 1.0f, this.vecObj);
    }

    protected AnimationDefinition getAnimationSequence(DogAnimation anim) {
        return DogAnimationRegistry.getSequence(anim);
    }

    public void resetAllPose() {
        this.root.getAllParts().forEach(x -> x.resetPose());
        this.realHead.resetPose();
        this.realTail.resetPose();
        this.earLeft.ifPresent(ear -> ear.resetPose());
        this.earRight.ifPresent(ear -> ear.resetPose());
    }

    public void copyFrom(DogModel dogModel) {
        this.root.copyFrom(dogModel.root);
        this.head.copyFrom(dogModel.head);
        this.realHead.copyFrom(dogModel.realHead);
        this.body.copyFrom(dogModel.body);
        this.mane.copyFrom(dogModel.mane);
        this.legBackRight.copyFrom(dogModel.legBackRight);
        this.legBackLeft.copyFrom(dogModel.legBackLeft);
        this.legFrontRight.copyFrom(dogModel.legFrontRight);
        this.legFrontLeft.copyFrom(dogModel.legFrontLeft);
        this.tail.copyFrom(dogModel.tail);
        this.realTail.copyFrom(dogModel.realTail);
    }

    public void resetPart(ModelPart part, Dog dog) {
        if (part == this.tail && dog.getAnim().freeTail()) {
            this.tail.resetPose();
            this.tail.xRot = dog.getTailRotation();
            return;
        }
        if (part == this.head && dog.getAnim().freeHead() && dog.getDogPose().freeHead) {
            this.head.resetPose();
            this.head.xRot = this.headXRot0;
            this.head.yRot = this.headYRot0;
            this.realHead.resetPose();
            this.realHead.zRot = this.realHeadZRot0;
            return;
        }
        if (part == this.head && dog.getAnim().convertHeadZRot()) {
            this.head.resetPose();
            this.head.xRot = this.headXRot0;
            return;
        }
        part.resetPose();
    }

    public void adjustAnimatedPart(ModelPart part, Dog dog) {
        if (part == this.tail && dog.getAnim().freeTail() && part.xRot > 3.0f) {
            part.xRot = 3.0f;
        }
        if (part == this.head && part.zRot != 0.0f && dog.getAnim().convertHeadZRot()) {
            this.realHead.zRot = part.zRot;
            part.zRot = 0.0f;
        }
    }

    public Optional<ModelPart> searchForPartWithName(String name) {
        return DogKeyframeAnimations.searchForPartWithName(this.root, name);
    }

    protected void correctInitalPose() {
        PartPose tailPose = this.tail.getInitialPose();
        float tailX = tailPose.x;
        float tailY = tailPose.y;
        float tailZ = tailPose.z;
        this.tail.setInitialPose(PartPose.offset((float)tailX, (float)tailY, (float)tailZ));
    }

    public boolean acessoryShouldRender(Dog dog, AccessoryInstance inst) {
        return true;
    }

    public boolean armorShouldRender(Dog dog) {
        return true;
    }

    public boolean incapShouldRender(Dog dog) {
        return true;
    }

    public boolean scaleBabyDog() {
        return true;
    }

    public boolean warnAccessory(Dog dog, Accessory inst) {
        return false;
    }

    @Nullable
    public Vector3f getCustomRootPivotPoint() {
        return null;
    }

    public boolean hasDefaultScale() {
        return false;
    }

    public float getDefaultScale() {
        return 1.0f;
    }

    public AccessoryState getAccessoryState() {
        return this.accessoryState;
    }

    public DogModel setAccessoryState(AccessoryState state) {
        if (state == null) {
            state = AccessoryState.HAVE_NOT_TESTED;
        }
        this.accessoryState = state;
        return this;
    }

    public void setVisible(boolean visible) {
        this.head.visible = visible;
        this.body.visible = visible;
        this.legBackRight.visible = visible;
        this.legBackLeft.visible = visible;
        this.legFrontRight.visible = visible;
        this.legFrontLeft.visible = visible;
        this.tail.visible = visible;
        this.mane.visible = visible;
    }

    public void copyPropertiesTo(EntityModel<Dog> model) {
        super.copyPropertiesTo(model);
        if (!this.scaleBabyDog()) {
            model.young = false;
        }
    }

    public void setWetShade(float shade) {
        this.wetShade = shade;
    }

    public void resetWetShade() {
        this.wetShade = 1.0f;
    }

    public void renderToBuffer(PoseStack p_102034_, VertexConsumer p_102035_, int p_102036_, int p_102037_, int color_overlay) {
        int wet_color = FastColor.ARGB32.colorFromFloat((float)1.0f, (float)this.wetShade, (float)this.wetShade, (float)this.wetShade);
        int render_color = FastColor.ARGB32.multiply((int)color_overlay, (int)wet_color);
        Vector3f pivot = DEFAULT_ROOT_PIVOT;
        Vector3f custom_pivot = this.getCustomRootPivotPoint();
        if (custom_pivot != null) {
            pivot = custom_pivot;
        }
        p_102034_.pushPose();
        p_102034_.translate((double)(this.root.x / 16.0f), (double)(this.root.y / 16.0f), (double)(this.root.z / 16.0f));
        p_102034_.translate((double)(pivot.x / 16.0f), (double)(pivot.y / 16.0f), (double)(pivot.z / 16.0f));
        if (this.root.zRot != 0.0f) {
            p_102034_.mulPose(Axis.ZP.rotation(this.root.zRot));
        }
        if (this.root.yRot != 0.0f) {
            p_102034_.mulPose(Axis.YP.rotation(this.root.yRot));
        }
        if (this.root.xRot != 0.0f) {
            p_102034_.mulPose(Axis.XP.rotation(this.root.xRot));
        }
        float xRot0 = this.root.xRot;
        float yRot0 = this.root.yRot;
        float zRot0 = this.root.zRot;
        float x0 = this.root.x;
        float y0 = this.root.y;
        float z0 = this.root.z;
        this.root.xRot = 0.0f;
        this.root.yRot = 0.0f;
        this.root.zRot = 0.0f;
        this.root.x = 0.0f;
        this.root.y = 0.0f;
        this.root.z = 0.0f;
        p_102034_.pushPose();
        p_102034_.translate((double)(-pivot.x / 16.0f), (double)(-pivot.y / 16.0f), (double)(-pivot.z / 16.0f));
        if (this.young && this.scaleBabyDog()) {
            boolean headVisible0 = this.head.visible;
            this.head.visible = false;
            p_102034_.pushPose();
            this.root.render(p_102034_, p_102035_, p_102036_, p_102037_, render_color);
            p_102034_.popPose();
            this.head.visible = headVisible0;
            p_102034_.pushPose();
            p_102034_.scale(2.0f, 2.0f, 2.0f);
            p_102034_.translate(0.0, -0.5, 0.15);
            this.head.render(p_102034_, p_102035_, p_102036_, p_102037_, render_color);
            p_102034_.popPose();
        } else {
            this.root.render(p_102034_, p_102035_, p_102036_, p_102037_, render_color);
        }
        p_102034_.popPose();
        p_102034_.popPose();
        this.root.xRot = xRot0;
        this.root.yRot = yRot0;
        this.root.zRot = zRot0;
        this.root.x = x0;
        this.root.y = y0;
        this.root.z = z0;
    }

    public static enum AccessoryState {
        NON_COMPATIBLE,
        SOME_WILL_FIT,
        HAVE_NOT_TESTED,
        RECOMMENDED,
        MODEL_ONLY;

    }
}

