/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import doggytalents.client.ClientSetup;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.model.dog.NullDogModel;
import doggytalents.client.entity.render.CollarRenderManager;
import doggytalents.client.entity.render.layer.LayerFactory;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Matrix4f;

public class DogRenderer
extends MobRenderer<Dog, DogModel> {
    private static final int TXTCLR_DIFFOWNER = 1464486474;
    private static final int TXTCLR_HEALTH_70_100 = 720707;
    private static final int TXTCLR_HEALTH_30_70 = 15727189;
    private static final int TXTCLR_HEALTH_0_30 = 0xFF3636;
    private static final int TXTCLR_HEALTH_BKG = 0x4A4A4A;
    private static final int TXCLR_SEPERATOR = -6184543;
    private DogModel defaultModel;
    private NullDogModel nullDogModel;
    private List<RenderLayer<Dog, DogModel>> originalDogLayers = List.of();

    public DogRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, null, 0.5f);
        DogModelRegistry.resolve(ctx);
        this.defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();
        for (LayerFactory<Dog, DogModel> layer : CollarRenderManager.getLayers()) {
            this.addLayer(layer.createLayer((RenderLayerParent<Dog, DogModel>)this, ctx));
        }
        this.originalDogLayers = new ArrayList<RenderLayer<Dog, DogModel>>(this.layers);
        this.nullDogModel = new NullDogModel(ctx.bakeLayer(ClientSetup.DOG_NULL));
        this.model = this.nullDogModel;
    }

    protected float getBob(Dog livingBase, float partialTicks) {
        return super.getBob((LivingEntity)livingBase, partialTicks);
    }

    public void render(Dog dog, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        DogSkin skin = dog.getClientSkin();
        this.model = skin.useCustomModel() ? dog.getClientSkin().getCustomModel().getValue() : this.defaultModel;
        ((DogModel)this.model).resetWetShade();
        if (dog.isDogSoaked() && !dog.dogVariant().preventWetShade()) {
            float f = dog.getShadingWhileWet(partialTicks);
            ((DogModel)this.model).setWetShade(f);
        }
        if (((Boolean)ConfigHandler.CLIENT.BLOCK_THIRD_PARTY_NAMETAG.get()).booleanValue()) {
            this.MobRenderer_render(dog, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        } else {
            super.render((LivingEntity)dog, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
        this.model = this.nullDogModel;
    }

    private Component getNameUnknown(Dog dogIn) {
        return Component.translatable((String)(dogIn.getOwnerUUID() != null ? "entity.doggytalents.dog.unknown_owner" : "entity.doggytalents.dog.untamed"));
    }

    public ResourceLocation getTextureLocation(Dog dogIn) {
        return DogTextureManager.INSTANCE.getTexture(dogIn);
    }

    protected void scale(Dog dogIn, PoseStack matrixStackIn, float partialTickTime) {
        DogModel model;
        float size = dogIn.isBaby() ? 0.5f : dogIn.getDogSize().getScale();
        this.shadowRadius = size * 0.5f;
        DogSkin skin = dogIn.getClientSkin();
        if (skin.useCustomModel() && (model = skin.getCustomModel().getValue()).hasDefaultScale()) {
            float default_scale = model.getDefaultScale();
            matrixStackIn.scale(default_scale, default_scale, default_scale);
            this.shadowRadius *= default_scale;
        }
    }

    protected boolean shouldShowName(Dog dog) {
        if (((Boolean)ConfigHandler.CLIENT.ALWAYS_RENDER_DOG_NAME.get()).booleanValue() && !dog.isVehicle()) {
            return true;
        }
        return super.shouldShowName((Mob)dog);
    }

    protected void renderNameTag(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int packedLight, float pTicks) {
        boolean isDiffOwner;
        double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)dog);
        LocalPlayer player = Minecraft.getInstance().player;
        boolean renderDiffOwnerName = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_DIFFOWNER_NAME_DIFFERENT) != false && dog != this.entityRenderDispatcher.crosshairPickEntity;
        boolean bl = isDiffOwner = player == null || !Objects.equals(player.getUUID(), dog.getOwnerUUID());
        if (isDiffOwner && ((Boolean)ConfigHandler.CLIENT.DONT_RENDER_DIFFOWNER_NAME.get()).booleanValue()) {
            return;
        }
        if (ClientHooks.isNameplateInRenderDistance((Entity)dog, (double)d0)) {
            this.renderMainName(dog, text, stack, buffer, packedLight, renderDiffOwnerName && isDiffOwner, isDiffOwner, !isDiffOwner && WhistleItem.isHoldingDutyWhistle((LivingEntity)player));
        }
        if (d0 <= 4096.0) {
            this.renderExtraInfo(dog, text, stack, buffer, packedLight, d0, renderDiffOwnerName && isDiffOwner, isDiffOwner);
        }
    }

    private void renderMainName(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int light, boolean diffOwnerRender, boolean isDiffOwner, boolean renderDogOnDuty) {
        text = this.modifyMainText(dog, text, diffOwnerRender, renderDogOnDuty);
        this.renderDogText(dog, text, 0.0, 0.025f, stack, buffer, light, diffOwnerRender, isDiffOwner);
    }

    private int getBkgTextColorWithOpacity(boolean diffOwnerRender) {
        boolean color = false;
        float bkg_opacity = 0.0f;
        if (!diffOwnerRender) {
            bkg_opacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        }
        int alpha = (int)(bkg_opacity * 255.0f) << 24;
        return alpha | 0;
    }

    private void renderDogText(Dog dog, Component text, double y_offset_from_default, float scale, PoseStack stack, MultiBufferSource buffer, int light, boolean render_diffowner, boolean is_diffowner) {
        boolean dog_not_sneaking = !dog.isDiscrete();
        double render_y_offset = (double)(dog.getBbHeight() + 0.5f) + y_offset_from_default;
        stack.pushPose();
        stack.translate(0.0, render_y_offset, 0.0);
        stack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        stack.scale(scale, -scale, scale);
        Matrix4f pose = stack.last().pose();
        Font font = this.getFont();
        float tX = -font.width((FormattedText)text) / 2;
        float tY = 0.0f;
        boolean bkg_see_through = dog_not_sneaking && !is_diffowner && (Boolean)ConfigHandler.CLIENT.SHOW_DOG_NAME_THRU_WALL.get() != false;
        Font.DisplayMode bkg_display_mode = bkg_see_through ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL;
        int bkg_color = this.getBkgTextColorWithOpacity(render_diffowner);
        int bkg_txtcolor = 0x20FFFFFF;
        font.drawInBatch(text, tX, tY, bkg_txtcolor, false, pose, buffer, bkg_display_mode, bkg_color, light);
        stack.translate(0.0, 0.0, 0.1);
        boolean draw_fg_text = dog_not_sneaking;
        if (draw_fg_text) {
            Font.DisplayMode fg_display_mode = Font.DisplayMode.NORMAL;
            int fg_color = 0;
            int fg_txtcolor = -1;
            font.drawInBatch(text, tX, tY, fg_txtcolor, false, pose, buffer, fg_display_mode, fg_color, light);
        }
        stack.popPose();
    }

    private void renderExtraInfo(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int packedLight, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        this.renderInfoDogText(dog, text, stack, buffer, packedLight, d0, diffOwnerRender, isDiffOwner);
        this.renderSecondaryInfoDogText(dog, text, stack, buffer, packedLight, d0, diffOwnerRender, isDiffOwner);
    }

    private void renderInfoDogText(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int packedLight, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        boolean renderHealthInNameActivated = this.entityRenderDispatcher.camera.getEntity().isShiftKeyDown() && (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_HEALTH_IN_NAME) != false;
        String seperator = (String)ConfigHandler.CLIENT.DOG_INFO_SEPERATOR.get();
        MutableComponent seperator_c1 = this.createC1WithColor(seperator, -6184543);
        MutableComponent extra_info_c1 = Component.translatable((String)dog.getMode().getTip());
        Optional<Component> hunger_c1_optional = this.getHungerC1(dog, renderHealthInNameActivated);
        Optional<Component> gender_c1_optional = this.getGenderC1(dog);
        if (hunger_c1_optional.isPresent()) {
            extra_info_c1.append((Component)seperator_c1);
            Component hunger_c1 = hunger_c1_optional.get();
            extra_info_c1.append(hunger_c1);
        }
        if (gender_c1_optional.isPresent()) {
            extra_info_c1.append((Component)seperator_c1);
            Component gender_c1 = gender_c1_optional.get();
            extra_info_c1.append(gender_c1);
        }
        if (diffOwnerRender) {
            extra_info_c1 = this.createC1WithColor((Component)extra_info_c1, 1464486474);
        }
        this.renderDogText(dog, (Component)extra_info_c1, 0.12f, 0.01f, stack, buffer, packedLight, diffOwnerRender, isDiffOwner);
    }

    private void renderSecondaryInfoDogText(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int packedLight, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        if (d0 > 25.0) {
            return;
        }
        Entity camera_entity = this.entityRenderDispatcher.camera.getEntity();
        if (!camera_entity.isShiftKeyDown()) {
            return;
        }
        if (dog.getOwner() == camera_entity) {
            return;
        }
        Component ownerC0 = dog.getOwnersName().orElseGet(() -> this.getNameUnknown(dog));
        if (diffOwnerRender) {
            ownerC0 = this.createC1WithColor(ownerC0, 1464486474);
        }
        this.renderDogText(dog, ownerC0, -0.25, 0.01f, stack, buffer, packedLight, diffOwnerRender, isDiffOwner);
    }

    private Optional<Component> getHungerC1(Dog dog, boolean renderHealthInNameActivated) {
        boolean hightlight_red;
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue() && !dog.isDefeated()) {
            return Optional.empty();
        }
        String hunger_format = (String)ConfigHandler.CLIENT.DOG_INFO_HUNGER_FORMAT.get();
        int hunger = 0;
        hunger = dog.isDefeated() ? -dog.getDogIncapValue() : Mth.ceil((float)dog.getDogHunger());
        MutableComponent hunger_c1 = Component.literal((String)String.format(Locale.ROOT, hunger_format, hunger));
        boolean bl = hightlight_red = dog.getDogHunger() <= 10.0f && renderHealthInNameActivated || dog.isDefeated();
        if (hightlight_red) {
            hunger_c1.withStyle(Style.EMPTY.withColor(0xFF3636));
        }
        return Optional.of(hunger_c1);
    }

    private Optional<Component> getGenderC1(Dog dog) {
        if (((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER)).booleanValue()) {
            return Optional.empty();
        }
        MutableComponent ret = Component.translatable((String)dog.getGender().getUnlocalisedTip());
        return Optional.of(ret);
    }

    private Component modifyMainText(Dog dog, Component text, boolean diffOwnerRender, boolean renderDogOnDuty) {
        boolean renderHealthInNameActive;
        if (diffOwnerRender) {
            text = this.createC1WithColor(text, 1464486474);
            return text;
        }
        if (renderDogOnDuty) {
            if (dog.dogOnDuty()) {
                text = this.createC1WithColor(text, -61191);
            }
            return text;
        }
        if (dog.isDogInAnimDebug()) {
            text = this.createC1WithColor(text, -3299584);
            return text;
        }
        boolean bl = renderHealthInNameActive = this.entityRenderDispatcher.camera.getEntity().isShiftKeyDown() && (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_HEALTH_IN_NAME) != false;
        if (renderHealthInNameActive) {
            text = this.colorTextWithHealth(dog, text);
        }
        return text;
    }

    private Component colorTextWithHealth(Dog dog, Component text) {
        int noCharsInName = text.getString().length();
        float healthPercentage = dog.getHealth() / dog.getMaxHealth();
        healthPercentage = Mth.clamp((float)healthPercentage, (float)0.0f, (float)1.0f);
        int noCharHighlighted = Mth.ceil((float)((float)noCharsInName * healthPercentage));
        noCharHighlighted = Mth.clamp((int)noCharHighlighted, (int)0, (int)noCharsInName);
        String hlPart = text.getString().substring(0, noCharHighlighted);
        String nonHlPart = "";
        if (noCharHighlighted <= noCharsInName) {
            nonHlPart = text.getString().substring(noCharHighlighted, noCharsInName);
        }
        int color = 0xFF3636;
        if ((double)healthPercentage >= 0.7) {
            color = 720707;
        } else if ((double)healthPercentage >= 0.3) {
            color = 15727189;
        }
        MutableComponent newTxt = this.createC1WithColor(hlPart, color);
        MutableComponent restTxt = this.createC1WithColor(nonHlPart, 0x4A4A4A);
        newTxt.append((Component)restTxt);
        text = newTxt;
        return text;
    }

    private MutableComponent createC1WithColor(String str, int color) {
        return Component.literal((String)str).withStyle(Style.EMPTY.withColor(color));
    }

    private MutableComponent createC1WithColor(Component c1, int color) {
        return this.createC1WithColor(c1.getString(), color);
    }

    public void MobRenderer_render(Dog p_115455_, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        this.LivingEntityRenderer_render(p_115455_, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
    }

    public void LivingEntityRenderer_render(Dog p_115308_, float p_115309_, float p_115310_, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_) {
        boolean shouldSit;
        p_115311_.pushPose();
        ((DogModel)this.model).attackTime = this.getAttackAnim((LivingEntity)p_115308_, p_115310_);
        ((DogModel)this.model).riding = shouldSit = p_115308_.isPassenger() && p_115308_.getVehicle() != null && p_115308_.getVehicle().shouldRiderSit();
        ((DogModel)this.model).young = p_115308_.isBaby();
        float f = Mth.rotLerp((float)p_115310_, (float)p_115308_.yBodyRotO, (float)p_115308_.yBodyRot);
        float f1 = Mth.rotLerp((float)p_115310_, (float)p_115308_.yHeadRotO, (float)p_115308_.yHeadRot);
        float f2 = f1 - f;
        if (shouldSit && p_115308_.getVehicle() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_115308_.getVehicle();
            f = Mth.rotLerp((float)p_115310_, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)p_115310_, (float)p_115308_.xRotO, (float)p_115308_.getXRot());
        float f7 = this.getBob(p_115308_, p_115310_);
        this.setupRotations(p_115308_, p_115311_, f7, f, p_115310_, p_115308_.getScale());
        p_115311_.scale(-1.0f, -1.0f, 1.0f);
        this.scale(p_115308_, p_115311_, p_115310_);
        p_115311_.translate(0.0f, -1.501f, 0.0f);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && p_115308_.isAlive()) {
            f8 = p_115308_.walkAnimation.speed(p_115310_);
            f5 = p_115308_.walkAnimation.position(p_115310_);
            if (p_115308_.isBaby()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((DogModel)this.model).prepareMobModel(p_115308_, f5, f8, p_115310_);
        ((DogModel)this.model).setupAnim(p_115308_, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = this.isBodyVisible((LivingEntity)p_115308_);
        boolean flag1 = !flag && !p_115308_.isInvisibleTo((Player)minecraft.player);
        boolean flag2 = minecraft.shouldEntityAppearGlowing((Entity)p_115308_);
        RenderType rendertype = this.getRenderType((LivingEntity)p_115308_, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = p_115312_.getBuffer(rendertype);
            int i = DogRenderer.getOverlayCoords((LivingEntity)p_115308_, (float)this.getWhiteOverlayProgress((LivingEntity)p_115308_, p_115310_));
            ((DogModel)this.model).renderToBuffer(p_115311_, vertexconsumer, p_115313_, i, flag1 ? 0x26FFFFFF : -1);
        }
        if (!p_115308_.isSpectator()) {
            for (RenderLayer<Dog, DogModel> renderlayer : this.originalDogLayers) {
                renderlayer.render(p_115311_, p_115312_, p_115313_, (Entity)p_115308_, f5, f8, p_115310_, f7, f2, f6);
            }
        }
        p_115311_.popPose();
        if (this.shouldShowName(p_115308_)) {
            this.renderNameTag(p_115308_, p_115308_.getDisplayName(), p_115311_, p_115312_, p_115313_, p_115310_);
        }
    }

    protected void setupRotations(Dog p_115317_, PoseStack p_115318_, float p_115319_, float p_115320_, float p_115321_, float x) {
        if (((Boolean)ConfigHandler.CLIENT.BLOCK_THIRD_PARTY_NAMETAG.get()).booleanValue()) {
            if (p_115317_.deathTime > 0) {
                float f = ((float)p_115317_.deathTime + p_115321_ - 1.0f) / 20.0f * 1.6f;
                if ((f = Mth.sqrt((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                p_115318_.mulPose(Axis.ZP.rotationDegrees(f * this.getFlipDegrees((LivingEntity)p_115317_)));
            } else {
                p_115318_.mulPose(Axis.YP.rotationDegrees(180.0f - p_115320_));
            }
            return;
        }
        super.setupRotations((LivingEntity)p_115317_, p_115318_, p_115319_, p_115320_, p_115321_, x);
    }
}

