/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class RenderUtil {
    public static <T extends Entity> void renderLabelWithScale(T entity, EntityRenderer<T> renderer, EntityRenderDispatcher entityRenderDispatcher, Component text, PoseStack stack, MultiBufferSource buffer, int packedLightIn, float scale, float yChange, boolean renderBkg) {
        RenderUtil.renderLabelWithScale(!entity.isDiscrete(), renderer, entityRenderDispatcher, text, stack, buffer, packedLightIn, scale, yChange + entity.getBbHeight() + 0.5f, renderBkg);
    }

    public static <T extends Entity> void renderLabelWithScale(T entity, EntityRenderer<T> renderer, EntityRenderDispatcher entityRenderDispatcher, String text, PoseStack stack, MultiBufferSource buffer, int packedLightIn, float scale, float yChange, boolean renderBkg) {
        RenderUtil.renderLabelWithScale(!entity.isDiscrete(), renderer, entityRenderDispatcher, (Component)Component.literal((String)text), stack, buffer, packedLightIn, scale, yChange + entity.getBbHeight() + 0.5f, renderBkg);
    }

    public static void renderLabelWithScale(boolean flag, EntityRenderer renderer, EntityRenderDispatcher entityRenderDispatcher, Component text, PoseStack stack, MultiBufferSource buffer, int packedLightIn, float scale, float yOffset, boolean renderBkg) {
        stack.pushPose();
        stack.translate(0.0, (double)yOffset, 0.0);
        stack.mulPose(entityRenderDispatcher.cameraOrientation());
        stack.scale(-scale, -scale, scale);
        Matrix4f matrix4f = stack.last().pose();
        float f1 = renderBkg ? Minecraft.getInstance().options.getBackgroundOpacity(0.25f) : 0.0f;
        int j = (int)(f1 * 255.0f) << 24;
        Font fontrenderer = renderer.getFont();
        float f2 = (float)(-fontrenderer.width((FormattedText)text)) / 2.0f;
        fontrenderer.drawInBatch(text, f2, 0.0f, 0x20FFFFFF, false, matrix4f, buffer, flag ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, j, packedLightIn);
        if (flag) {
            fontrenderer.drawInBatch(text, f2, 0.0f, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLightIn);
        }
        stack.popPose();
    }

    public static int rgbToInt(int[] rgb) {
        return rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public static int[] intToRgb(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        return new int[]{r, g, b};
    }
}

