/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.AmnesiaBoneScreen.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.screen.AmnesiaBoneScreen.screen.KillStatsClearConfirmScreen;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.ForceChangeOwnerData;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;

public class DogForceMigrateOwnerScreen
extends Screen {
    Dog dog;

    protected DogForceMigrateOwnerScreen(Dog dog) {
        super((Component)Component.literal((String)""));
        this.dog = dog;
    }

    public static void open(Dog dog) {
        Minecraft mc = Minecraft.getInstance();
        DogForceMigrateOwnerScreen screen = new DogForceMigrateOwnerScreen(dog);
        mc.setScreen((Screen)screen);
    }

    protected void init() {
        this.addForceChangeButton();
        KillStatsClearConfirmScreen.addClearKillStatsButton(this.dog, this.font, this.width / 2, this.height / 2 + 40, b -> this.addRenderableWidget((GuiEventListener)b));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        super.render(graphics, mouseX, mouseY, pTicks);
        PoseStack stack = graphics.pose();
        int mX = this.width / 2;
        int mY = this.height / 2;
        int pY = mY - 72;
        MutableComponent title = Component.translatable((String)"doggui.force_migrate_owner.confirm.title").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED));
        String help = I18n.get((String)"doggui.force_migrate_owner.confirm.subtitle", (Object[])new Object[]{this.dog.getGenderPronoun().getString()});
        String dog_title = I18n.get((String)"doggui.invalid_dog.info.dog", (Object[])new Object[]{this.dog.getName().getString()});
        String owner_title = I18n.get((String)"doggui.invalid_dog.info.owner", (Object[])new Object[]{this.dog.getOwnersName().orElse((Component)Component.literal((String)"")).getString()});
        String escToReturn = I18n.get((String)"doggui.invalid_dog.esc_to_return", (Object[])new Object[0]);
        stack.pushPose();
        stack.scale(1.2f, 1.2f, 1.2f);
        graphics.drawString(this.font, (Component)title, Mth.floor((float)((float)mX / 1.2f - (float)(this.font.width((FormattedText)title) / 2))), Mth.floor((float)((float)pY / 1.2f)), -1);
        stack.popPose();
        graphics.drawString(this.font, help, mX - this.font.width(help) / 2, pY += 40, -1);
        graphics.drawString(this.font, dog_title, mX - this.font.width(dog_title) / 2, pY += 40, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, owner_title, mX - this.font.width(owner_title) / 2, pY += 9 + 3, -1);
        graphics.drawString(this.font, escToReturn, mX - this.font.width(escToReturn) / 2, pY += 80, -1);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void addForceChangeButton() {
        CustomButton untameButton = new CustomButton(this.width / 2 - 25, this.height / 2 + 58, 50, 20, (Component)Component.translatable((String)"doggui.untame.confirm.confirmed"), b -> {
            this.requestForceChange();
            Minecraft.getInstance().setScreen(null);
        });
        this.addRenderableWidget((GuiEventListener)untameButton);
    }

    private void requestForceChange() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new ForceChangeOwnerData(this.dog.getId()));
    }
}

