/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.screen.DogNewInfoScreen.DogNewInfoScreen;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.framework.widget.TextOnlyButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.lib.Resources;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogIncapMsgData;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class DogCannotInteractWithScreen
extends Screen {
    Dog dog;
    private TextOnlyButton showIncapStrButton;
    private Font font;

    protected DogCannotInteractWithScreen(Dog dog) {
        super((Component)Component.literal((String)""));
        this.dog = dog;
        this.font = Minecraft.getInstance().font;
    }

    public static void open(Dog dog) {
        Minecraft mc = Minecraft.getInstance();
        DogCannotInteractWithScreen screen = new DogCannotInteractWithScreen(dog);
        mc.setScreen((Screen)screen);
        LocalPlayer player = mc.player;
        if (dog.getOwner() == player) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogIncapMsgData.Request(dog.getId()));
        }
    }

    protected void init() {
        MutableComponent showCause = Component.translatable((String)"doggui.invalid_dog.incapacitated.show_cause").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
        int n = this.font.width((FormattedText)showCause) + 5;
        Objects.requireNonNull(this.font);
        this.showIncapStrButton = new TextOnlyButton(0, 0, n, 9 + 3, (Component)showCause, b -> {}, this.font){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (!this.isHovered) {
                    return;
                }
                String msg = DogCannotInteractWithScreen.this.dog.incapacitatedMananger.getIncapMsg();
                List<Component> msgList = ScreenUtil.splitInto(msg, 150, DogCannotInteractWithScreen.this.font);
                graphics.renderComponentTooltip(DogCannotInteractWithScreen.this.font, msgList, mouseX, mouseY);
            }
        };
        this.addRenderableWidget((GuiEventListener)this.showIncapStrButton);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        PoseStack stack = graphics.pose();
        super.render(graphics, mouseX, mouseY, pTicks);
        if (this.dog.isDefeated()) {
            this.showIncapStrButton.visible = true;
            this.renderIncapScreen(graphics, mouseX, mouseY, pTicks);
            return;
        }
        this.showIncapStrButton.visible = false;
        if (this.dog.canInteract((LivingEntity)Minecraft.getInstance().player)) {
            DogNewInfoScreen.open(this.dog);
            return;
        }
        MutableComponent title = Component.translatable((String)"doggui.invalid_dog.no_permission.title", (Object[])new Object[]{this.dog.getName().getString()}).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED));
        String help = I18n.get((String)"doggui.invalid_dog.no_permission.subtitle", (Object[])new Object[]{this.dog.getGenderPronoun().getString()});
        String dog_title = I18n.get((String)"doggui.invalid_dog.info.dog", (Object[])new Object[]{this.dog.getName().getString()});
        String owner_title = I18n.get((String)"doggui.invalid_dog.info.owner", (Object[])new Object[]{this.dog.getOwnersName().orElse((Component)Component.literal((String)"")).getString()});
        int mX = this.width / 2;
        int mY = this.height / 2;
        int pY = mY - 72;
        String escToReturn = I18n.get((String)"doggui.invalid_dog.esc_to_return", (Object[])new Object[0]);
        stack.pushPose();
        stack.scale(1.2f, 1.2f, 1.2f);
        graphics.drawString(this.font, (Component)title, Mth.floor((float)((float)mX / 1.2f - (float)(this.font.width((FormattedText)title) / 2))), Mth.floor((float)((float)pY / 1.2f)), -1);
        stack.popPose();
        graphics.drawString(this.font, help, mX - this.font.width(help) / 2, pY += 40, -1);
        graphics.drawString(this.font, dog_title, mX - this.font.width(dog_title) / 2, pY += 40, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, owner_title, mX - this.font.width(owner_title) / 2, pY += 9 + 3, -1);
        graphics.drawString(this.font, escToReturn, mX - this.font.width(escToReturn) / 2, pY += 40, -1);
    }

    private void renderIncapScreen(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        PoseStack stack = graphics.pose();
        int pX = this.width / 2;
        int mY = this.height / 2;
        int pY = mY - 44;
        MutableComponent title = Component.translatable((String)"doggui.invalid_dog.incapacitated.title").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED));
        String help = I18n.get((String)"doggui.invalid_dog.incapacitated.subtitle", (Object[])new Object[]{this.dog.getName().getString(), this.dog.getGenderPronoun().getString(), this.dog.getGenderSubject().getString(), this.dog.getGenderPossessiveAdj().getString()});
        String escToReturn = I18n.get((String)"doggui.invalid_dog.esc_to_return", (Object[])new Object[0]);
        List lines1 = this.font.split((FormattedText)title, 120);
        List lines2 = this.font.split((FormattedText)Component.literal((String)help), 150);
        int n = lines1.size() * 14 + 7;
        Objects.requireNonNull(this.font);
        int n2 = n + 9 + 3 + 15;
        int n3 = lines2.size();
        Objects.requireNonNull(this.font);
        int sizeYtotal = n2 + n3 * (9 + 3);
        pY = this.height / 2 - sizeYtotal / 2 + 1;
        for (FormattedCharSequence line : lines1) {
            stack.pushPose();
            stack.scale(1.2f, 1.2f, 1.2f);
            graphics.drawString(this.font, line, Mth.floor((float)((float)pX / 1.2f)), Mth.floor((float)((float)pY / 1.2f)), -1);
            stack.popPose();
            pY += 14;
        }
        this.showIncapStrButton.setX(pX);
        this.showIncapStrButton.setY(pY += 7);
        Objects.requireNonNull(this.font);
        pY += 9 + 3;
        pY += 15;
        for (FormattedCharSequence line : lines2) {
            graphics.drawString(this.font, line, pX, pY, -1);
            Objects.requireNonNull(this.font);
            pY += 9 + 3;
        }
        int escTX = this.width / 2 - this.font.width(escToReturn) / 2;
        int escTY = this.height / 2 + 100;
        graphics.drawString(this.font, escToReturn, escTX, escTY, -1);
        this.drawDefeatedKanji(graphics, pX - 135, mY - 64, 128);
    }

    private void drawDefeatedKanji(GuiGraphics graphics, int x, int y, int size) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int imgeSize = size;
        graphics.blit(DogCannotInteractWithScreen.getDefeatedKanji(this.dog), x, y, 0, 0.0f, 0.0f, imgeSize, imgeSize, imgeSize, imgeSize);
        RenderSystem.disableBlend();
    }

    public static ResourceLocation getDefeatedKanji(Dog dog) {
        DogIncapacitatedMananger.IncapacitatedSyncState state = dog.getIncapSyncState();
        DogIncapacitatedMananger.DefeatedType cause = state.type;
        switch (cause) {
            case BLOOD: {
                return Resources.KANJI_INCAP_BLOOD;
            }
            case BURN: {
                return Resources.KANJI_INCAP_BURN;
            }
            case DROWN: {
                return Resources.KANJI_INCAP_DROWN;
            }
            case POISON: {
                return Resources.KANJI_INCAP_POISON;
            }
            case STARVE: {
                return Resources.KANJI_INCAP_STARVE;
            }
        }
        return Resources.KANJI_INCAP_BLOOD;
    }

    public boolean isPauseScreen() {
        return false;
    }
}

