/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DogGoBehindOwnerAction
extends TriggerableAction {
    @Nonnull
    private final LivingEntity owner;
    private BlockPos targetPos = null;
    private int holdTimeLeft;

    public DogGoBehindOwnerAction(Dog dog, @Nonnull LivingEntity owner) {
        super(dog, false, false);
        this.owner = owner;
    }

    @Override
    public void onStart() {
        if (!this.owner.isAlive() || this.owner.distanceToSqr((Entity)this.dog) > 256.0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.getBehindOwnerPos();
        if (this.targetPos == null) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.dog.getNavigation().stop();
        DogUtil.moveToIfReachOrElse(this.dog, this.targetPos, this.dog.getUrgentSpeedModifier(), 1, 1, d -> {
            this.targetPos = null;
        });
        if (this.targetPos == null) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.holdTimeLeft = 40;
    }

    @Override
    public void tick() {
        if (this.targetPos == null) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.dog.getNavigation().isDone()) {
            --this.holdTimeLeft;
        }
        if (this.holdTimeLeft <= 0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
    }

    @Override
    public void onStop() {
    }

    private void getBehindOwnerPos() {
        Vec3 owner_pos0 = this.owner.position();
        float a1 = this.owner.getYHeadRot();
        float dx1 = Mth.sin((float)(a1 * ((float)Math.PI / 180)));
        float dz1 = -Mth.cos((float)(a1 * ((float)Math.PI / 180)));
        Vec3 vec_back = new Vec3((double)dx1, 0.0, (double)dz1);
        double pX = owner_pos0.x;
        double pY = owner_pos0.y;
        double pZ = owner_pos0.z;
        BlockPos bpos = null;
        BlockState state = null;
        BlockState state_below = null;
        for (int i = 0; i < 3; ++i) {
            bpos = BlockPos.containing((double)(pX += vec_back.x), (double)pY, (double)(pZ += vec_back.z));
            state = this.dog.level().getBlockState(bpos);
            if (!state.isAir()) {
                pY += 1.0;
                continue;
            }
            state_below = this.dog.level().getBlockState(bpos.below());
            if (!state_below.isAir()) continue;
            pY -= 1.0;
        }
        bpos = BlockPos.containing((double)pX, (double)pY, (double)pZ);
        state = this.dog.level().getBlockState(bpos);
        this.targetPos = state != null && state.isAir() ? bpos : null;
    }
}

